/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.sbb.declare;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DrawBackDeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.tcetr.business.draft.CktsDraftService;
import kd.taxc.tcetr.business.model.DrawBackDeclareHeader;
import kd.taxc.tcetr.business.sbb.DeclareQueryListService;
import kd.taxc.tcetr.business.sbb.DeclareService;
import kd.taxc.tcetr.formplugin.draft.CktsDraftSbbStatusUtils;
import kd.taxc.tcetr.formplugin.sbb.fetch.DrawBackInFetchDataPlugin;
import kd.taxc.tcetr.formplugin.sbb.fetch.DrawBackOutFetchDataPlugin;
import org.apache.commons.collections.CollectionUtils;

public class TcetrWmqyDeclareEditPlugin
extends AbstractBillPlugIn {
    private DeclareService service = new DeclareService();
    private static final String ORGID_KEY = "orgid";
    private static final String ORG_SEL = "org";
    private static final String ENTITY_NAME = "tcetr_declare_main";
    private static final String CREATESBB = "createsbb";
    private static final String PKIDS = "pkids";
    private static final String MONTH = "month";
    private static final String BATCHNO = "batchno";
    private static final String OUT_ENTRY = "entryentity";
    private static final String IN_ENTRY = "entryentity1";
    private static final String SBBID = "cache_sbbid";
    private static final String BILLNO = "cache_billno";
    private static final String SAVE_KEY = "save";
    private static final String EXPORT_SHEET = "exportsheet";
    private static final String SUBMIT_KEY = "submit";
    private static final String UNSUBMIT_KEY = "unsubmit";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT_KEY = "unaudit";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    private DrawBackOutFetchDataPlugin drawBackOutFetchDataPlugin = new DrawBackOutFetchDataPlugin();
    private DrawBackInFetchDataPlugin drawBackInFetchDataPlugin = new DrawBackInFetchDataPlugin();

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeBindData(EventObject e) {
        String initialed = this.getPageCache().get("initialed");
        if (StringUtils.isBlank((CharSequence)initialed)) {
            this.getModel().clearNoDataRow();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Boolean createsbb = customParams.getOrDefault(CREATESBB, false);
            if (createsbb.booleanValue()) {
                DrawBackDeclareHeader header = this.initDeclareHeader(customParams);
                boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)header.getOrg().toString(), (String)"tcetr", null);
                if (checkResult) {
                    this.getModel().setValue(ORG_SEL, null);
                }
                this.initMainData(header);
                String pKids = this.getPKids(customParams);
                if (StringUtils.isNotBlank((CharSequence)pKids)) {
                    BussinessParamsVo vo = new BussinessParamsVo();
                    HashMap<String, String> extendParams = new HashMap<String, String>();
                    extendParams.put(PKIDS, pKids);
                    this.getPageCache().put(PKIDS, pKids);
                    vo.setExtendParams(extendParams);
                    List<Map<String, Object>> outData = this.drawBackOutFetchDataPlugin.query(vo);
                    this.setOutEntryData(outData);
                    List<Map<String, Object>> inData = this.drawBackInFetchDataPlugin.query(vo);
                    this.setInEntryData(inData);
                }
            }
            this.getPageCache().put("initialed", "true");
        }
    }

    public void afterBindData(EventObject e) {
        LicenseCheckServiceHelper.checkOrgAuth((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (SUBMIT_KEY.equals(key) || UNSUBMIT_KEY.equals(key) || AUDIT_KEY.equals(key) || UNAUDIT_KEY.equals(key)) {
            ValidDataResultVo submit = DeclareQueryListService.submit(Collections.singletonList(this.getModel().getValue("id")), key, ENTITY_NAME, true);
            if (!submit.getSuccess()) {
                this.getView().showTipNotification(submit.getMessage());
                args.setCancel(true);
            } else {
                this.getView().showSuccessNotification(submit.getMessage());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean createsbb = customParams.getOrDefault(CREATESBB, false);
        switch (key) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "viewdraft": {
                this.viewDraft();
                break;
            }
            case "save": {
                if (!createsbb.booleanValue()) break;
                this.writeBackDraft();
                break;
            }
            case "exportsheet": {
                this.exportSheet();
                break;
            }
        }
    }

    private void exportSheet() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String url = this.service.exportSheetResult(dataEntity);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.getView().openUrl(url);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object object;
        ChangeData[] changeData = e.getChangeSet();
        if (e.getProperty().getName().equals(ORG_SEL)) {
            object = changeData[0].getNewValue();
            if (object == null) {
                return;
            }
            DynamicObject org = (DynamicObject)object;
            String orgid = org.getString("id");
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)"tcetr", null);
            if (checkResult) {
                this.getModel().setValue(ORG_SEL, null);
            }
        }
        if (e.getProperty().getName().equals(MONTH)) {
            object = changeData[0].getNewValue();
            if (object == null) {
                return;
            }
            DrawBackDeclareHeader header = this.getDeclareHeader();
            this.initSksq(header);
        }
    }

    private void setOutEntryData(List<Map<String, Object>> outData) {
        if (CollectionUtils.isEmpty(outData)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(OUT_ENTRY);
        int[] indexes = this.getModel().batchCreateNewEntryRow(OUT_ENTRY, outData.size());
        String sbbid = this.getPageCache().get(SBBID);
        for (int index : indexes) {
            Map<String, Object> map = outData.get(index);
            this.getModel().setValue("rowno", (Object)(index + 1), index);
            this.getModel().setValue("subewblxh", (Object)(index + 1), index);
            this.getModel().setValue("subbillno", map.get("tcetr_drawback_out_detail#billno"), index);
            this.getModel().setValue("invoiceno", map.get("tcetr_drawback_out_detail#invoiceno"), index);
            this.getModel().setValue("customsno", map.get("tcetr_drawback_out_detail#customsno"), index);
            this.getModel().setValue("certificateno", map.get("tcetr_drawback_out_detail#certificateno"), index);
            this.getModel().setValue("exportdate", map.get("tcetr_drawback_out_detail#exportdate"), index);
            this.getModel().setValue("goodsno", map.get("tcetr_drawback_out_detail#goodsno"), index);
            this.getModel().setValue("goodsname", map.get("tcetr_drawback_out_detail#goodsname"), index);
            this.getModel().setValue("unit", map.get("tcetr_drawback_out_detail#unit"), index);
            this.getModel().setValue("exportamount", map.get("tcetr_drawback_out_detail#exportamount"), index);
            this.getModel().setValue("fobusd", map.get("tcetr_drawback_out_detail#fobusd"), index);
            this.getModel().setValue("declaregoods", map.get("tcetr_drawback_out_detail#declaregoods"), index);
            this.getModel().setValue("businesstype", map.get("tcetr_drawback_out_detail#businesstype"), index);
            this.getModel().setValue("remark", map.get("tcetr_drawback_out_detail#remark"), index);
            this.getModel().setValue("sbbid", (Object)sbbid, index);
        }
        this.getModel().endInit();
        this.getModel().updateCache();
        this.getView().updateView(OUT_ENTRY);
    }

    private void setInEntryData(List<Map<String, Object>> inData) {
        if (CollectionUtils.isEmpty(inData)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(IN_ENTRY);
        int[] indexes = this.getModel().batchCreateNewEntryRow(IN_ENTRY, inData.size());
        String sbbid = this.getPageCache().get(SBBID);
        for (int index : indexes) {
            Map<String, Object> map = inData.get(index);
            this.getModel().setValue("rowno1", (Object)(index + 1), index);
            this.getModel().setValue("ewblxh1", (Object)(index + 1), index);
            this.getModel().setValue("subbillno1", map.get("tcetr_drawback_in_detail#billno"), index);
            this.getModel().setValue("taxtype", map.get("tcetr_drawback_in_detail#taxtype"), index);
            this.getModel().setValue("vouchertype", map.get("tcetr_drawback_in_detail#vouchertype"), index);
            this.getModel().setValue("voucherno", map.get("tcetr_drawback_in_detail#voucherno"), index);
            this.getModel().setValue("nsrsbh1", map.get("tcetr_drawback_in_detail#nsrsbh"), index);
            this.getModel().setValue("invoicedate", map.get("tcetr_drawback_in_detail#invoicedate"), index);
            this.getModel().setValue("goodsno1", map.get("tcetr_drawback_in_detail#goodsno"), index);
            this.getModel().setValue("goodsname1", map.get("tcetr_drawback_in_detail#goodsname"), index);
            this.getModel().setValue("zzsunit", map.get("tcetr_drawback_in_detail#zzsunit"), index);
            this.getModel().setValue("amount", map.get("tcetr_drawback_in_detail#amount"), index);
            this.getModel().setValue("jsje", map.get("tcetr_drawback_in_detail#jsje"), index);
            this.getModel().setValue("taxrate", map.get("tcetr_drawback_in_detail#taxrate"), index);
            this.getModel().setValue("rebaterate", map.get("tcetr_drawback_in_detail#rebaterate"), index);
            this.getModel().setValue("remark1", map.get("tcetr_drawback_in_detail#remark"), index);
            BigDecimal jsje = (BigDecimal)this.getModel().getValue("jsje", index);
            BigDecimal rebaterate = (BigDecimal)this.getModel().getValue("rebaterate", index);
            this.getModel().setValue("rebateamount", (Object)jsje.multiply(rebaterate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), index);
            this.getModel().setValue("unit1", map.get("tcetr_drawback_in_detail#unit"), index);
            this.getModel().setValue("sbbid1", (Object)sbbid, index);
        }
        this.getModel().endInit();
        this.getModel().updateCache();
        this.getView().updateView(IN_ENTRY);
    }

    private String getPKids(Map<String, Object> customParams) {
        Boolean createsbb = (Boolean)customParams.getOrDefault(CREATESBB, false);
        if (createsbb.booleanValue()) {
            JSONArray jsonArrays = (JSONArray)customParams.get(PKIDS);
            return jsonArrays.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        DrawBackDeclareHeader header = this.getDeclareHeader();
        if (header.getMonth() == null || StringUtils.isEmpty((CharSequence)header.getBatchNo())) {
            return "";
        }
        DynamicObjectCollection query = CktsDraftService.query(header.getOrg(), header.getMonth(), header.getBatchNo());
        return query.stream().map(s -> s.getString("id")).collect(Collectors.joining(","));
    }

    private DrawBackDeclareHeader getDeclareHeader() {
        Object taxMonth;
        Object org = this.getModel().getValue(ORG_SEL);
        long orgId = 0L;
        Date month = null;
        if (org != null) {
            orgId = ((DynamicObject)org).getLong("id");
        }
        if ((taxMonth = this.getModel().getValue(MONTH)) != null) {
            month = (Date)taxMonth;
        }
        String batchno = (String)this.getModel().getValue(BATCHNO);
        DrawBackDeclareHeader header = new DrawBackDeclareHeader(orgId, "", month, batchno);
        header.setType(this.getTemplateType());
        return header;
    }

    private DrawBackDeclareHeader initDeclareHeader(Map<String, Object> customParams) {
        DrawBackDeclareHeader header;
        Boolean createsbb = (Boolean)customParams.getOrDefault(CREATESBB, false);
        if (createsbb.booleanValue()) {
            TaxResult taxorg;
            DynamicObject data;
            Object orgid = customParams.get(ORGID_KEY);
            Object month = customParams.get("sbny");
            Object batchno = customParams.get("sbpc");
            this.getModel().setValue(ORG_SEL, orgid);
            this.getModel().setValue(MONTH, month);
            this.getModel().setValue(BATCHNO, batchno);
            if (orgid != null && (data = (DynamicObject)(taxorg = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(orgid.toString()))).getData()) != null) {
                this.getModel().setValue("nsrsbh", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)data));
                this.getModel().setValue("nsrmc", (Object)TaxOrgUtil.getTaxpayer((DynamicObject)data));
            }
            header = this.getDeclareHeader();
        } else {
            DynamicObject object;
            DynamicObject org;
            Long orgId = (Long)customParams.get(ORGID_KEY);
            if (orgId == null && (org = (DynamicObject)this.getModel().getValue(ORG_SEL)) != null) {
                orgId = org.getLong("id");
            }
            if ((object = DeclareService.queryLastDeclareMain(orgId, "editing")) == null) {
                this.getModel().setValue(ORG_SEL, (Object)orgId);
                this.getModel().setValue(MONTH, null);
                this.getModel().setValue(BATCHNO, null);
                header = new DrawBackDeclareHeader(orgId, "", DrawBackDeclareHeader.DEFAULT_DATE, null);
            } else {
                TaxResult taxorg;
                DynamicObject data;
                this.getModel().setValue(ORG_SEL, (Object)orgId);
                this.getModel().setValue(MONTH, (Object)object.getDate(MONTH));
                this.getModel().setValue(BATCHNO, (Object)object.getString(BATCHNO));
                if (orgId != null && (data = (DynamicObject)(taxorg = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)orgId)).getData()) != null) {
                    this.getModel().setValue("nsrsbh", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)data));
                    this.getModel().setValue("nsrmc", (Object)TaxOrgUtil.getTaxpayer((DynamicObject)data));
                }
                header = new DrawBackDeclareHeader(orgId, "", object.getDate(MONTH), object.getString(BATCHNO));
            }
        }
        header.setType(this.getTemplateType());
        return header;
    }

    private void initMainData(DrawBackDeclareHeader header) {
        this.getModel().setValue("declarestatus", (Object)"editing");
        this.initSksq(header);
        this.getModel().setValue("type", (Object)header.getType());
        this.getModel().setValue("ewblxh", (Object)"1");
        this.getModel().setValue("creator", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("createtime", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.getModel().setValue("billstatus", (Object)"A");
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("modifytime", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        Long sbbid = this.getSbbid(header);
        this.getPageCache().put(SBBID, sbbid.toString());
        this.getModel().setValue("id", (Object)sbbid);
        String billNo = this.getBillNo(header);
        this.getPageCache().put(BILLNO, billNo);
        this.getModel().setValue("billno", (Object)billNo);
        this.getModel().setValue("sourcetype", (Object)"1");
    }

    private void initSksq(DrawBackDeclareHeader header) {
        this.getModel().setValue("skssqq", (Object)header.getSkssqq());
        this.getModel().setValue("skssqz", (Object)header.getSkssqz());
    }

    private Long getSbbid(DrawBackDeclareHeader header) {
        if (!header.canLoad()) {
            return 0L;
        }
        DynamicObject object = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
        if (object != null) {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object pkId = billShowParameter.getPkId();
            if (pkId == null) {
                billShowParameter.setPkId((Object)object.getLong("id"));
                billShowParameter.setBillStatus(BillOperationStatus.EDIT);
                billShowParameter.setStatus(OperationStatus.EDIT);
                this.getView().invokeOperation("refresh");
            }
            return object.getLong("id");
        }
        return DrawBackDeclareServiceHelper.generateSBBId(null);
    }

    private String getBillNo(DrawBackDeclareHeader header) {
        if (!header.canLoad()) {
            return "";
        }
        DynamicObject object = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
        if (object != null) {
            return object.getString("billno");
        }
        String sbbNo = DeclareServiceHelper.generateSBBNo((String)ENTITY_NAME);
        sbbNo = sbbNo.replace("MONTH", DateUtils.format((Date)header.getMonth(), (String)"yyyyMM"));
        return sbbNo;
    }

    private String getTemplateType() {
        return "drawback";
    }

    private void viewDraft() {
        DrawBackDeclareHeader header = this.getDeclareHeader();
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
        String draftPage = templateEnum.getDraftPage();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(ORGID_KEY, header.getOrg());
        customParams.put("sbny", header.getMonth());
        customParams.put("sbpc", header.getBatchNo());
        customParams.put("linkDraft", Boolean.TRUE);
        customParams.put("declarenumber", this.getPageCache().get(BILLNO));
        PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)draftPage, (IFormView)this.getView(), customParams);
    }

    private void writeBackDraft() {
        String sbbid = this.getPageCache().get(SBBID);
        String billno = this.getPageCache().get(BILLNO);
        String pkIds = this.getPageCache().get(PKIDS);
        if (StringUtil.isEmpty((CharSequence)sbbid) || StringUtil.isEmpty((CharSequence)billno) || StringUtil.isEmpty((CharSequence)pkIds)) {
            return;
        }
        String templateType = this.getTemplateType();
        CktsDraftSbbStatusUtils.updateDraftSbbMess(templateType, Arrays.stream(pkIds.split(",")).map(Long::parseLong).collect(Collectors.toList()), StringUtils.isEmpty((CharSequence)sbbid) ? 0L : Long.parseLong(sbbid), billno);
    }
}

