/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.sbb.fetch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class DrawBackOutFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        DynamicObject[] cktsDrafts;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        String pkids = (String)bussinessParamsVo.getExtendParams().get("pkids");
        if (StringUtils.isEmpty((CharSequence)pkids)) {
            return result;
        }
        List ids = Arrays.stream(pkids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        for (DynamicObject cktsDraft : cktsDrafts = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcetr_ckts_dgdj"))) {
            DynamicObjectCollection outentryentity = cktsDraft.getDynamicObjectCollection("outentryentity");
            DynamicObjectCollection invoiceentryentity = cktsDraft.getDynamicObjectCollection("invoiceentryentity");
            Map<String, List<DynamicObject>> invoiceglhMap = invoiceentryentity.stream().collect(Collectors.groupingBy(s -> s.getString("invoiceglh")));
            for (DynamicObject outEntry : outentryentity) {
                String remaks;
                List<DynamicObject> invoiceObjList = invoiceglhMap.get(outEntry.getString("goodsglh"));
                String invoiceNo = "";
                String remark = "";
                if (invoiceObjList != null && !invoiceObjList.isEmpty()) {
                    LinkedHashSet sinvoicenoSet = new LinkedHashSet(invoiceObjList.size());
                    invoiceObjList.forEach(m -> sinvoicenoSet.add(m.getString("sinvoiceno")));
                    int size = sinvoicenoSet.size();
                    if (size <= 2) {
                        invoiceNo = String.join((CharSequence)"+", sinvoicenoSet);
                    } else {
                        invoiceNo = sinvoicenoSet.stream().limit(2L).collect(Collectors.joining("+"));
                        remark = sinvoicenoSet.stream().skip(2L).collect(Collectors.joining(","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(remaks = cktsDraft.getString("remaks")))) {
                    remark = StringUtils.isNotBlank((CharSequence)remark) ? remaks + "," + remark : remaks;
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("tcetr_drawback_out_detail#billno", outEntry.get("goodsglh"));
                paramMap.put("tcetr_drawback_out_detail#invoiceno", invoiceNo);
                paramMap.put("tcetr_drawback_out_detail#customsno", outEntry.get("goodsecdnum"));
                paramMap.put("tcetr_drawback_out_detail#certificateno", outEntry.get("dlckhwzmmh1"));
                paramMap.put("tcetr_drawback_out_detail#exportdate", DateUtils.format((Date)outEntry.getDate("ckrq1")));
                paramMap.put("tcetr_drawback_out_detail#goodsno", Optional.ofNullable(outEntry.getDynamicObject("hscode")).map(s -> s.getLong("id")).orElseGet(() -> 0L));
                paramMap.put("tcetr_drawback_out_detail#goodsname", Optional.ofNullable(outEntry.getDynamicObject("hscode")).map(s -> s.getString("name")).orElseGet(() -> ""));
                paramMap.put("tcetr_drawback_out_detail#unit", Optional.ofNullable(outEntry.getDynamicObject("unit1")).map(s -> s.getLong("id")).orElseGet(() -> 0L));
                paramMap.put("tcetr_drawback_out_detail#exportamount", outEntry.getBigDecimal("exportqty"));
                paramMap.put("tcetr_drawback_out_detail#fobusd", outEntry.getBigDecimal("fobprice"));
                paramMap.put("tcetr_drawback_out_detail#declaregoods", Optional.ofNullable(outEntry.getDynamicObject("declaregoodscode")).map(s -> s.getLong("id")).orElseGet(() -> 0L));
                paramMap.put("tcetr_drawback_out_detail#remark", remark);
                paramMap.put("tcetr_drawback_out_detail#businesstype", 0L);
                result.add(paramMap);
            }
        }
        return result;
    }
}

