/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.sbb.fetch.manufacture;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class ManufactureFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        DynamicObject[] draftList;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String pkids = (String)bussinessParamsVo.getExtendParams().get("pkids");
        if (StringUtils.isEmpty((CharSequence)pkids)) {
            return result;
        }
        List ids = Arrays.stream(pkids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        for (DynamicObject draft : draftList = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcetr_manufacturer_draft"))) {
            DynamicObject exportObject = draft.getDynamicObject("exportbasedata");
            String billno = exportObject.getString("billno");
            Date exportdate = exportObject.getDate("exportdate");
            String dlckhwzmmh = draft.getString("dlckhwzmmh");
            DynamicObjectCollection exportbasedataCollection = exportObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection outentryentity = draft.getDynamicObjectCollection("outentryentity");
            DynamicObjectCollection invoiceentryentity = draft.getDynamicObjectCollection("invoiceentryentity");
            List sinvoicedetailid = invoiceentryentity.stream().map(i -> i.getLong("sinvoicedetailid")).collect(Collectors.toList());
            String selectFields = "id,items.id as itemsId,invoiceno,buyername,salertaxno,salername,issuetime as invoicedate,remark,items.goodscode as goodscode,items.goodsname as goodsname,items.unit as unit,items.num as num,items.unitprice as unitprice,items.taxrate as taxrate,items.amount as amount,items.specification as spec";
            DynamicObjectCollection simvatinvoicesCollection = QueryServiceHelper.query((String)"sim_vatinvoice", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("items.id", "in", sinvoicedetailid)});
            Map<String, DynamicObject> simVatInvoicesItemsMap = simvatinvoicesCollection.stream().collect(Collectors.toMap(s -> s.getString("itemsId"), s -> s, (k1, k2) -> k1));
            for (DynamicObject entry : outentryentity) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
                String goodsecdnum = entry.getString("goodsecdnum");
                DynamicObject invoiceObject = this.getInvoiceObject(invoiceentryentity, goodsecdnum);
                if (null != invoiceObject) {
                    DynamicObject invoiceItem = simVatInvoicesItemsMap.get(invoiceObject.getString("sinvoicedetailid"));
                    paramMap.put("tcetr_etrsc_out_detail#invoiceno", invoiceItem.getString("invoiceno"));
                    paramMap.put("tcetr_etrsc_out_detail#taxrate", invoiceObject.getBigDecimal("taxrateprop").multiply(new BigDecimal("100")));
                    paramMap.put("tcetr_etrsc_out_detail#taxrebaterate", invoiceObject.getBigDecimal("edrateprop").multiply(new BigDecimal("100")));
                    paramMap.put("tcetr_etrsc_out_detail#planallocationrate", invoiceObject.getBigDecimal("planrate").multiply(new BigDecimal("100")));
                    paramMap.put("tcetr_etrsc_out_detail#jsjg", invoiceObject.getBigDecimal("zcjsjg"));
                    paramMap.put("tcetr_etrsc_out_detail#cljg", invoiceObject.getBigDecimal("msycljg"));
                    paramMap.put("tcetr_etrsc_out_detail#bdmzhdkse", invoiceObject.getBigDecimal("mzhdkse"));
                    paramMap.put("tcetr_etrsc_out_detail#mdtse", invoiceObject.getBigDecimal("mdtse"));
                } else {
                    paramMap.put("tcetr_etrsc_out_detail#invoiceno", "");
                    paramMap.put("tcetr_etrsc_out_detail#taxrate", BigDecimal.ZERO);
                    paramMap.put("tcetr_etrsc_out_detail#taxrebaterate", BigDecimal.ZERO);
                    paramMap.put("tcetr_etrsc_out_detail#planallocationrate", BigDecimal.ZERO);
                    paramMap.put("tcetr_etrsc_out_detail#jsjg", BigDecimal.ZERO);
                    paramMap.put("tcetr_etrsc_out_detail#cljg", BigDecimal.ZERO);
                    paramMap.put("tcetr_etrsc_out_detail#bdmzhdkse", BigDecimal.ZERO);
                    paramMap.put("tcetr_etrsc_out_detail#mdtse", BigDecimal.ZERO);
                }
                String exportgoodsno = entry.getString("goodsecdnum");
                DynamicObject ExportObj = this.getExportObj(billno, exportbasedataCollection, exportgoodsno);
                paramMap.put("tcetr_etrsc_out_detail#customsno", billno);
                paramMap.put("tcetr_etrsc_out_detail#exportdate", DateUtils.format((Date)exportdate));
                paramMap.put("tcetr_etrsc_out_detail#certificateno", dlckhwzmmh);
                if (null != ExportObj) {
                    paramMap.put("tcetr_etrsc_out_detail#goodsno", ExportObj.getDynamicObject("hscode").getLong("id"));
                    paramMap.put("tcetr_etrsc_out_detail#goodsname", Optional.ofNullable(ExportObj).map(s -> s.getDynamicObject("hscode").getString("name")).orElseGet(() -> ""));
                    paramMap.put("tcetr_etrsc_out_detail#unit", Optional.ofNullable(ExportObj.getDynamicObject("tradeunit")).map(e -> e.getLong("id")).orElseGet(() -> 0L));
                    paramMap.put("tcetr_etrsc_out_detail#exportamount", Optional.ofNullable(ExportObj).map(e -> e.getBigDecimal("tradeqty")).orElseGet(() -> BigDecimal.ZERO));
                } else {
                    paramMap.put("tcetr_etrsc_out_detail#goodsno", 0L);
                    paramMap.put("tcetr_etrsc_out_detail#goodsname", 0L);
                    paramMap.put("tcetr_etrsc_out_detail#unit", 0L);
                    paramMap.put("tcetr_etrsc_out_detail#exportamount", BigDecimal.ZERO);
                }
                paramMap.put("tcetr_etrsc_out_detail#dollar", entry.get("exportdollar"));
                paramMap.put("tcetr_etrsc_out_detail#rmb", entry.get("exportsellamount"));
                paramMap.put("tcetr_etrsc_out_detail#declaregoods", Optional.ofNullable(entry.getDynamicObject("declaregoodscode")).map(e -> e.getLong("id")).orElseGet(() -> 0L));
                paramMap.put("tcetr_etrsc_out_detail#jljgsch", "");
                paramMap.put("tcetr_etrsc_out_detail#hth", "");
                paramMap.put("tcetr_etrsc_out_detail#businesstype", "");
                paramMap.put("tcetr_etrsc_out_detail#remark", "");
                result.add(paramMap);
            }
        }
        return result;
    }

    private DynamicObject getInvoiceObject(DynamicObjectCollection invoiceentryentity, String goodsecdnum) {
        if (invoiceentryentity == null || invoiceentryentity.size() == 0) {
            return null;
        }
        return invoiceentryentity.stream().filter(s -> goodsecdnum.equals(s.getString("exportgoodsno"))).findFirst().orElse(null);
    }

    private DynamicObject getExportObj(String billno, DynamicObjectCollection entryEntityCollection, String exportgoodsno) {
        if (entryEntityCollection == null || entryEntityCollection.size() == 0) {
            return null;
        }
        return entryEntityCollection.stream().filter(s -> exportgoodsno.equals(billno + "0" + s.getString("itemno"))).findFirst().orElse(null);
    }
}

