/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.wfmanual;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.common.consts.WfManualConst;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.FilterGridControlUtils;
import kd.mpscmm.mscommon.writeoff.common.util.WfWarnException;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;
import kd.mpscmm.mscommon.writeoff.form.manual.WfManualDataReader;
import kd.mpscmm.mscommon.writeoff.form.manual.WfManualPluginExtHandler;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcetr.business.wfmanual.WfManualFactory;

public class WfManualEditPlugin
extends AbstractLicenseCheckFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    private static final Log log = LogFactory.getLog(WfManualEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultOrg();
        this.setDateRange();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("wfauto1")) {
            String data;
            TaskInfo taskInfo;
            String taskInfoStr;
            HashMap result = (HashMap)closedCallBackEvent.getReturnData();
            if (result != null && "true".equals(result.get("taskend")) && result.containsKey("taskinfo") && StringUtil.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtil.isNotBlank((CharSequence)(data = taskInfo.getData()))) {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                if ("true".equals(dataMap.get("success"))) {
                    String s = ResManager.loadKDString((String)"\u5916\u8d38\u81ea\u52a8\u6838\u9500\u4efb\u52a1\u8fd0\u884c\u7ed3\u675f\uff0c\u8bf7\u67e5\u770b\u6838\u9500\u8bb0\u5f55\u3002", (String)"WfManualEditPlugin_5", (String)"taxc-tcetr", (Object[])new Object[0]);
                    log.info("\u5916\u8d38\u81ea\u52a8\u6838\u9500\u4efb\u52a1\u8fd0\u884c\u7ed3\u675f\uff1a" + result.get("taskinfo"));
                    this.getView().showSuccessNotification(s, Integer.valueOf(5000));
                    this.bindEntryData();
                } else {
                    String message = dataMap.getOrDefault("message", ResManager.loadKDString((String)"\u5916\u8d38\u81ea\u52a8\u6838\u9500\u4efb\u52a1\u8fd0\u884c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"WfManualEditPlugin_9", (String)"taxc-tcetr", (Object[])new Object[0]));
                    this.getView().showErrorNotification(message);
                }
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnautowf1"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String key = event.getOperateKey();
        OperationResult result = event.getOperationResult();
        if (!result.isSuccess()) {
            return;
        }
        if ("wfauto1".equals(key)) {
            this.generateWfRecord(key, result, event);
        }
    }

    private void generateWfRecord(String key, OperationResult result, AfterDoOperationEventArgs event) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncurwf"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnautowf1"});
        try {
            this.checkFilterData();
            if ("wfauto1".equals(key)) {
                this.startAutoManual();
            }
        }
        catch (Exception e) {
            log.error("\u6838\u9500\u5931\u8d25\uff1a", (Throwable)e);
            String errorMsgByExp = this.getErrorMsgByExp(e);
            this.getView().showErrorNotification(errorMsgByExp);
            result.setSuccess(false);
            result.setShowMessage(false);
            this.insertAppLogInfo(false, errorMsgByExp, event);
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnautowf1"});
        }
    }

    private void startAutoManual() {
        Map<String, Object> schemaMap = this.buildSchemaSortTypeConfigMap();
        Date wfDate = new Date();
        HashMap<String, Object> extParam = new HashMap<String, Object>(16);
        this.putWfParam(extParam, this.getView());
        Long wfTypeByForm = this.getWfTypeByForm();
        Map<String, Map<String, String>> conditionsMap = this.getConditionsMap();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = Optional.ofNullable(org).map(s -> s.getLong("id")).orElse(0L);
        String orgName = Optional.ofNullable(org).map(s -> s.getString("name")).orElse("");
        this.sendJobMsg(orgName, orgId, wfTypeByForm, schemaMap, wfDate, conditionsMap, extParam, "wfauto1", "kd.taxc.tcetr.formplugin.wfmanual.WfManualEditPlugin");
    }

    public void sendJobMsg(String orgName, Long org, Long wfTypeByForm, Map<String, Object> schemaMap, Date wfDate, Map<String, Map<String, String>> conditionsMap, Map<String, Object> extParam, String callbackId, String callBaskClassName) {
        HashMap<String, Object> businessParams = new HashMap<String, Object>();
        businessParams.put("wfTypeByForm", wfTypeByForm);
        businessParams.put("schemaMap", schemaMap);
        businessParams.put("wfDate", DateUtils.format((Date)wfDate, (String)"yyyy-MM-dd HH:mm:ss"));
        businessParams.put("conditionsMap", conditionsMap);
        businessParams.put("extParam", extParam);
        businessParams.put("org", org);
        businessParams.put("orgName", orgName);
        WfManualEditPlugin.dispatch(this.getView(), businessParams, ResManager.loadKDString((String)"\u5916\u8d38\u81ea\u52a8\u6838\u9500\u4efb\u52a1", (String)"WfManualEditPlugin_4", (String)"taxc-tcetr", (Object[])new Object[0]), "kd.taxc.tcetr.business.wfmanual.WmAutoWfTask", callbackId, callBaskClassName, "kd.taxc.tcetr.formplugin.wfmanual.MyTaskClick");
    }

    public static void dispatch(IFormView formview, Map<String, Object> params, String taskName, String taskClassName, String callbackId, String callBackClassName, String clickClassName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formview.getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        jobInfo.setRunByUserId(RequestContext.getOrCreate().getCurrUserId());
        CloseCallBack closeCallBack = new CloseCallBack(callBackClassName, callbackId);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u5916\u8d38\u81ea\u52a8\u6838\u9500\u4efb\u52a1", (String)"WfManualEditPlugin_4", (String)"taxc-tcetr", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        if (StringUtil.isNotBlank((CharSequence)clickClassName)) {
            jobFormInfo.setClickClassName(clickClassName);
        }
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formview);
    }

    private Long getWfTypeByForm() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        if (wfType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualEditPlugin_19", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        return wfType.getLong("id");
    }

    private String getPageFilter(String curEntryKey) {
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        String filterText = this.getPageFilterCacheValue("writeOffPageFilter", curEntryKey);
        String entityNumber = entryBillMap.get(curEntryKey);
        QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter((String)entityNumber, (String)filterText);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        HashMap<String, Object> pageDataMap = new HashMap<String, Object>(16);
        pageDataMap.put("model", this.getModel());
        pageDataMap.put("view", this.getView());
        this.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        billFilters.add(curBillFilter);
        QFilter qFilterPage = new QFilter("1", "=", (Object)1);
        for (QFilter qFilter : billFilters) {
            qFilterPage.and(qFilter);
        }
        return qFilterPage.toSerializedString();
    }

    private Map<String, Map<String, String>> getConditionsMap() {
        LinkedHashMap<String, Map<String, String>> billConditionsMap = new LinkedHashMap<String, Map<String, String>>(16);
        String wfCount = this.getPageCache().get("wfcount");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
            String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
            Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
            String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
            String filterText = this.getPageFilter(curEntryKey);
            log.info("\u624b\u5de5\u81ea\u52a8\u6838\u9500\u8fc7\u6ee4\u6761\u4ef6:" + filterText);
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("pageFilter", filterText);
            map.put("wfTypeFilter", wfCfgFilter);
            map.put("wfTypeCFilter", wfCfgCFilter);
            String writeOffTypeEntyId = this.getCacheValue("writeOffTypeEntryIdsMap").get(curEntryKey);
            billConditionsMap.put(writeOffTypeEntyId, map);
        }
        return billConditionsMap;
    }

    private Map<String, Object> buildSchemaSortTypeConfigMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Object scheme = this.getModel().getValue("wfscheme");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u586b\u5199\u6838\u9500\u65b9\u6848\u3002", (String)"WfManualEditPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        map.put("sub_wf_scheme", ((DynamicObject)scheme).getPkValue());
        map.put("seq", 0);
        map.put("sub_unilateral", this.getModel().getValue("single"));
        map.put("sub_rbpriority", this.getModel().getValue("redbluefirst"));
        map.put("sub_equalsfirst", this.getModel().getValue("equalsfirst"));
        map.put("sub_onlyequals", this.getModel().getValue("onlyequals"));
        map.put("sub_whole", this.getModel().getValue("whole"));
        map.put("sub_lastwhole", this.getModel().getValue("lastwhole"));
        return map;
    }

    private int getMaxShowSize() {
        return WriteOffParamManager.create().getMaxQuerySize();
    }

    private Map<String, List<String>> getCacheValueList(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private void bindEntryData() {
        int maxShowSize = this.getMaxShowSize();
        DynamicObject wfScheme = (DynamicObject)this.getModel().getValue("wfscheme");
        if (wfScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualEditPlugin_6", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        String wfCount = this.getView().getPageCache().get("wfcount");
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            this.getModel().deleteEntryData(curEntryKey);
            String entityNumber = entryBillMap.get(curEntryKey);
            Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
            String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
            Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
            String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
            List<QFilter> billFilters = this.filterDeal(curEntryKey, entryBillMap);
            this.checkOrgAndDateFilter(entityNumber, billFilters);
            HashMap<String, String> billFormFieldMap = new HashMap<String, String>(16);
            List<String> formFields = this.getBillFields(suffix, curEntryKey, entityNumber, billFormFieldMap);
            Map<String, List<String>> entryWfMap = this.getCacheValueList("entrywffieldmap");
            List<String> wfFields = entryWfMap.get(curEntryKey);
            if (wfFields == null) {
                wfFields = new ArrayList<String>(16);
            }
            Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
            String wfMainField = entryWfMainFieldMap.get(curEntryKey);
            Map<String, String> wfFieldAssistField = this.getWfFieldAssistFieldMap(curEntryKey, billFormFieldMap, wfFields);
            String writeOffTypeEntyId = this.getCacheValue("writeOffTypeEntryIdsMap").get(curEntryKey);
            WfManualDataReader wfManualDataReader = new WfManualDataReader(entityNumber, wfMainField, wfCfgFilter, wfCfgCFilter, curEntryKey, writeOffTypeEntyId);
            wfManualDataReader.setBillFilters(billFilters);
            String customField = new WfManualPluginExtHandler(this.getView()).manualWriteOffField(this.getWfType(), suffix);
            if (StringUtils.isNotEmpty((String)customField)) {
                String mainFieldKey = DynamicObjectUtil.getLastKey((String)wfMainField.replaceAll("@@A", ""));
                wfFieldAssistField.put(mainFieldKey, customField);
            }
            TableValueSetter tableValueSetter = wfManualDataReader.createTableValueSetter(formFields, billFormFieldMap, wfFieldAssistField, maxShowSize);
            this.getModel().beginInit();
            int rowCount = tableValueSetter.getCount();
            if (rowCount >= maxShowSize) {
                this.getView().showTipNotification(EngineLang.overQueryBillSize((String)entityNumber, (Integer)maxShowSize));
            }
            if (rowCount != 0) {
                this.dealFieldsValueByBiz(tableValueSetter, curEntryKey);
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(curEntryKey, tableValueSetter);
            }
            this.getModel().endInit();
            this.getView().updateView(curEntryKey);
        }
    }

    private Long getWfType() {
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wftypenumber");
        if (wfType == null) {
            String wfGroupNum = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
            DynamicObjectCollection wfTypes = QueryServiceHelper.query((String)"msmod_recordtypegroup", (String)"entryentity.wftype.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfGroupNum)}, (String)"entryentity.seq");
            if (wfTypes.isEmpty()) {
                throw new WfWarnException(ResManager.loadKDString((String)"\u8868\u5355\u914d\u7f6e\u7684\u6838\u9500\u7c7b\u522b\u5206\u7ec4\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u5165\u53e3\u53c2\u6570\u3002", (String)"WfManualEditPlugin_17", (String)"taxc-tcetr", (Object[])new Object[0]));
            }
            wfType = ((DynamicObject)wfTypes.get(0)).getString("entryentity.wftype.number");
        }
        List wfTypeId = QueryServiceHelper.queryPrimaryKeys((String)"msmod_writeofftype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfType)}, null, (int)1);
        return (Long)wfTypeId.get(0);
    }

    private Map<String, String> getWfFieldAssistFieldMap(String curEntryKey, Map<String, String> billFormFieldMap, List<String> wfFields) {
        HashMap<String, String> wfFieldAssistField = new HashMap<String, String>(16);
        for (String wfField : wfFields) {
            String[] splits = wfField.split("\\.");
            wfField = splits[splits.length - 1];
            String formField = billFormFieldMap.get(wfField);
            String mainField = billFormFieldMap.get(wfField + "_cur");
            if (formField == null && mainField == null) continue;
            String assistWfField = formField != null ? formField.substring(0, formField.length() - 2) + "_cur" + formField.substring(formField.length() - 2) : mainField.substring(0, mainField.length() - 2) + mainField.substring(mainField.length() - 2);
            DynamicObjectType curEntryType = this.getModel().getEntryEntity(curEntryKey).getDynamicObjectType();
            boolean containsAssistField = curEntryType.getProperties().containsKey((Object)assistWfField);
            boolean containsFormField = curEntryType.getProperties().containsKey((Object)formField);
            if (!containsAssistField || !containsFormField) continue;
            wfFieldAssistField.put(wfField, assistWfField);
        }
        return wfFieldAssistField;
    }

    private List<String> getBillFields(String suffix, String curEntryKey, String entityNumber, Map<String, String> billFormFieldMap) {
        ArrayList<String> formFields = new ArrayList<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(curEntryKey);
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty item : properties) {
            String isvKey;
            String keyName = item.getName();
            if (!keyName.endsWith(suffix) && !keyName.endsWith("_x")) continue;
            if ((keyName = keyName.endsWith("_x") ? keyName.substring(0, keyName.lastIndexOf(suffix + "_x")) : keyName.substring(0, keyName.lastIndexOf(suffix))).startsWith(isvKey = ISVService.getISVInfo().getId() + "_")) {
                String newKeyName = keyName.substring(isvKey.length());
                if (dataEntityType.getProperties().containsKey((Object)newKeyName)) {
                    keyName = newKeyName;
                }
            }
            if (!formFields.contains(keyName)) {
                formFields.add(keyName);
            }
            billFormFieldMap.put(keyName, item.getName());
        }
        Map billAllFields = dataEntityType.getAllFields();
        formFields.retainAll(billAllFields.keySet());
        return formFields;
    }

    private void insertAppLogInfo(boolean isSuccess, String errorMsgByExp, AfterDoOperationEventArgs event) {
        FormOperate source = (FormOperate)event.getSource();
        String org = source.getOption().getVariableValue("org", RequestContext.get().getOrgId() + "");
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(MetadataServiceHelper.getDataEntityType((String)source.getEntityId()).getAppId());
        appLogInfo.setBizObjID(source.getEntityId());
        appLogInfo.setOpName(source.getOperateName().getLocaleValue());
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOrgID(Long.valueOf(org));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setClientName(RequestContext.get().getClient());
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setAccountId(RequestContext.get().getAccountId());
        if (isSuccess) {
            String msg = ResManager.loadKDString((String)"\u6210\u529f", (String)"WfManualEditPlugin_7", (String)"taxc-tcetr", (Object[])new Object[0]);
            appLogInfo.setOpDescription(source.getOperateName().getLocaleValue() + msg);
        } else {
            String msg = ResManager.loadKDString((String)"\u5931\u8d25\uff1a", (String)"WfManualEditPlugin_8", (String)"taxc-tcetr", (Object[])new Object[0]);
            appLogInfo.setOpDescription(source.getOperateName().getLocaleValue() + msg + errorMsgByExp);
        }
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private String getErrorMsgByExp(Exception e) {
        String errorMsg;
        if (e.getMessage() != null) {
            errorMsg = e.getMessage();
        } else {
            StackTraceElement[] errs;
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement err : errs = e.getStackTrace()) {
                sb.append(err).append('\n');
            }
            errorMsg = sb.toString();
        }
        return errorMsg;
    }

    private void checkFilterData() {
        DynamicObject wfScheme = (DynamicObject)this.getModel().getValue("wfscheme");
        if (wfScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualEditPlugin_6", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        String wfCount = this.getView().getPageCache().get("wfcount");
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            String entityNumber = entryBillMap.get(curEntryKey);
            List<QFilter> qFilters = this.filterDeal(curEntryKey, entryBillMap);
            this.checkOrgAndDateFilter(entityNumber, qFilters);
        }
    }

    private Map<String, String> getCacheValue(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cacheValueStr)) {
            return new HashMap<String, String>(1);
        }
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private Map<String, IDataEntityProperty> getEntityPropertyMap(String entityNumber, Map<String, EntityType> allEntities) {
        HashMap<String, IDataEntityProperty> fieldMap = new HashMap<String, IDataEntityProperty>(16);
        for (Map.Entry<String, EntityType> entry : allEntities.entrySet()) {
            String entryKey = entry.getKey();
            EntityType value = entry.getValue();
            Map fields = value.getFields();
            for (Map.Entry fieldEntry : fields.entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
                if (entityNumber.equals(entryKey)) {
                    fieldMap.put(fieldKey, property);
                    continue;
                }
                String keyResult = entryKey + "." + fieldKey;
                fieldMap.put(keyResult, property);
            }
        }
        return fieldMap;
    }

    private void checkOrgAndDateFilter(String entityNumber, List<QFilter> billFilters) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, IDataEntityProperty> fieldMap = this.getEntityPropertyMap(entityNumber, allEntities);
        Set entryNames = allEntities.keySet();
        boolean isOrg = false;
        boolean isDate = false;
        for (QFilter qFilter : billFilters) {
            if (qFilter == null) continue;
            HashSet<String> vars = new HashSet<String>(16);
            this.buildQfilterAllFields(qFilter, vars);
            for (String field : vars) {
                String[] spitFields = field.split("\\.");
                String spitField = spitFields[0];
                String fieldName = spitFields.length > 1 && entryNames.contains(spitField) ? spitField + "." + spitFields[1] : spitField;
                IDataEntityProperty property = fieldMap.get(fieldName);
                if (property instanceof OrgProp) {
                    isOrg = true;
                }
                if (!(property instanceof DateTimeProp)) continue;
                isDate = true;
            }
        }
        if (!isOrg || !isDate) {
            String name = dataEntityType.getDisplayName().getLocaleValue();
            String message = this.wfQueryCheckMessage(name, dataEntityType.getName());
            throw new KDBizException(message);
        }
    }

    private void buildQfilterAllFields(QFilter qFilter, Set<String> fields) {
        if (qFilter == null) {
            return;
        }
        String[] properties = qFilter.getProperties();
        fields.addAll(Arrays.asList(properties));
        List nests = qFilter.getNests(false);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            this.buildQfilterAllFields(filter, fields);
        }
    }

    private String getPageFilterCacheValue(String cacheKey, String curEntryKey) {
        if (!"writeOffPageFilter".equals(cacheKey)) {
            return null;
        }
        String cacheValueStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)cacheValueStr)) {
            return this.addDefaultPageFilterConditon(this.getView(), curEntryKey);
        }
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        String filterText = (String)cacheValueMap.get(curEntryKey);
        if (StringUtils.isEmpty((String)filterText)) {
            return this.addDefaultPageFilterConditon(this.getView(), curEntryKey);
        }
        return filterText;
    }

    private List<QFilter> filterDeal(String curEntryKey, Map<String, String> entryBillMap) {
        String filterText = this.getPageFilterCacheValue("writeOffPageFilter", curEntryKey);
        String entityNumber = entryBillMap.get(curEntryKey);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
        String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
        QFilter wfCfgs = FilterGridControlUtils.crFilterTextToQfilter((String)entityNumber, (String)wfCfgFilter);
        billFilters.add(wfCfgs);
        Map<String, String> entryCFilterStrMap = this.getCacheValue("entrycfilterstrmap");
        String wfCfgCFilter = entryCFilterStrMap.get(curEntryKey);
        QFilter wfCfgCs = FilterGridControlUtils.crFilterTextToQfilter((String)entityNumber, (String)wfCfgCFilter);
        billFilters.add(wfCfgCs);
        QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter((String)entityNumber, (String)filterText);
        billFilters.add(curBillFilter);
        HashMap<String, Object> pageDataMap = new HashMap<String, Object>(16);
        pageDataMap.put("model", this.getModel());
        pageDataMap.put("view", this.getView());
        this.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        return billFilters;
    }

    private String getEntryKey(String entryKey) {
        String isvKey;
        String newEntryKey;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        Map allEntities = dataEntityType.getAllEntities();
        if (!allEntities.containsKey(entryKey) && allEntities.containsKey(newEntryKey = (isvKey = ISVService.getISVInfo().getId()) + "_" + entryKey)) {
            entryKey = newEntryKey;
        }
        return entryKey;
    }

    private String getSuffix(int index) {
        return "_" + (char)(WfManualConst.MIN_SUFFIX.charValue() + index);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opt = (FormOperate)args.getSource();
        String optKey = opt.getOperateKey();
        if ("query".equals(optKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Date startdate = (Date)this.getModel().getValue("startdate");
            Date enddate = (Date)this.getModel().getValue("enddate");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"WfManualEditPlugin_18", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (startdate == null || enddate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65e5\u671f\u8303\u56f4", (String)"WfManualEditPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("wfauto".equals(optKey) || "wfauto1".equals(optKey)) {
            this.getModel().setValue("whole", (Object)false);
            this.getModel().setValue("equalsfirst", (Object)true);
            this.getModel().setValue("onlyequals", (Object)false);
            this.validateWfauto(args);
        } else if ("wfmanual".equals(optKey)) {
            this.getModel().setValue("whole", (Object)true);
            this.getModel().setValue("equalsfirst", (Object)false);
            this.getModel().setValue("onlyequals", (Object)false);
            this.validateWfmanual(args);
        }
    }

    private void validateWfmanual(BeforeDoOperationEventArgs args) {
        String entityId = this.getView().getEntityId();
        if ("tcetr_smart_allocation".equals(entityId)) {
            EntryGrid entryGrida = (EntryGrid)this.getView().getControl("entry_a");
            EntryGrid entryGridb = (EntryGrid)this.getView().getControl("entry_b");
            EntryGrid entryGridC = (EntryGrid)this.getView().getControl("entry_c");
            int[] selectRows1 = entryGrida.getSelectRows();
            int[] selectRows2 = entryGridb.getSelectRows();
            int[] selectRows3 = entryGridC.getSelectRows();
            if (selectRows1.length == 0 || selectRows2.length == 0 || selectRows3.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff1a\u51fa\u53e3\u62a5\u5173\u5355\u3001\u53d1\u7968\u5747\u9009\u6709\u6570\u636e\u624d\u80fd\u6838\u9500\u3002", (String)"WfManualEditPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("tcetr_scqy_wfmanualtpl".equals(entityId)) {
            EntryGrid entryGrida = (EntryGrid)this.getView().getControl("entry_a");
            EntryGrid entryGridb = (EntryGrid)this.getView().getControl("entry_b");
            int[] selectRows1 = entryGrida.getSelectRows();
            int[] selectRows2 = entryGridb.getSelectRows();
            if (selectRows1.length == 0 || selectRows2.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff1a\u51fa\u53e3\u62a5\u5173\u5355\u3001\u53d1\u7968\u5747\u6709\u6570\u636e\u624d\u80fd\u6838\u9500\u3002", (String)"WfManualEditPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void validateWfauto(BeforeDoOperationEventArgs args) {
        String entityId = this.getView().getEntityId();
        if ("tcetr_smart_allocation".equals(entityId)) {
            DynamicObjectCollection entry_a = this.getModel().getEntryEntity("entry_a");
            DynamicObjectCollection entry_b = this.getModel().getEntryEntity("entry_b");
            DynamicObjectCollection entry_c = this.getModel().getEntryEntity("entry_c");
            int size1 = entry_a.size();
            int size2 = entry_b.size();
            int size3 = entry_c.size();
            if (size1 == 0 || size2 == 0 || size3 == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff1a\u51fa\u53e3\u62a5\u5173\u5355\u3001\u53d1\u7968\u5747\u6709\u6570\u636e\u624d\u80fd\u6838\u9500\u3002", (String)"WfManualEditPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("tcetr_scqy_wfmanualtpl".equals(entityId)) {
            int rowCount1 = this.getModel().getEntryRowCount("entry_a");
            int rowCount2 = this.getModel().getEntryRowCount("entry_b");
            if (rowCount1 == 0 || rowCount2 == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u9500\u5931\u8d25\uff1a\u51fa\u53e3\u62a5\u5173\u5355\u3001\u53d1\u7968\u5747\u6709\u6570\u636e\u624d\u80fd\u6838\u9500\u3002", (String)"WfManualEditPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void setDateRange() {
        Date lastMonthDate = DateUtils.getLastMaxMonthDate();
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)lastMonthDate));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)lastMonthDate));
        this.getModel().setValue("exportstartdate", (Object)DateUtils.getFirstDateOfMonth((Date)lastMonthDate));
        this.getModel().setValue("exportenddate", (Object)DateUtils.getLastDateOfMonth((Date)lastMonthDate));
        if ("tcetr_smart_allocation".equals(this.getView().getEntityId())) {
            this.getModel().setValue("inputstartdate", (Object)DateUtils.getFirstDateOfMonth((Date)lastMonthDate));
            this.getModel().setValue("inputenddate", (Object)DateUtils.getLastDateOfMonth((Date)lastMonthDate));
        }
    }

    public void setDefaultOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        String paramOrgid = (String)customParams.get("org");
        Long org = StringUtil.isNotBlank((CharSequence)paramOrgid) ? Long.parseLong(paramOrgid) : RequestContext.get().getOrgId();
        Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
        this.getModel().setValue("org", (Object)orgid);
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        long writeOffId;
        IWfManualExtService iWfManualExtService;
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject writeofftype = (DynamicObject)model.getValue("writeofftype");
        if (writeofftype != null && (iWfManualExtService = WfManualFactory.getIWfManualExtService(writeOffId = writeofftype.getLong("id"))) != null) {
            iWfManualExtService.addBillFilter(curEntryKey, entityNumber, billFilters, pageDataMap);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        List orgList = new ArrayList();
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
            orgList = permOrgResult.getHasPermOrgs();
        }
        if (!orgList.isEmpty()) {
            QFilter idsFilter = new QFilter("id", "in", orgList);
            event.setCustomQFilters((List)Lists.newArrayList((Object[])new QFilter[]{idsFilter}));
        }
        OrgUtils.addFilterByConditionBeforeF7Select((Object)event, (IFormView)this.getView(), null, null, null);
    }
}

