/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.wfmanual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.AbstractOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcetr.common.constant.WriteOffConstant;

public class WfRecordListPlugin
extends AbstractListPlugin {
    public void initialize() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String wfTypeId = String.valueOf(params.get("wftypeid"));
        if (WriteOffConstant.WRITEOFF_SCQY.toString().equals(wfTypeId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"hhcb"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object wfTypeId = params.get("wftypeid");
        if (EmptyCheckUtils.isNotEmpty(wfTypeId)) {
            String wfTypeIds = String.valueOf(wfTypeId);
            if (wfTypeIds.contains(",")) {
                List wfTyleIdList = Arrays.stream(wfTypeIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
                e.getQFilters().add(new QFilter("writeofftypeid", "in", wfTyleIdList));
            } else {
                e.getQFilters().add(new QFilter("writeofftypeid", "=", (Object)Long.parseLong(wfTypeIds)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if ("createdraft".equals(operateKey)) {
            List validateErrors = operationResult.getValidateResult().getValidateErrors("sameOrg");
            if (validateErrors == null || validateErrors.isEmpty()) {
                validateErrors = operationResult.getValidateResult().getValidateErrors("sameQylx");
            }
            if (validateErrors == null || validateErrors.isEmpty()) {
                validateErrors = operationResult.getValidateResult().getValidateErrors("isCreateDraft");
            }
            if ((validateErrors == null || validateErrors.isEmpty()) && (validateErrors = operationResult.getValidateResult().getValidateErrors("orgnotauth")) != null && !validateErrors.isEmpty()) {
                this.getView().showErrorNotification(((ValidateResult)validateErrors.get(0)).getMessage());
                return;
            }
            if (validateErrors == null || validateErrors.isEmpty()) {
                List successPkIds = operationResult.getSuccessPkIds();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("wfRecordId", successPkIds);
                customParams.put("source", "createdraft");
                if (this.isScqy()) {
                    PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcetr_manufacturer_draft", null, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.ADDNEW, (IFormPlugin)this);
                } else {
                    DynamicObject dyo = QueryServiceHelper.queryOne((String)"tcetr_updownwfrecord", (String)"taxorg.id as orgid,taxorg.name as orgname", (QFilter[])new QFilter[]{new QFilter("id", "=", successPkIds.get(0))});
                    String lockKey = "createdraft:" + dyo.getString("orgid");
                    DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tcetr.formplugin.wfmanual.WfRecordListPlugin\u3002afterDoOperation");
                    reentrant.fastMode();
                    boolean b = reentrant.tryLock(5000L);
                    if (!b) {
                        String orgName = dyo.getString("orgname");
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7[%s]\u5df2\u6709\u4efb\u52a1\u5728\u6267\u884c\u3002", (String)"WfRecordListPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]), orgName));
                    } else {
                        try {
                            ArrayList<DynamicObject> wfRecordUpdList = new ArrayList<DynamicObject>(successPkIds.size());
                            for (Object successPkId : successPkIds) {
                                DynamicObject wfRecord = BusinessDataServiceHelper.newDynamicObject((String)"tcetr_updownwfrecord");
                                wfRecord.set("id", successPkId);
                                wfRecord.set("iscreatedraft", (Object)"2");
                                wfRecordUpdList.add(wfRecord);
                            }
                            SaveServiceHelper.update((DynamicObject[])wfRecordUpdList.toArray(new DynamicObject[0]));
                            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcetr_ckts_dgdj", null, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.ADDNEW, (IFormPlugin)this);
                        }
                        finally {
                            reentrant.unlock();
                        }
                    }
                }
            } else if (validateErrors.size() == 1) {
                this.getView().showTipNotification(((ValidateResult)validateErrors.get(0)).getMessage());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult1 = new OperationResult();
                operationResult1.setSuccess(false);
                operationResult1.setMessage(validateErrors.stream().map(AbstractOperationResult::getMessage).collect(Collectors.joining(System.getProperty("line.separator"))));
                this.getView().showOperationResult(operationResult1);
            }
        } else if ("viewdraft".equals(operateKey)) {
            int billCount = args.getOperationResult().getBillCount();
            if (billCount > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u80fd\u9009\u62e9\u4e00\u6761\u6838\u9500\u7ed3\u679c\u8fdb\u884c\u67e5\u770b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WfRecordListPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            List successPkIds = operationResult.getSuccessPkIds();
            DynamicObject dyo = this.isScqy() ? QueryServiceHelper.queryOne((String)"tcetr_wfrecord_scqy", (String)"draftid,iscreatedraft", (QFilter[])new QFilter[]{new QFilter("id", "=", successPkIds.get(0))}) : QueryServiceHelper.queryOne((String)"tcetr_updownwfrecord", (String)"draftid,iscreatedraft", (QFilter[])new QFilter[]{new QFilter("id", "=", successPkIds.get(0))});
            if (!"1".equals(dyo.getString("iscreatedraft"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u751f\u6210\u5e95\u7a3f\uff0c\u65e0\u6cd5\u67e5\u770b\u5e95\u7a3f\u3002", (String)"WfRecordListPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Long> customParams = new HashMap<String, Long>();
            customParams.put("draftId", dyo.getLong("draftid"));
            if (this.isScqy()) {
                PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcetr_manufacturer_draft", (Object)dyo.getLong("draftid"), (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT, (IFormPlugin)this);
            } else {
                PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcetr_ckts_dgdj", (Object)dyo.getLong("draftid"), (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT, (IFormPlugin)this);
            }
        }
    }

    private boolean isScqy() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String wfTypeId = String.valueOf(params.get("wftypeid"));
        return WriteOffConstant.WRITEOFF_SCQY.toString().equals(wfTypeId);
    }
}

