/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.opplugin.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.tcetr.common.constant.DraftConstant;

public class CktsDraftListOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if ("save".equals(this.getOperateKey())) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject obj = dataEntity.getDataEntity();
                        DynamicObject org = obj.getDynamicObject("org");
                        if (org == null) {
                            return;
                        }
                        TaxResult checkResult = TaxcLicenseCheckDataServiceHelper.check((Long)org.getLong("id"), (String)"tcetr");
                        if (checkResult == null || !Boolean.TRUE.equals(checkResult.getData())) continue;
                        ValidateResult result = new ValidateResult();
                        result.setMessage(checkResult.getMessage());
                        CktsDraftListOp.this.getOperationResult().getValidateResult().addValidateError("orgnotauth", result);
                        CktsDraftListOp.this.getOperationResult().setSuccess(false);
                        return;
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        List draftIds;
        DynamicObjectCollection query;
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        String name = dataEntities[0].getDynamicObjectType().getName();
        String wfrecordEntity = DraftConstant.DRAFT_WFRECORD_MAP.get(name);
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject[] updateArray;
                Map variables = this.operateOption.getVariables();
                String wfRecordId = (String)variables.get("wfRecordId");
                if (wfRecordId == null) continue;
                Object[] wfRecordIds = SerializationUtils.fromJsonStringToList((String)wfRecordId, Long.class).toArray();
                for (DynamicObject dynamicObject : updateArray = BusinessDataServiceHelper.load((Object[])wfRecordIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)wfrecordEntity))) {
                    dynamicObject.set("iscreatedraft", (Object)"1");
                    dynamicObject.set("draftid", dataEntity.getPkValue());
                    updateList.add(dynamicObject);
                }
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        } else if ("delete".equals(operationKey) && !(query = QueryServiceHelper.query((String)wfrecordEntity, (String)"id", (QFilter[])new QFilter[]{new QFilter("draftid", "in", draftIds = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList()))})).isEmpty()) {
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])query.stream().map(o -> o.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)wfrecordEntity));
            Arrays.stream(load).peek(o -> o.set("draftid", (Object)0L)).forEach(o -> o.set("iscreatedraft", (Object)"0"));
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }
}

