/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.opplugin.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tcetr.business.draft.CktsDraftService;
import kd.taxc.tcetr.business.draft.PatchNumberService;

public class CktsDraftSaveValidator
extends AbstractOperationServicePlugIn {
    private static CktsDraftService cktsDraftService = new CktsDraftService();
    private static PatchNumberService patchNumberService = new PatchNumberService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("exportsellamount");
        e.getFieldKeys().add("tradeqty");
        e.getFieldKeys().add("num");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("sinvoicedetailid");
        e.getFieldKeys().add("goodsid");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("sbny");
        e.getFieldKeys().add("sbpc");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    Long pk;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    DynamicObject org = currentObj.getDynamicObject("org");
                    if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"CktsDraftSaveValidator_5", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if (org != null && currentObj.getLong("id") == 0L) {
                        long orgId = org.getLong("id");
                        String pc = patchNumberService.generator(orgId, currentObj.getDate("sbny"));
                        if (Integer.parseInt(pc) > currentObj.getInt("sbpc")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u4e2a\u7533\u62a5\u5e74\u6708\u4e0b\u7684\u7533\u62a5\u6279\u6b21\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u7533\u62a5\u5e74\u6708\u201d\u548c\u201c\u7533\u62a5\u6279\u6b21\u201d\u3002", (String)"CktsDraftSaveValidator_6", (String)"taxc-tcetr", (Object[])new Object[0]));
                        }
                    }
                    DynamicObjectCollection invoiceentryentity = currentObj.getDynamicObjectCollection("invoiceentryentity");
                    DynamicObjectCollection outentryentity = currentObj.getDynamicObjectCollection("outentryentity");
                    DynamicObjectCollection entryentity = currentObj.getDynamicObjectCollection("entryentity");
                    List sinvoicedetailid = invoiceentryentity.stream().map(s -> s.getLong("sinvoicedetailid")).collect(Collectors.toList());
                    DynamicObjectCollection invoiceEntrysInfos = CktsDraftSaveValidator.this.getInvoiceEntryInfos(sinvoicedetailid);
                    BigDecimal sumAmount = invoiceEntrysInfos.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                    BigDecimal sumNum = invoiceEntrysInfos.stream().map(s -> s.getBigDecimal("num")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                    if (outentryentity == null || outentryentity.size() == 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u53e3\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9", (String)"CktsDraftSaveValidator_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if (invoiceentryentity == null || invoiceentryentity.size() == 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u53e3\u53d1\u7968\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9", (String)"CktsDraftSaveValidator_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if (entryentity == null || entryentity.size() == 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fdb\u8d27\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9", (String)"CktsDraftSaveValidator_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if ((pk = Optional.ofNullable((DynamicObject)dataEntity.getValue("exportbasedata")).map(s -> s.getLong("id")).orElseGet(() -> null)) == null) {
                        return;
                    }
                    if (outentryentity == null) continue;
                    DynamicObjectCollection outEntryInfos = CktsDraftSaveValidator.this.getOutEntryInfos(pk, outentryentity.stream().map(s -> s.getLong("goodsid")).collect(Collectors.toList()));
                    BigDecimal sumExportsellamount = outentryentity.stream().map(s -> s.getBigDecimal("exportsellamount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                    BigDecimal sumTradeqty = outEntryInfos.stream().map(s -> s.getBigDecimal("tradeqty")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
                    if (sumTradeqty.compareTo(sumNum) != 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u5173\u7684\u6210\u4ea4\u6570\u91cf\u7684\u5408\u8ba1\u503c\u5e94\u7b49\u4e8e\u51fa\u53e3\u53d1\u7968\u7684\u6570\u91cf\u5408\u8ba1\u503c\uff0c\u8bf7\u68c0\u67e5", (String)"CktsDraftSaveValidator_4", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if (sumExportsellamount.compareTo(sumAmount) == 0) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u5173\u7684\u51fa\u53e3\u9500\u552e\u989d\uff08\u4eba\u6c11\u5e01\uff09\u7684\u5408\u8ba1\u503c\u5e94\u7b49\u4e8e\u51fa\u53e3\u53d1\u7968\u7684\u91d1\u989d\u5408\u8ba1\u503c\uff0c\u8bf7\u68c0\u67e5", (String)"CktsDraftSaveValidator_0", (String)"taxc-tcetr", (Object[])new Object[0]));
                }
            }
        });
    }

    private DynamicObjectCollection getInvoiceEntryInfos(List<Long> detailIds) {
        return cktsDraftService.getInvoiceList(Lists.newArrayList(detailIds));
    }

    private DynamicObjectCollection getOutEntryInfos(Long pk, List<Long> selectGoodsId) {
        DynamicObject exportDeclaration = cktsDraftService.getExportDeclaration(pk);
        DynamicObjectCollection entryentity = exportDeclaration.getDynamicObjectCollection("entryentity");
        return entryentity.stream().filter(s -> selectGoodsId.contains(s.getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }
}

