/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.opplugin.feed;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DistributionRateSaveValidator
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    String existNumber;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    long currentId = currentObj.getLong("id");
                    Long orgId = Optional.ofNullable(currentObj.getDynamicObject("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
                    Date startdate = currentObj.getDate("startdate");
                    Date enddate = currentObj.getDate("enddate");
                    if (startdate == null || enddate == null) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u6216\u6b62\u4e0d\u80fd\u4e3a\u7a7a", (String)"DistributionRateSaveValidator_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                        continue;
                    }
                    LocalDate startdateLocalDate = this.date2LocalDate(startdate);
                    int dayOfMonth = startdateLocalDate.getDayOfMonth();
                    int firstDay = startdateLocalDate.with(TemporalAdjusters.firstDayOfNextMonth()).getDayOfMonth();
                    LocalDate enddateLocalDate = this.date2LocalDate(enddate);
                    int dayOfMonth2 = enddateLocalDate.getDayOfMonth();
                    int lastDay = enddateLocalDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
                    if (dayOfMonth != firstDay || dayOfMonth2 != lastDay) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u4e3a\u6708\u521d\uff0c\u6709\u6548\u671f\u6b62\u5fc5\u987b\u4e3a\u6708\u672b", (String)"DistributionRateSaveValidator_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if (startdate.after(enddate)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u5c0f\u4e8e\u6709\u6548\u671f\u8d77", (String)"DistributionRateSaveValidator_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                    }
                    if (StringUtil.isNotBlank((CharSequence)(existNumber = this.hasIntersection(orgId, startdate, enddate, currentId)))) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u6570\u636e\uff1a%s", (String)"DistributionRateSaveValidator_4", (String)"taxc-tcetr", (Object[])new Object[0]), existNumber));
                    }
                    currentObj.set("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)startdate));
                    currentObj.set("enddate", (Object)DateUtils.getLastDateOfMonth((Date)enddate));
                }
            }

            private String hasIntersection(Long orgId, Date startdate, Date enddate, Long currentId) {
                QFilter q1 = new QFilter("org", "=", (Object)orgId);
                QFilter q2 = new QFilter("startdate", "<=", (Object)enddate);
                QFilter q3 = new QFilter("enddate", ">=", (Object)startdate);
                QFilter q4 = new QFilter("id", "!=", (Object)currentId);
                DynamicObjectCollection numbers = QueryServiceHelper.query((String)this.entityKey, (String)"number", (QFilter[])new QFilter[]{q1, q2, q3, q4});
                if (CollectionUtils.isEmpty((Collection)numbers)) {
                    return null;
                }
                return numbers.stream().map(s -> s.getString("number")).collect(Collectors.joining(","));
            }

            public LocalDate date2LocalDate(Date date) {
                if (date == null) {
                    return null;
                }
                return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
        });
    }
}

