/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.opplugin.sbb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcetr.business.draft.PatchNumberService;
import kd.taxc.tcetr.business.sbb.DeclareService;
import kd.taxc.tcetr.formplugin.draft.CktsDraftSbbStatusUtils;

public class DeclareQueryListOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DeclareQueryListOp.class);
    private static PatchNumberService patchNumberService = new PatchNumberService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("skssqq");
        e.getFieldKeys().add("skssqz");
        e.getFieldKeys().add("batchno");
        e.getFieldKeys().add("type");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("delete".equals(operateKey)) {
                    for (ExtendedDataEntity data : this.dataEntities) {
                        boolean exists;
                        DynamicObject dataEntity = data.getDataEntity();
                        DynamicObject org = dataEntity.getDynamicObject("org");
                        Date skssqq = dataEntity.getDate("skssqq");
                        Date skssqz = dataEntity.getDate("skssqz");
                        String batchno = dataEntity.getString("batchno");
                        String type = dataEntity.getString("type");
                        if (!"drawback".equals(type) || !(exists = QueryServiceHelper.exists((String)"tcetr_ckts_dgdj", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("sbny", "=", (Object)skssqq), new QFilter("sbpc", ">", (Object)batchno)}))) continue;
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u5df2\u751f\u6210\u540e\u7eed\u201c\u6279\u6b21\u201d\u7684\u5e95\u7a3f\uff0c\u4e0d\u652f\u6301\u5220\u9664\u7533\u62a5\u8868\uff0c\u8bf7\u5220\u9664\u540e\u7eed\u201c\u6279\u6b21\u201d\u7684\u5e95\u7a3f\u540e\u518d\u5220\u9664\u7533\u62a5\u8868\u3002", (String)"DeclareQueryListOp_0", (String)"taxc-tcetr", (Object[])new Object[0]), org.getString("name"), DateUtils.format((Date)skssqq, (String)DateUtils.YYYYMMDD_CHINESE) + "-" + DateUtils.format((Date)skssqz, (String)DateUtils.YYYYMMDD_CHINESE)));
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List<Object> ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            String type = dataEntities[0].getString("type");
            CktsDraftSbbStatusUtils.deleteSbbMess(type, ids);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (DynamicObject entity : dataEntities) {
                try {
                    Object pkValue = entity.getPkValue();
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.billEntityType.getName());
                    String templatetype = declare.getString("type");
                    DeclareService.deleteReportByFilter(templatetype, new QFilter("id", "=", pkValue));
                    successObjs.add(entity);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u7533\u62a5\u6570\u636e\u5931\u8d25\uff01", (String)"DeclareQueryListOp_1", (String)"taxc-tcetr", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_declare_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                }
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
        if ("submit".equals(operationKey) || "unsubmit".equals(operationKey) || "audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            List ids = Arrays.stream(args.getDataEntities()).map(s -> s.getLong("id")).collect(Collectors.toList());
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.billEntityType.getName()));
            DeclareService.updateData(Arrays.stream(load).collect(Collectors.toList()), operationKey);
        }
    }
}

