/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.opplugin.wfrecord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class WfRecordListOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block13: {
                    Map<String, DynamicObject> dataMap;
                    block14: {
                        if (!EmptyCheckUtils.isNotEmpty((Object)this.dataEntities)) break block13;
                        List pkIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
                        String entityName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
                        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"id,taxorg,taxorg.name as orgName,createtime,wfseq,iscreatedraft,qylx", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                        dataMap = query.stream().collect(Collectors.toMap(d -> d.getString("id"), d -> d));
                        if (!"backwriteoff".equals(this.getOperateKey())) break block14;
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            String billPkId = dataEntity.getBillPkId().toString();
                            DynamicObject dyo = dataMap.get(billPkId);
                            if ("1".equals(dyo.getString("iscreatedraft"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u7684\u6838\u9500\u65e5\u671f\u4e3a%2$s\uff0c\u6838\u9500\u5e8f\u53f7%3$s\u7684\u6838\u9500\u7ed3\u679c\u5df2\u751f\u6210\u5e95\u7a3f\uff0c\u4e0d\u652f\u6301\u53cd\u6838\u9500\u3002", (String)"WfRecordListOp_0", (String)"taxc-tcetr", (Object[])new Object[0]), WfRecordListOp.this.getOrgName(dyo), DateUtils.format((Date)dyo.getDate("createtime")), dyo.getString("wfseq")));
                                continue;
                            }
                            if (!"2".equals(dyo.getString("iscreatedraft"))) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u7684\u6838\u9500\u65e5\u671f\u4e3a%2$s\uff0c\u6838\u9500\u5e8f\u53f7%3$s\u7684\u6838\u9500\u7ed3\u679c\u751f\u6210\u5e95\u7a3f\u8fdb\u884c\u4e2d\uff0c\u4e0d\u652f\u6301\u53cd\u6838\u9500\u3002", (String)"WfRecordListOp_4", (String)"taxc-tcetr", (Object[])new Object[0]), WfRecordListOp.this.getOrgName(dyo), DateUtils.format((Date)dyo.getDate("createtime")), dyo.getString("wfseq")));
                        }
                        break block13;
                    }
                    if (!"createdraft".equals(this.getOperateKey())) break block13;
                    ArrayList<String> message = new ArrayList<String>();
                    String orgId = null;
                    String qylx = null;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String msg;
                        String billPkId = dataEntity.getBillPkId().toString();
                        DynamicObject dyo = dataMap.get(billPkId);
                        if ("1".equals(dyo.getString("iscreatedraft"))) {
                            msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u6838\u9500\u65e5\u671f\u4e3a%2$s\uff0c\u6838\u9500\u5e8f\u53f7%3$s\u7684\u6838\u9500\u7ed3\u679c\u5df2\u751f\u6210\u5e95\u7a3f\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"WfRecordListOp_3", (String)"taxc-tcetr", (Object[])new Object[0]), WfRecordListOp.this.getOrgName(dyo), DateUtils.format((Date)dyo.getDate("createtime")), dyo.getString("wfseq"));
                            message.add(msg);
                        } else if ("2".equals(dyo.getString("iscreatedraft"))) {
                            msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u6838\u9500\u65e5\u671f\u4e3a%2$s\uff0c\u6838\u9500\u5e8f\u53f7%3$s\u7684\u6838\u9500\u7ed3\u679c\u751f\u6210\u5e95\u7a3f\u8fdb\u884c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"WfRecordListOp_5", (String)"taxc-tcetr", (Object[])new Object[0]), WfRecordListOp.this.getOrgName(dyo), DateUtils.format((Date)dyo.getDate("createtime")), dyo.getString("wfseq"));
                            message.add(msg);
                        }
                        if (orgId == null) {
                            orgId = dyo.getString("taxorg");
                        } else if (!orgId.equals(dyo.getString("taxorg"))) {
                            ValidateResult result = new ValidateResult();
                            result.setMessage(ResManager.loadKDString((String)"\u540c\u4e00\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u7684\u6838\u9500\u7ed3\u679c\u624d\u80fd\u751f\u6210\u5e95\u7a3f\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"WfRecordListOp_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                            WfRecordListOp.this.getOperationResult().getValidateResult().addValidateError("sameOrg", result);
                            WfRecordListOp.this.getOperationResult().setSuccess(false);
                            return;
                        }
                        TaxResult checkResult = TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(orgId), (String)"tcetr");
                        if (checkResult != null && Boolean.TRUE.equals(checkResult.getData())) {
                            ValidateResult result = new ValidateResult();
                            result.setMessage(checkResult.getMessage());
                            WfRecordListOp.this.getOperationResult().getValidateResult().addValidateError("orgnotauth", result);
                            WfRecordListOp.this.getOperationResult().setSuccess(false);
                            return;
                        }
                        if (qylx == null) {
                            qylx = dyo.getString("qylx");
                            continue;
                        }
                        if (qylx.equals(dyo.getString("qylx"))) continue;
                        ValidateResult result = new ValidateResult();
                        result.setMessage(ResManager.loadKDString((String)"\u540c\u4e00\u201c\u4f01\u4e1a\u7c7b\u578b\u201d\u7684\u6838\u9500\u7ed3\u679c\u624d\u80fd\u751f\u6210\u5e95\u7a3f\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"WfRecordListOp_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                        WfRecordListOp.this.getOperationResult().getValidateResult().addValidateError("sameQylx", result);
                        WfRecordListOp.this.getOperationResult().setSuccess(false);
                        return;
                    }
                    if (!message.isEmpty()) {
                        WfRecordListOp.this.getOperationResult().setSuccess(false);
                        for (String s : message) {
                            ValidateResult result = new ValidateResult();
                            result.setMessage(s);
                            WfRecordListOp.this.getOperationResult().getValidateResult().addValidateError("isCreateDraft", result);
                        }
                    }
                }
            }
        });
    }

    private String getOrgName(DynamicObject obj) {
        String orgName = obj.getString("orgName");
        if (orgName == null) {
            orgName = "";
        }
        return orgName;
    }
}

