/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.business.draft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class ExtRecordServiceHelper {
    public static DynamicObject queryRecord(Object pkvalue) {
        QFilter filter = new QFilter("id", "=", pkvalue);
        return BusinessDataServiceHelper.loadSingle((String)"tcnfep_ext_record", (String)"id,billno,billstatus,contract,accnumber,recordnumber", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject queryAccount(Object pkvalue) {
        QFilter filter = new QFilter("id", "=", pkvalue);
        return BusinessDataServiceHelper.loadSingle((String)"tcnfep_ext_payment_acc", (String)MetadataUtil.getAllSubFieldString((String)"tcnfep_ext_payment_acc"), (QFilter[])new QFilter[]{filter});
    }

    public static List<DynamicObject> recordAudit(DynamicObject dynamicObject) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObject contractData = ExtRecordServiceHelper.getContract(dynamicObject);
        if (null != contractData) {
            contractData.set("recordnumber", dynamicObject.get("recordnumber"));
            list.add(contractData);
        }
        return list;
    }

    public static List<DynamicObject> recordUnAudit(DynamicObject dynamicObject) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObject contractData = ExtRecordServiceHelper.getContract(dynamicObject);
        if (null != contractData) {
            contractData.set("recordnumber", null);
            list.add(contractData);
        }
        return list;
    }

    public static List<DynamicObject> recordResetContract(DynamicObject dynamicObject) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObject contractData = ExtRecordServiceHelper.getContract(dynamicObject);
        if (null != contractData) {
            contractData.set("recordnumber", null);
            list.add(contractData);
        }
        return list;
    }

    public static List<DynamicObject> recordResetAccount(DynamicObject dynamicObject) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObject accountData = ExtRecordServiceHelper.getAccount(dynamicObject);
        if (null != accountData) {
            accountData.set("recordnumber", null);
            list.add(accountData);
        }
        return list;
    }

    public static List<DynamicObject> recordSave(DynamicObject dynamicObject) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObject accountData = ExtRecordServiceHelper.getAccount(dynamicObject);
        if (null != accountData) {
            accountData.set("recordnumber", dynamicObject.get("billno"));
            list.add(accountData);
        }
        return list;
    }

    private static DynamicObject getContract(DynamicObject dynamicObject) {
        QFilter filter = new QFilter("id", "=", dynamicObject.get("contract.id"));
        return BusinessDataServiceHelper.loadSingle((String)"tcnfep_contract_info", (String)"id,billstatus,recordnumber", (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject getAccount(DynamicObject dynamicObject) {
        QFilter filter = new QFilter("billno", "=", dynamicObject.get("accnumber"));
        return BusinessDataServiceHelper.loadSingle((String)"tcnfep_ext_payment_acc", (String)"id,billstatus,recordnumber", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getAccount(String billno) {
        QFilter filter = new QFilter("billno", "=", (Object)billno);
        return BusinessDataServiceHelper.loadSingle((String)"tcnfep_ext_payment_acc", (String)"id,contractname,collectionbank,collectionaccount,currentpaymentamount,paymentcurrency,paydate,draftnumber,sjfkjeyb", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getRecord(DynamicObject dynamicObject) {
        QFilter filter = new QFilter("billno", "=", dynamicObject.get("recordnumber"));
        return BusinessDataServiceHelper.loadSingle((String)"tcnfep_ext_record", (String)MetadataUtil.getAllSubFieldString((String)"tcnfep_ext_record"), (QFilter[])new QFilter[]{filter});
    }

    public static void updateRecord(DynamicObject account, DynamicObject record) {
        if (record != null && account != null) {
            record.set("collectionbank", (Object)account.getString("collectionbank"));
            record.set("collectionaccount", (Object)account.getString("collectionaccount"));
            record.set("currentpaymentamount", account.get("currentpaymentamount"));
            record.set("paymentcurrency", account.get("paymentcurrency"));
            record.set("paydate", account.get("paydate"));
            record.set("contract", account.get("contractname"));
            if (account.get("contractname") != null) {
                DynamicObject contract = (DynamicObject)account.get("contractname");
                record.set("correlation", (Object)contract.getString("relatetrader"));
                record.set("contractnumber", (Object)contract.getString("billno"));
                record.set("qdhtrq", contract.get("qdhtrq"));
                record.set("htzxqsrq", contract.get("htzxqsrq"));
                record.set("htzxzzrq", contract.get("htzxzzrq"));
                record.set("contractcurrency", contract.get("contractcurrency"));
                record.set("contractamount", contract.get("contractamount"));
                record.set("contractamount", contract.get("contractamount"));
                record.set("payeename", contract.get("peyeename.name"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
    }

    public static ListShowParameter getPayaccountListShowParameter(List<QFilter> qFilters) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("tcnfep_ext_payment_acc");
        listShowParameter.setFormId("bos_list");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setLookUp(true);
        listShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
        return listShowParameter;
    }

    public static void clearPayaccountDraftnumber(List<String> draftnumberList) {
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"tcnfep_ext_payment_acc", (String)"draftnumber", (QFilter[])new QFilter[]{new QFilter("draftnumber", "in", draftnumberList)});
        Arrays.stream(result).forEach(e -> e.set("draftnumber", (Object)" "));
        SaveServiceHelper.update((DynamicObject[])result);
    }

    public static Map<String, String> getTaxRecordNumbers(List<String> taxRecordNumbers) {
        QFilter q1 = new QFilter("recordnumber", "in", taxRecordNumbers);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcnfep_contract_info", (String)"id,billno,recordnumber", (QFilter[])new QFilter[]{q1});
        return dynamicObjects.stream().collect(Collectors.toMap(e -> e.getString("billno"), e -> e.getString("recordnumber"), (k, v) -> k));
    }

    public static Map<Long, String> getMapByContractId(List<Long> contractIds) {
        QFilter q1 = new QFilter("contract.id", "in", contractIds);
        QFilter q2 = new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"B", "C"}));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcnfep_ext_record", (String)"id,billno,contract.id", (QFilter[])new QFilter[]{q1, q2});
        return dynamicObjects.stream().collect(Collectors.toMap(e -> e.getLong("contract.id"), e -> e.getString("billno"), (k, v) -> k));
    }
}

