/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.business.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxsupplier.TaxSupplierDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class WithholdRemitHelper {
    private static final String EXP_ZZS_1 = "jsjc/(1-qysdsl)";
    private static final String EXP_ZZS_2 = "jsjc/(1+zzsl)";
    private static final String EXP_ZZS_11 = "jsjc*zzsl";
    private static final String EXP_ZZS_3 = "jsjc";
    private static final String EXP_ZZS_4 = "jsjc/(1-zzsl)*zzsl";
    private static final String EXP_ZZS_5 = "jsjc/(1-hdlrl*qysdsl)";
    private static final String EXP_ZZS_6 = "jsjc/(1-discountrate)";
    private static final String EXP_ZZS_9 = "jsjc/(1+zzsl-qysdsl)";
    private static final String EXP_ZZS_10 = "jsjc/(1+zzsl-hdlrl*qysdsl)";
    private static final String EXP_QYSDS_1 = "jsjc/(1-qysdsl)*qysdsl";
    private static final String EXP_QYSDS_2 = "jsjc/(1+zzsl)*qysdsl";
    private static final String EXP_QYSDS_3 = "jsjc*qysdsl";
    private static final String EXP_QYSDS_4 = "jsjc/(1+zzsl-qysdsl)*qysdsl";
    private static final String EXP_QYSDS_5 = "jsjc/(1-hdlrl*qysdsl)*hdlrl*qysdsl";
    private static final String EXP_QYSDS_6 = "jsjc/(1+zzsl)*qysdsl*hdlrl";
    private static final String EXP_QYSDS_7 = "jsjc/(1-discountrate)*discountrate";
    private static final String EXP_QYSDS_8 = "jsjc/(1+zzsl)*discountrate";
    private static final String EXP_QYSDS_9 = "jsjc*discountrate";
    private static final String EXP_QYSDS_10 = "jsjc/(1-qysdsl)/(1+zzsl)*discountrate";
    private static final String EXP_QYSDS_12 = "jsjc*hdlrl*qysdsl";
    private static final String EXP_QYSDS_13 = "jsjc/(1+zzsl-hdlrl*qysdsl)*qysdsl*hdlrl";
    private static final String EXP_QYSDS_14 = "";
    private static final String EXP_QYSDS_15 = "jsjc/(1+zzsl)*qysdsl*hdlrl*discountrate";
    private static final String EXP_QYSDS_16 = "jsjc*hdlrl*qysdsl*discountrate";
    private static final String EXP_QYSDS_17 = "";
    private static final String EXP_SBSR_1 = "sqfkje";
    private static final String EXP_SBSR_2 = "sqfkje/(1-qysdsl)";
    private static final String EXP_SBSR_3 = "sqfkje/(1+zzsl)";
    private static final String EXP_SBSR_4 = "sqfkje/(1-qysdsl)/(1+zzsl)";
    private static final String EXP_SBSR_5 = "sqfkje/(1-discountrate)";
    private static final Map<String, String> formulaMap = new HashMap<String, String>();

    public static String getExpression(String taxtype, Boolean sfxsssxdyh, Boolean needpayqysds, Boolean sfswzzcdzzs, Boolean sfswzzcdqysds, BigDecimal hdlrl, BigDecimal discountrate) {
        String key = hdlrl != null && hdlrl.compareTo(BigDecimal.ZERO) > 0 && discountrate != null && sfxsssxdyh != false && "qysds".equals(taxtype) ? String.format("hd-discount-%s-%s-%s-%s", taxtype, needpayqysds, sfswzzcdzzs, sfswzzcdqysds) : (hdlrl != null && hdlrl.compareTo(BigDecimal.ZERO) > 0 ? String.format("hd-%s-%s-%s-%s", taxtype, needpayqysds, sfswzzcdzzs, sfswzzcdqysds) : (discountrate != null && discountrate.compareTo(BigDecimal.ZERO) > 0 ? String.format("discount-%s-%s-%s-%s", taxtype, needpayqysds, sfswzzcdzzs, sfswzzcdqysds) : String.format("%s-%s-%s-%s", taxtype, needpayqysds, sfswzzcdzzs, sfswzzcdqysds)));
        return formulaMap.getOrDefault(key, "");
    }

    public static BigDecimal calclateZss(Boolean sfxsssxdyh, Boolean needpayqysds, Boolean sfswzzcdzzs, Boolean sfswzzcdqysds, BigDecimal jsjc, BigDecimal zzsl, BigDecimal qysdsl, BigDecimal hdlrl, BigDecimal discountrate) {
        String expression = WithholdRemitHelper.getExpression("zzs", sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, hdlrl, discountrate);
        return WithholdRemitHelper.calculateAmount(jsjc, zzsl, qysdsl, hdlrl, discountrate, expression);
    }

    public static BigDecimal calclateQysds(Boolean sfxsssxdyh, Boolean needpayqysds, Boolean sfswzzcdzzs, Boolean sfswzzcdqysds, BigDecimal jsjc, BigDecimal zzsl, BigDecimal qysdsl, BigDecimal hdlrl, BigDecimal discountrate) {
        String expression = WithholdRemitHelper.getExpression("qysds", sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, hdlrl, discountrate);
        return WithholdRemitHelper.calculateAmount(jsjc, zzsl, qysdsl, hdlrl, discountrate, expression);
    }

    public static BigDecimal calclateSbsr(Boolean sfxsssxdyh, Boolean needpayqysds, Boolean sfswzzcdzzs, Boolean sfswzzcdqysds, BigDecimal sqfkje, BigDecimal zzsl, BigDecimal qysdsl, BigDecimal hdlrl, BigDecimal discountrate) {
        String expression = WithholdRemitHelper.getExpression("sbsr", sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, hdlrl, discountrate);
        return WithholdRemitHelper.calculateAmount(sqfkje, zzsl, qysdsl, hdlrl, discountrate, expression);
    }

    private static BigDecimal calculateAmount(BigDecimal jsjc, BigDecimal zzsl, BigDecimal qysdsl, BigDecimal hdlrl, BigDecimal discountrate, String expression) {
        HashMap<String, String> amountMap = new HashMap<String, String>();
        amountMap.put(EXP_ZZS_3, WithholdRemitHelper.formatBigDecimal(jsjc));
        amountMap.put(EXP_SBSR_1, WithholdRemitHelper.formatBigDecimal(jsjc));
        amountMap.put("zzsl", WithholdRemitHelper.formatBigDecimal(zzsl));
        amountMap.put("qysdsl", WithholdRemitHelper.formatBigDecimal(qysdsl));
        amountMap.put("hdlrl", WithholdRemitHelper.formatBigDecimal(hdlrl));
        amountMap.put("discountrate", WithholdRemitHelper.formatBigDecimal(discountrate));
        if (StringUtil.isNotBlank((CharSequence)expression)) {
            for (Map.Entry entry : amountMap.entrySet()) {
                expression = expression.replaceAll((String)entry.getKey(), (String)entry.getValue());
            }
            return BigDecimalUtil.toBigDecimal((Object)FelService.eval((String)expression));
        }
        return null;
    }

    public static DynamicObject queryDraftByBillno(String billno) {
        return QueryServiceHelper.queryOne((String)"tcnfep_withhold_remit", (String)MetadataUtil.getAllFieldToQuery((String)"tcnfep_withhold_remit"), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
    }

    private static String formatBigDecimal(BigDecimal jsjc) {
        if (jsjc != null) {
            return jsjc.toString();
        }
        return "0";
    }

    public static DynamicObjectCollection queryDraftByNeedpayzzs() {
        return QueryServiceHelper.query((String)"tcnfep_withhold_remit", (String)"id,billno,needpayzzs", (QFilter[])new QFilter[]{new QFilter("needpayzzs", "=", (Object)"1")});
    }

    public static List<DynamicObject> findFitTreaty(DynamicObject payee, Date skssqq, Date skssqz) {
        DynamicObject object;
        List<Object> collect = new ArrayList<DynamicObject>();
        if (payee != null && (object = (DynamicObject)TaxSupplierDataServiceHelper.queryTaxSupplierBySupplierId((Long)payee.getLong("id")).getData()) != null) {
            DynamicObjectCollection collection = object.getDynamicObjectCollection("entry_treaty");
            if (collection.size() > 0 && skssqq != null && skssqz != null) {
                collect = collection.stream().filter(a -> WithholdRemitHelper.isEffectiveDate(skssqq, skssqz, DateUtils.stringToDate((String)a.getString("startdate")), DateUtils.stringToDate((String)a.getString("enddate")))).collect(Collectors.toList());
                return collect;
            }
            return new ArrayList<DynamicObject>((Collection<DynamicObject>)collection);
        }
        return collect;
    }

    public static boolean isEffectiveDate(Date date1, Date date2, Date start, Date end) {
        if (null == end) {
            return start.equals(date1) || DateUtils.isEffectiveDate((Date)date1, (Date)start, (Date)end);
        }
        return !(!start.equals(date1) && !DateUtils.isEffectiveDate((Date)date1, (Date)start, (Date)end) || !date2.equals(end) && !DateUtils.isEffectiveDate((Date)date2, (Date)start, (Date)end));
    }

    static {
        formulaMap.put("zzs-true-true-true", EXP_ZZS_1);
        formulaMap.put("zzs-true-false-false", EXP_ZZS_2);
        formulaMap.put("zzs-true-true-false", EXP_ZZS_3);
        formulaMap.put("zzs-true-false-true", EXP_ZZS_9);
        formulaMap.put("zzs-false-true-true", EXP_ZZS_3);
        formulaMap.put("zzs-false-true-false", EXP_ZZS_3);
        formulaMap.put("zzs-false-false-true", EXP_ZZS_2);
        formulaMap.put("zzs-false-false-false", EXP_ZZS_2);
        formulaMap.put("hd-zzs-true-true-true", EXP_ZZS_5);
        formulaMap.put("hd-zzs-true-false-false", EXP_ZZS_2);
        formulaMap.put("hd-zzs-true-true-false", EXP_ZZS_3);
        formulaMap.put("hd-zzs-true-false-true", EXP_ZZS_10);
        formulaMap.put("discount-zzs-true-true-true", EXP_ZZS_6);
        formulaMap.put("discount-zzs-true-false-false", EXP_ZZS_2);
        formulaMap.put("discount-zzs-true-true-false", EXP_ZZS_3);
        formulaMap.put("discount-zzs-true-false-true", EXP_ZZS_9);
        formulaMap.put("qysds-true-true-true", EXP_QYSDS_1);
        formulaMap.put("qysds-true-false-false", EXP_QYSDS_2);
        formulaMap.put("qysds-true-true-false", EXP_QYSDS_3);
        formulaMap.put("qysds-true-false-true", EXP_QYSDS_4);
        formulaMap.put("hd-qysds-true-true-true", EXP_QYSDS_5);
        formulaMap.put("hd-qysds-true-false-false", EXP_QYSDS_6);
        formulaMap.put("hd-qysds-true-true-false", EXP_QYSDS_12);
        formulaMap.put("hd-qysds-true-false-true", EXP_QYSDS_13);
        formulaMap.put("hd-discount-qysds-true-true-true", "");
        formulaMap.put("hd-discount-qysds-true-false-false", EXP_QYSDS_15);
        formulaMap.put("hd-discount-qysds-true-true-false", EXP_QYSDS_16);
        formulaMap.put("hd-discount-qysds-true-false-true", "");
        formulaMap.put("discount-qysds-true-true-true", EXP_QYSDS_7);
        formulaMap.put("discount-qysds-true-false-false", EXP_QYSDS_8);
        formulaMap.put("discount-qysds-true-true-false", EXP_QYSDS_9);
        formulaMap.put("discount-qysds-true-false-true", EXP_QYSDS_10);
        formulaMap.put("sbsr-true-true-true", EXP_SBSR_2);
        formulaMap.put("sbsr-true-false-false", EXP_SBSR_3);
        formulaMap.put("sbsr-true-true-false", EXP_SBSR_1);
        formulaMap.put("sbsr-true-false-true", EXP_SBSR_4);
        formulaMap.put("sbsr-false-true-false", EXP_SBSR_1);
        formulaMap.put("sbsr-false-false-false", EXP_SBSR_3);
        formulaMap.put("discount-sbsr-false-false-false", EXP_SBSR_3);
        formulaMap.put("discount-sbsr-false-true-false", EXP_SBSR_1);
        formulaMap.put("discount-sbsr-true-true-true", EXP_SBSR_5);
        formulaMap.put("discount-sbsr-true-false-false", EXP_SBSR_3);
        formulaMap.put("discount-sbsr-true-true-false", EXP_SBSR_1);
        formulaMap.put("discount-sbsr-true-false-true", EXP_SBSR_4);
    }
}

