/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.account;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.tcnfep.business.draft.ExtRecordServiceHelper;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;
import org.apache.commons.lang3.ObjectUtils;

public class PaymentAccountListPlugin
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List showFilter = (List)customParams.get("ShowFilter");
        if (!ObjectUtils.isEmpty((Object)showFilter)) {
            List listColumns = args.getListColumns();
            List columns = listColumns.stream().filter(e -> showFilter.contains(e.getListFieldKey())).collect(Collectors.toList());
            args.setListColumns(columns);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        FormOperate operate = (FormOperate)args.getSource();
        if ("newrecord".equals(operate.getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PaymentAccountListPlugin_8", (String)"taxc-tcnfep", (Object[])new Object[0]));
            } else if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() == 1) {
                DynamicObject contract;
                DynamicObject account = ExtRecordServiceHelper.queryAccount(selectedRows.get(0).getPrimaryKeyValue());
                DynamicObject dynamicObject = contract = account != null ? (DynamicObject)account.get("contractname") : null;
                if (contract != null) {
                    if (StringUtils.isNotBlank((CharSequence)contract.getString("recordnumber"))) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5408\u540c\u5df2\u529e\u7406\u5bf9\u5916\u652f\u4ed8\u5907\u6848\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210\u5907\u6848\u3002", (String)"PaymentAccountListPlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    } else if (!account.getString("billstatus").equals("C")) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5df2\u5ba1\u6838\u7684\u5bf9\u5916\u652f\u4ed8\u53f0\u8d26\u751f\u6210\u5bf9\u5916\u652f\u4ed8\u5907\u6848\u3002", (String)"PaymentAccountListPlugin_3", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    } else if (BigDecimal.valueOf(50000L).compareTo(account.getBigDecimal("sjfkjemy")) >= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d\uff08\u7f8e\u5143\uff09\u201d\u5c0f\u4e8e\u7b49\u4e8e5\u4e07\u7f8e\u5143\uff0c\u65e0\u9700\u751f\u6210\u5bf9\u5916\u652f\u4ed8\u5907\u6848\u3002", (String)"PaymentAccountListPlugin_10", (String)"taxc-tcnfep", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else if (StringUtils.isNotBlank((CharSequence)account.getString("recordnumber"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5408\u540c\u5df2\u751f\u6210\u652f\u4ed8\u5907\u6848\uff0c\u53ef\u70b9\u51fb\u201c\u652f\u4ed8\u5907\u6848\u5355\u636e\u7f16\u53f7\u201d\u67e5\u770b\u3002", (String)"PaymentAccountListPlugin_7", (String)"taxc-tcnfep", (Object[])new Object[0]));
                        args.setCancel(true);
                    } else {
                        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
                        BillShowParameter param = new BillShowParameter();
                        customParams.put("id", selectedRows.get(0).getPrimaryKeyValue());
                        customParams.put("orgid", selectedRows.get(0).getMainOrgId());
                        customParams.put("source", "paymentaccount");
                        param.setFormId("tcnfep_ext_record");
                        param.setCustomParams(customParams);
                        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        this.getView().showForm((FormShowParameter)param);
                    }
                }
            }
        } else if ("createdraft".equals(operate.getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86\u591a\u6761\u6570\u636e\u3002", (String)"PaymentAccountListPlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            DynamicObject account = ExtRecordServiceHelper.queryAccount(selectedRows.get(0).getPrimaryKeyValue());
            if (!Objects.isNull(account) && !account.getString("draftnumber").isEmpty()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u53f0\u8d26\u5df2\u751f\u6210\u5e95\u7a3f\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"PaymentAccountListPlugin_6", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            this.createDraft(account);
        }
    }

    public void createDraft(DynamicObject account) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("tcnfep_withhold_remit");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("source", "tcnfep_ext_payment_acc_createdraft");
        customParams.put("org", account.getDynamicObject("org").getLong("id"));
        customParams.put("contract", account.getDynamicObject("contractname").getLong("id"));
        customParams.put("payaccountnumber", account.getString("billno"));
        customParams.put("payee", account.getDynamicObject("contractname").getDynamicObject("peyeename").getLong("id"));
        customParams.put("isrelatedparty", account.getDynamicObject("contractname").getBoolean("relatetrader"));
        customParams.put("skssqq", account.getDate("startdate"));
        customParams.put("skssqz", account.getDate("enddate"));
        customParams.put("sqfkjewb", account.getBigDecimal("currentpaymentamount"));
        customParams.put("paymentcurrency", account.getDynamicObject("paymentcurrency").getLong("id"));
        customParams.put("payrate", "CNY".equals(account.getDynamicObject("paymentcurrency").getString("number")) ? BigDecimal.ONE : null);
        param.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)param);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Object pkid = currentSelectedRowInfo.getPrimaryKeyValue();
        if (args.getFieldName().equals("recordnumber")) {
            args.setCancel(true);
            DynamicObject account = ExtRecordServiceHelper.queryAccount(pkid);
            DynamicObject record = ExtRecordServiceHelper.getRecord(account);
            if (record == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u5bf9\u5916\u652f\u4ed8\u5907\u6848\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PaymentAccountListPlugin_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            BillShowParameter billparam = new BillShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("pkid", record.get("id"));
            billparam.setCustomParams(customParams);
            billparam.setFormId("tcnfep_ext_record");
            billparam.setPkId(record.get("id"));
            billparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billparam.setBillStatus(BillOperationStatus.EDIT);
            billparam.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billparam);
        } else if ("draftnumber".equals(args.getFieldName())) {
            args.setCancel(true);
            DynamicObject account = ExtRecordServiceHelper.queryAccount(pkid);
            DynamicObject draft = WithholdRemitHelper.queryDraftByBillno(account.getString("draftnumber"));
            if (draft == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u4ee3\u6263\u4ee3\u7f34\u5e95\u7a3f\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PaymentAccountListPlugin_9", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            BillShowParameter billparam = new BillShowParameter();
            billparam.setFormId("tcnfep_withhold_remit");
            billparam.setPkId(draft.get("id"));
            billparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billparam.setBillStatus(BillOperationStatus.EDIT);
            billparam.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billparam);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("newrecord".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            DynamicObject account = ExtRecordServiceHelper.queryAccount(list.get(0).getPrimaryKeyValue());
            DynamicObject record = ExtRecordServiceHelper.getRecord(account);
            ExtRecordServiceHelper.updateRecord(account, record);
            BillShowParameter billparam = new BillShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("pkid", record.get("id"));
            billparam.setCustomParams(customParams);
            billparam.setFormId("tcnfep_ext_record");
            billparam.setPkId(record.get("id"));
            billparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billparam.setBillStatus(BillOperationStatus.EDIT);
            billparam.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billparam);
        }
    }
}

