/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class PaymentAccountPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit tablefield = (BasedataEdit)this.getControl("contractname");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Date preEndMonth = DateUtils.getLastMaxMonthDate();
        this.getModel().setValue("enddate", (Object)preEndMonth);
        Date preStartMonth = DateUtils.getFirstDateOfMonth((Date)preEndMonth);
        this.getModel().setValue("startdate", (Object)preStartMonth);
        this.setEnable();
    }

    public void afterLoadData(EventObject e) {
        this.setEnable();
    }

    private void setEnable() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String draftnumber = dataEntity.getString("draftnumber");
        QFilter q1 = new QFilter("billno", "=", (Object)draftnumber);
        QFilter q2 = new QFilter("billstatus", "=", (Object)"C");
        boolean existAuditDraft = QueryServiceHelper.exists((String)"tcnfep_withhold_remit", (QFilter[])new QFilter[]{q1, q2});
        this.getView().setEnable(Boolean.valueOf(existAuditDraft), new String[]{"sjfkjeyb", "dollarexchangerate"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("contractname".equals(name)) {
            Object org = this.getModel().getValue("org");
            if (Objects.isNull(org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"PaymentAccountPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)org).get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
            Object paydate = this.getModel().getValue("paydate");
            if (Objects.nonNull(paydate)) {
                QFilter paydateFilter = new QFilter("qdhtrq", "<=", paydate);
                formShowParameter.getListFilterParameter().getQFilters().add(paydateFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object contract = this.getModel().getValue("contractname");
        if ("contractname".equals(name)) {
            if (Objects.nonNull(contract)) {
                this.getModel().setValue("collectionbank", ((DynamicObject)contract).get("providerbankname"));
                this.getModel().setValue("collectionaccount", ((DynamicObject)contract).get("providerbankacc"));
                this.getModel().setValue("paymentcurrency", ((DynamicObject)contract).get("contractcurrency"));
                this.getModel().setValue("taxrecordnumber", ((DynamicObject)contract).get("recordnumber"));
            } else {
                this.getModel().setValue("taxrecordnumber", (Object)"");
            }
        } else if ("dollarexchangerate".equals(name) || "sjfkjeyb".equals(name)) {
            this.calSjfkjemy();
        }
    }

    private void calSjfkjemy() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal sjfkjeyb = dataEntity.getBigDecimal("sjfkjeyb");
        BigDecimal dollarexchangerate = dataEntity.getBigDecimal("dollarexchangerate");
        BigDecimal sjfkjemy = BigDecimalUtil.multiplyObject((Object)sjfkjeyb, (Object)dollarexchangerate, (int)2, (int)4);
        this.getModel().setValue("sjfkjemy", (Object)sjfkjemy);
    }
}

