/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.contract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class ContractInfoEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String CONTRACTTYPE_BKJSDS = "bkjsds";
    private static final List<Long> INCOME_ITEMS = Arrays.asList(1387078908507352068L, 1387078908507352069L, 1387078908507352070L, 1387078908507352072L);
    private static final List<Long> XD_INCOME_ITEMS = Arrays.asList(1387078908507352074L, 1387078908507352075L, 1387078908507352077L, 1387078908507352078L, 1387078908507352079L, 1387078908507352072L);
    private static String IS_CLOSE = "true";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit incomeItemsCtrl = (BasedataEdit)this.getControl("incomeitems");
        incomeItemsCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit xdIncomeItemsCtrl = (BasedataEdit)this.getControl("xdincomeitems");
        xdIncomeItemsCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean sfqbjwlw = (Boolean)this.getModel().getValue("sfqbjwlw");
        if (!sfqbjwlw) {
            this.updateZyhlwdd();
        }
    }

    public void beforeBindData(EventObject e) {
        Date htzxqsrq;
        String contracttype = (String)this.getModel().getValue("contracttype");
        this.setMustInput(contracttype);
        this.updateZhzyhlwrsMustInput();
        Date qdhtrq = (Date)this.getModel().getValue("qdhtrq");
        DateEdit htzxqsrqEdit = (DateEdit)this.getControl("htzxqsrq");
        if (qdhtrq != null) {
            htzxqsrqEdit.setMinDate(qdhtrq);
            ((DateEdit)this.getControl("htydfkrq")).setMinDate(qdhtrq);
            ((DateEdit)this.getControl("jhfkrq")).setMinDate(qdhtrq);
        }
        if ((htzxqsrq = (Date)this.getModel().getValue("htzxqsrq")) != null) {
            ((DateEdit)this.getControl("htzxzzrq")).setMinDate(htzxqsrq);
        }
        this.setMaxDate();
        DynamicObject peyeename = (DynamicObject)this.getModel().getValue("peyeename");
        if (Objects.nonNull(peyeename)) {
            this.getModel().setValue("providername", (Object)peyeename.getString("name"));
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        if ("contracttype".equals(name)) {
            String oldValue = (String)changeData.getOldValue();
            String newValue = (String)changeData.getNewValue();
            if (CONTRACTTYPE_BKJSDS.equals(newValue)) {
                this.getModel().setValue("needpayzzs", (Object)"1");
            } else if (CONTRACTTYPE_BKJSDS.equals(oldValue)) {
                this.getModel().setValue("needpayzzs", (Object)"");
            }
            this.setMustInput(newValue);
            this.getModel().setValue("incomeitems", null);
            this.getModel().setValue("xdincomeitems", null);
        } else if ("qdhtrq".equals(name)) {
            Date newValue = (Date)changeData.getNewValue();
            ((DateEdit)this.getControl("htzxqsrq")).setMinDate(newValue);
            ((DateEdit)this.getControl("htydfkrq")).setMinDate(newValue);
            ((DateEdit)this.getControl("jhfkrq")).setMinDate(newValue);
        } else if ("htzxqsrq".equals(name)) {
            Date newValue = (Date)changeData.getNewValue();
            ((DateEdit)this.getControl("htzxzzrq")).setMinDate(newValue);
            this.setMaxDate();
        } else if ("htzxzzrq".equals(name) || "htydfkrq".equals(name) || "jhfkrq".equals(name)) {
            this.setMaxDate();
        } else if ("providereqpayee".equals(name)) {
            DynamicObject peyeename = (DynamicObject)this.getModel().getValue("peyeename");
            if (Objects.isNull(peyeename)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"ContractInfoEditPlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                this.getModel().setValue("providereqpayee", (Object)Boolean.FALSE);
            }
        } else if ("sfqbjwlw".equals(name)) {
            boolean sfqbjwlw = (Boolean)changeData.getNewValue();
            if (sfqbjwlw) {
                this.getModel().setValue("zhzyhlwrs", null);
            } else {
                this.updateZyhlwdd();
            }
            this.updateZhzyhlwrsMustInput();
        } else if ("incomeitems".equals(name)) {
            String contracttype = (String)this.getModel().getValue("contracttype");
            DynamicObject incomeitems = (DynamicObject)this.getModel().getValue("incomeitems");
            if (incomeitems != null && "01".equals(incomeitems.get("number"))) {
                this.getModel().setValue("payqysds", (Object)"1");
            } else if (CONTRACTTYPE_BKJSDS.equals(contracttype)) {
                this.getModel().setValue("payqysds", (Object)"0");
            } else {
                this.getModel().setValue("payqysds", (Object)"1");
            }
        }
    }

    private void updateZyhlwdd() {
        TaxResult result;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"))).getData() != null) {
            this.getModel().setValue("zyhlwdd", (Object)((DynamicObject)result.getData()).getString("actualaddress"));
        }
    }

    private void updateZhzyhlwrsMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean sfqbjwlw = dataEntity.getBoolean("sfqbjwlw");
        DecimalEdit zhzyhlwrs = (DecimalEdit)this.getControl("zhzyhlwrs");
        zhzyhlwrs.setMustInput(!sfqbjwlw);
        FieldProp property = (FieldProp)this.getModel().getProperty("zhzyhlwrs");
        property.setMustInput(!sfqbjwlw);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("incomeitems".equals(name) || "xdincomeitems".equals(name)) {
            String contracttype = (String)this.getModel().getValue("contracttype");
            if ("fbgczyhlwxm".equals(contracttype)) {
                evt.setCustomQFilters(Collections.singletonList(new QFilter("id", "in", "incomeitems".equals(name) ? INCOME_ITEMS : XD_INCOME_ITEMS)));
            } else {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
                filters.add(new QFilter("bizdef.number", "=", (Object)"INCOME_TYPE"));
                filters.add(new QFilter("ispayproject", "=", (Object)"1"));
                evt.setCustomQFilters(filters);
            }
        }
    }

    private void setMustInput(String contracttype) {
        BasedataEdit projecttypeCtrl = (BasedataEdit)this.getControl("projecttype");
        BasedataEdit incomeitemsCtrl = (BasedataEdit)this.getControl("incomeitems");
        BasedataEdit xdincomeitemsCtrl = (BasedataEdit)this.getControl("xdincomeitems");
        projecttypeCtrl.setMustInput("fbgczyhlwxm".equals(contracttype));
        incomeitemsCtrl.setMustInput(true);
        xdincomeitemsCtrl.setMustInput(!CONTRACTTYPE_BKJSDS.equals(contracttype));
    }

    private void setMaxDate() {
        DynamicObjectCollection entryentity;
        DateEdit htzxqsrqEdit = (DateEdit)this.getControl("htzxqsrq");
        Date htzxqsrq = (Date)this.getModel().getValue("htzxqsrq");
        Date minDate = null;
        if (htzxqsrq != null) {
            minDate = htzxqsrq;
        }
        if (!(entryentity = this.getModel().getEntryEntity("entryentity")).isEmpty()) {
            for (DynamicObject dyo : entryentity) {
                Date jhfkrq;
                Date htydfkrq = dyo.getDate("htydfkrq");
                if (htydfkrq != null && (minDate == null || minDate.compareTo(htydfkrq) > 0)) {
                    minDate = htydfkrq;
                }
                if ((jhfkrq = dyo.getDate("jhfkrq")) == null || minDate != null && minDate.compareTo(jhfkrq) <= 0) continue;
                minDate = jhfkrq;
            }
        }
        ((DateEdit)this.getControl("qdhtrq")).setMaxDate(minDate);
        Date htzxzzrq = (Date)this.getModel().getValue("htzxzzrq");
        if (htzxzzrq != null) {
            htzxqsrqEdit.setMaxDate(htzxzzrq);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dyo = this.getModel().getDataEntity();
        DynamicProperty sfswzzcdzzs = dyo.getDynamicObjectType().getProperty("sfswzzcdzzs");
        DynamicProperty needpayqysds = dyo.getDynamicObjectType().getProperty("needpayqysds");
        DynamicProperty sfswzzcdqysds = dyo.getDynamicObjectType().getProperty("sfswzzcdqysds");
        dyo.getDataEntityState().setBizChanged(sfswzzcdzzs.getOrdinal(), false);
        dyo.getDataEntityState().setBizChanged(needpayqysds.getOrdinal(), false);
        dyo.getDataEntityState().setBizChanged(sfswzzcdqysds.getOrdinal(), false);
        Boolean iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (ObjectUtils.isEmpty((Object)iscopy) || !iscopy.booleanValue()) {
            return;
        }
        if (!"ADDNEW".equals(this.getView().getFormShowParameter().getStatus().name())) {
            e.setCheckDataChange(false);
            return;
        }
        String isclosed = this.getPageCache().get("isclosed");
        if (IS_CLOSE.equals(isclosed)) {
            e.setCheckDataChange(false);
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ContractInfoEditPlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ContractInfoEditPlugin_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ContractInfoEditPlugin_3", (String)"taxc-tcnfep", (Object[])new Object[0]);
        String modifyMsg = ResManager.loadKDString((String)"\u590d\u5236\u5408\u540c\u4fe1\u606f", (String)"ContractInfoEditPlugin_4", (String)"taxc-tcnfep", (Object[])new Object[0]);
        this.getView().showConfirm(msg, modifyMsg, MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        e.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        if ("bar_close".equals(key) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put("isclosed", "true");
            this.getView().close();
        }
    }
}

