/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.declare;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TcnfepDkdjDeclarationEditNewPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    public static final String TPO_DECLARE_MAIN_TSC_BILLNO = "tpo_declare_main_tsc#billno";
    private static String DAFTNUMBER = "daftnumber";
    protected static final String DECLARE_NUMBER = "declarenumber";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bill = (BasedataEdit)this.getControl(DAFTNUMBER);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (DAFTNUMBER.equals(evt.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.getListFilterParameter().setFilter(new QFilter("org", "=", org.getPkValue()));
                formShowParameter.getListFilterParameter().setFilter(new QFilter("dkdjsbbid", "=", (Object)0L));
            }
            DynamicObjectCollection dynamicObjects = WithholdRemitHelper.queryDraftByNeedpayzzs();
            List billnoList = dynamicObjects.stream().map(a -> a.getString("billno")).collect(Collectors.toList());
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", billnoList));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getAppId();
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            if (appid == null || changeData == null || changeData.length == 0) {
                return;
            }
            Object object = changeData[0].getNewValue();
            if (object == null) {
                return;
            }
            DynamicObject org = (DynamicObject)object;
            String orgid = org.getString("id");
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, null);
            if (checkResult) {
                this.getModel().setValue("org", changeData[0].getOldValue());
            } else {
                this.getModel().setValue(DAFTNUMBER, null);
            }
        }
        if (DAFTNUMBER.equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject draft = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (draft != null) {
                if (draft.get("dkdjsbbid") != null && QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draft.getDynamicObject("dkdjsbbid").getLong("id"))})) {
                    return;
                }
                this.getModel().setValue("skssqq", (Object)draft.getDate("skssqq"));
                this.getModel().setValue("skssqz", (Object)draft.getDate("skssqz"));
                this.getPageCache().put("orgid", org != null ? org.getString("id") : null);
                this.getPageCache().put("skssqq", DateUtils.format((Date)draft.getDate("skssqq")));
                this.getPageCache().put("skssqz", DateUtils.format((Date)draft.getDate("skssqz")));
                if (org != null) {
                    String sbbbillno = DeclareServiceHelper.generateSBBNo((String)"tcnfep_dkdj_declare_main");
                    this.getPageCache().put("sbbbillno", sbbbillno);
                    this.getModel().setValue(DECLARE_NUMBER, (Object)sbbbillno);
                    this.getPageCache().put("billno", sbbbillno);
                    this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), true, false);
                }
            } else {
                this.getModel().setValue("skssqq", null);
                this.getModel().setValue("skssqz", null);
            }
        }
    }

    protected void doAfterSuccessSave() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(DAFTNUMBER);
        if (value != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)value.getLong("id"), (String)"tcnfep_withhold_remit");
            DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"declareRequest", DeclareRequestModel.class);
            object.set("dkdjsbbid", (Object)requestModel.getId());
            object.set("dkdjbasetype", (Object)"tpo_declare_base");
            SaveServiceHelper.update((DynamicObject)object);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("save".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject draft = (DynamicObject)this.getModel().getValue(DAFTNUMBER);
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcnfepKjqysdsDeclarePlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            String sbbid = this.getPageCache().get("sbbid") != null ? this.getPageCache().get("sbbid") : "0";
            DynamicObject sbbObj = QueryServiceHelper.queryOne((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (String)"billstatus,datatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
            if (draft != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)draft.get("id"), (String)"tcnfep_withhold_remit");
                String dkdjsbbid = object.getString("dkdjsbbid.id");
                if (StringUtils.isNotEmpty((CharSequence)dkdjsbbid) && !Objects.equals(dkdjsbbid, sbbid)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5e95\u7a3f", (String)"TcnfepDkdjDeclarationEditPlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    return;
                }
                if (sbbObj != null && !"A".equals(sbbObj.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u4fdd\u5b58", (String)"TcnfepDkdjDeclarationEditPlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    return;
                }
            } else if (sbbObj == null || Objects.equals(sbbObj.getString("datatype"), "1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e95\u7a3f\u518d\u4fdd\u5b58", (String)"TcnfepDkdjDeclarationEditPlugin_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
        }
        super.itemClick(evt);
    }

    protected void viewDraft() {
        this.taxSourceHyperLink();
    }

    public void init() {
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "dkdj";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        String sbbbillno = dataMap.get(TPO_DECLARE_MAIN_TSC_BILLNO);
        String sbbid = dataMap.get("tpo_declare_main_tsc#id");
        this.getModel().setValue(DECLARE_NUMBER, (Object)sbbbillno);
        this.getPageCache().put("sbbid", sbbid);
    }

    protected void doInLoadFromHyperLinkClick(String sbbid) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcnfep_withhold_remit_f7", (String)"id", (QFilter[])new QFilter[]{new QFilter("dkdjsbbid", "=", (Object)Long.parseLong(sbbid))});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            this.getModel().setValue(DAFTNUMBER, (Object)((DynamicObject)query.get(0)).getLong("id"));
        }
        this.getPageCache().put("sbbid", sbbid);
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        Object checkisopenbyworkflow = this.getView().getFormShowParameter().getCustomParam("checkisopenbyworkflow");
        if (Objects.equals(checkisopenbyworkflow, true) || Objects.equals(checkisopenbyworkflow, "true") || Objects.equals(checkisopenbyworkflow, Boolean.TRUE)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "daftnumber"});
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        this.getModel().setValue("org", (Object)orgId);
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        Object daftnumber = this.getModel().getValue("daftnumber");
        Object skssqq = this.getModel().getValue("skssqq");
        Object skssqz = this.getModel().getValue("skssqz");
        return Objects.nonNull(daftnumber) && Objects.nonNull(skssqq) && Objects.nonNull(skssqz);
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        return null;
    }

    protected QFilter getDeclareMainQueryParams() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sbbId = this.getPageCache().get("sbbid");
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(StringUtil.isBlank((CharSequence)sbbId) ? "0" : sbbId));
        return filter;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        extendParams.put("sbbid", this.getPageCache().get("sbbid"));
        requestModel.setExtendParams(extendParams);
        if (requestModel.getRefresh().booleanValue()) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(DAFTNUMBER);
            if (value != null) {
                requestModel.addBusinessValue("daftnumber", value.getString("number"));
            }
            requestModel.addBusinessValue("declaredatedkdj", StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("declaredate")) ? this.getPageCache().get("declaredate") : DateUtils.format((Date)new Date()));
        }
        return requestModel;
    }

    protected String getUniKey() {
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        return String.format("%s_%s_%s_%s", orgId, skssq, skssz, this.getTemplateType());
    }

    public void taxSourceHyperLink() {
        DynamicObject draft = (DynamicObject)this.getModel().getValue(DAFTNUMBER);
        if (draft != null) {
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcnfep_withhold_remit", (Object)draft.get("id"), (IFormView)this.getView(), new HashMap(), (BillOperationStatus)BillOperationStatus.VIEW);
        }
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("recalc".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            DynamicObject draft = (DynamicObject)this.getModel().getValue(DAFTNUMBER);
            if (draft != null) {
                this.getModel().setValue("skssqq", (Object)draft.getDate("skssqq"));
                this.getModel().setValue("skssqz", (Object)draft.getDate("skssqz"));
                this.getPageCache().put("skssqq", DateUtils.format((Date)draft.getDate("skssqq")));
                this.getPageCache().put("skssqz", DateUtils.format((Date)draft.getDate("skssqz")));
            }
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), true, true);
            String templatetype = this.getTemplateType();
            String orgIdStr = this.getPageCache().get("orgid");
            Long orgId = StringUtil.isNotEmpty((CharSequence)orgIdStr) ? Long.parseLong(orgIdStr) : 0L;
            OperatorDialogUtils.operateDialog((String)templatetype, (String)"tcnfep_dkdj_declare_new", (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"TcnfepDkdjDeclarationEditNewPlugin_01", (String)"taxc-tcnfep", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"TcnfepDkdjDeclarationEditNewPlugin_02", (String)"taxc-tcnfep", (Object[])new Object[0]), this.getPageCache().get("billno")), (Long)orgId);
            return;
        }
        if ("recalc".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Cancel) {
            return;
        }
        super.confirmCallBack(e);
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
        String appid = this.getView().getFormShowParameter().getAppId();
        String orgid = (String)customParams.get("orgid");
        Boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, null);
        if (!checkResult.booleanValue()) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgid));
            this.getModel().setValue(DAFTNUMBER, customParams.get("draftid"));
            this.getModel().setValue("skssqq", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))));
            this.getModel().setValue("skssqz", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
            this.getPageCache().put("skssqq", (String)customParams.get("skssqq"));
            this.getPageCache().put("skssqz", (String)customParams.get("skssqz"));
            this.getPageCache().put("orgid", orgid);
            this.loadData(DateUtils.stringToDate((String)((String)customParams.get("skssqq"))), DateUtils.stringToDate((String)((String)customParams.get("skssqz"))), true, true);
        }
    }
}

