/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPlugin;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;
import kd.taxc.tcnfep.formplugin.declare.DkdjDraftNumberListener;
import kd.taxc.tcnfep.formplugin.declare.DkdjOrgListener;
import org.apache.commons.lang3.StringUtils;

public class TcnfepDkdjDeclarationEditPlugin
extends AbstractDeclareReportPlugin
implements BeforeF7SelectListener {
    public static final String TCNFEP_WITHHOLD_REMIT = "tcnfep_withhold_remit";
    public static final String TCNFEP_DKDJ_DECLARE_LIST = "tcnfep_dkdj_declare_main";
    public static final String VIEW_DRAFT_KEY = "bar_viewdraft";
    private static List<IControlListener> controlListeners = new ArrayList<IControlListener>();

    public TcnfepDkdjDeclarationEditPlugin() {
        this.setControlListeners(controlListeners);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit draftNumber = (BasedataEdit)this.getControl("daftnumber");
        draftNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            DynamicObject draft = (DynamicObject)this.getModel().getValue("daftnumber");
            String sbbid = this.getPageCache().get("sbbid");
            DynamicObject sbbObj = YbnsrService.queryYbnsr((String)sbbid);
            if (draft != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)draft.get("id"), (String)TCNFEP_WITHHOLD_REMIT);
                String dkdjsbbid = object.getString("dkdjsbbid.id");
                if (StringUtils.isNotEmpty((CharSequence)dkdjsbbid) && !Objects.equals(dkdjsbbid, sbbid)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5e95\u7a3f", (String)"TcnfepKjqysdsDeclarePlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    return;
                }
                if (sbbObj != null && !"A".equals(sbbObj.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u4fdd\u5b58", (String)"TcnfepKjqysdsDeclarePlugin_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    return;
                }
            }
        } else if (VIEW_DRAFT_KEY.equals(key)) {
            this.taxSourceHyperLink();
        }
        super.itemClick(evt);
    }

    private void taxSourceHyperLink() {
        DynamicObject draft = (DynamicObject)this.getModel().getValue("daftnumber");
        if (draft != null) {
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)TCNFEP_WITHHOLD_REMIT, (Object)draft.get("id"), (IFormView)this.getView(), new HashMap(), (BillOperationStatus)BillOperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("daftnumber".equals(evt.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.getListFilterParameter().setFilter(new QFilter("org", "=", org.getPkValue()));
                formShowParameter.getListFilterParameter().setFilter(new QFilter("dkdjsbbid", "=", (Object)0L));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcnfepDkdjDeclarationEditPlugin_3", (String)"taxc-tcnfep", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            DynamicObjectCollection dynamicObjects = WithholdRemitHelper.queryDraftByNeedpayzzs();
            List billnoList = dynamicObjects.stream().map(a -> a.getString("billno")).collect(Collectors.toList());
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", billnoList));
        }
    }

    public String getTemplateType() {
        return "dkdj";
    }

    protected void setRequestModel(DeclareRequestModel requestModel) {
        requestModel.addBusinessValue("taxsourceid", this.getPageCache().get("taxsourceid"));
        DynamicObject value = (DynamicObject)this.getModel().getValue("daftnumber");
        if (value != null) {
            requestModel.addBusinessValue("daftnumber", value.getString("number"));
        }
        requestModel.addBusinessValue("declaredatedkdj", StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("declaredate")) ? this.getPageCache().get("declaredate") : DateUtils.format((Date)new Date()));
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("businessno", this.getPageCache().get("businessno"));
        requestModel.setExtendParams(extendParams);
    }

    protected void doInLoadFromHyperLinkClick(DynamicObject nsrxx) {
        DynamicObject object = QueryServiceHelper.queryOne((String)TCNFEP_WITHHOLD_REMIT, (String)"id,billno,contract.id as contractid", (QFilter[])new QFilter[]{new QFilter("dkdjsbbid", "=", (Object)nsrxx.getLong("id"))});
        if (object != null) {
            String taxsourceid = object.getString("id");
            this.getModel().setValue("daftnumber", (Object)object.getLong("id"));
            this.getModel().setValue("daftnumber", (Object)object.getLong("id"));
            this.getPageCache().put("taxsourceid", taxsourceid);
            this.getPageCache().put("businessno", object.getString("billno"));
        }
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        if (!checkResult) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgid));
            this.getPageCache().put("orgid", orgid);
            this.getModel().setValue("daftnumber", customParams.get("draftid"));
            this.getPageCache().put("taxsourceid", String.valueOf(customParams.get("draftid")));
            DynamicObject withholdRemit = BusinessDataServiceHelper.loadSingle((Object)customParams.get("draftid"), (String)TCNFEP_WITHHOLD_REMIT);
            Date skssqq = withholdRemit.getDate("skssqq");
            this.getModel().setValue("skssqq", (Object)skssqq);
            String skssqqstr = DateUtils.format((Date)skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            Date skssqz = withholdRemit.getDate("skssqz");
            this.getModel().setValue("skssqz", (Object)skssqz);
            String skssqzstr = DateUtils.format((Date)skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            Long sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_DKDJ_DECLARE_LIST);
            this.getPageCache().put("sbbid", String.valueOf(sbbid));
            String sbbbillno = DeclareServiceHelper.generateSBBNo((String)TCNFEP_DKDJ_DECLARE_LIST);
            this.getPageCache().put("sbbbillno", sbbbillno);
            this.getModel().setValue("declarenumber", (Object)sbbbillno);
            this.getPageCache().put("businessno", withholdRemit.getString("billno"));
            this.openDeclarePage(false);
        }
    }

    public boolean initModelValue(boolean orgChange, String orgId) {
        Date date = new Date();
        Date startDate = DateUtils.getFirstDateOfMonth((Date)date);
        Date endDate = DateUtils.getLastDateOfMonth1((Date)date);
        this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
        this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        return false;
    }

    public void afterPropertyChanged(PropertyChangedArgs args, String changetype) {
        Long sbbid;
        String draftNumber = this.getPageCache().get("businessno");
        QFilter qFilter = new QFilter("billno", "=", (Object)draftNumber);
        DynamicObject object = QueryServiceHelper.queryOne((String)TCNFEP_WITHHOLD_REMIT, (String)"skssqq,skssqz,dkdjsbbid.billno as sbbbillno", (QFilter[])new QFilter[]{qFilter});
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        String sbbbillno = object.getString("sbbbillno");
        String operationStatus = "read";
        boolean refresh = false;
        if (StringUtil.isBlank((CharSequence)sbbbillno)) {
            operationStatus = "edit";
            sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_DKDJ_DECLARE_LIST);
            sbbbillno = DeclareServiceHelper.generateSBBNo((String)TCNFEP_DKDJ_DECLARE_LIST);
            refresh = true;
        } else {
            QFilter q1 = new QFilter("businessno", "=", (Object)draftNumber);
            QFilter q2 = new QFilter("type", "=", (Object)"kjqysds");
            DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billno", (QFilter[])new QFilter[]{q1, q2});
            sbbid = nsrxx.getLong("id");
            sbbbillno = nsrxx.getString("billno");
        }
        this.getModel().setValue("declarenumber", (Object)sbbbillno);
        this.getPageCache().put("sbbid", String.valueOf(sbbid));
        this.getPageCache().put("sbbbillno", sbbbillno);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
        this.showInnerPage(refresh, operationStatus);
    }

    protected DynamicObject queryNsrxx(String orgId, String templateType, String startdate, String enddate) {
        return YbnsrService.queryYbnsr((String)this.getPageCache().get("sbbid"));
    }

    protected void operationBill(String operationKey) {
        DynamicObject value;
        if ("save".equals(operationKey) && (value = (DynamicObject)this.getModel().getValue("daftnumber")) != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)value.getLong("id"), (String)TCNFEP_WITHHOLD_REMIT);
            object.set("dkdjsbbid", (Object)Long.parseLong(this.getPageCache().get("sbbid")));
            object.set("dkdjbasetype", (Object)"bdtaxr_nsrxx");
            SaveServiceHelper.update((DynamicObject)object);
        }
    }

    static {
        controlListeners.add((IControlListener)new DkdjOrgListener());
        controlListeners.add(new DkdjDraftNumberListener());
    }
}

