/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.declare;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TcnfepKjqysdsDeclareNewPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    public static final String DRAFT_NUMBER = "draft_number";
    public static final String CACHE_KEY_TAXSOURCEID = "taxsourceid";
    public static final String TCNFEP_WITHHOLD_REMIT = "tcnfep_withhold_remit";
    public static final String TCNFEP_KJ_DECLARE_MAIN_NEW = "tcnfep_kj_decl_main_new";
    protected static final String DECLARE_NUMBER = "declarenumber";
    public static final String TPO_DECLARE_MAIN_TSC_BILLNO = "tpo_declare_main_tsc#billno";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit draftNumber = (BasedataEdit)this.getControl(DRAFT_NUMBER);
        draftNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (DRAFT_NUMBER.equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcnfepKjqysdsDeclarePlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("org", "=", (Object)org.getLong("id")));
        }
    }

    protected void initStartAndEndDate(boolean orgChange) {
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        Object checkisopenbyworkflow = this.getView().getFormShowParameter().getCustomParam("checkisopenbyworkflow");
        if (Objects.equals(checkisopenbyworkflow, true) || Objects.equals(checkisopenbyworkflow, "true") || Objects.equals(checkisopenbyworkflow, Boolean.TRUE)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org", "daft_number"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Object newValue;
        String name = args.getProperty().getName();
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        if (DRAFT_NUMBER.equals(name)) {
            newValue = args.getChangeSet()[0].getNewValue();
            if (null == newValue) {
                return;
            }
            String draftNumber = ((DynamicObject)newValue).getString("number");
            QFilter qFilter = new QFilter("billno", "=", (Object)draftNumber);
            DynamicObject object = QueryServiceHelper.queryOne((String)TCNFEP_WITHHOLD_REMIT, (String)"skssqq,skssqz,qysdssbbid", (QFilter[])new QFilter[]{qFilter});
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            String qysdssbbid = object.getString("qysdssbbid");
            boolean refresh = false;
            String qysdssbbbillno = null;
            Long sbbid = 0L;
            if (StringUtil.isBlank((CharSequence)qysdssbbid) || "0".equals(qysdssbbid)) {
                sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_KJ_DECLARE_MAIN_NEW);
                qysdssbbbillno = DeclareServiceHelper.generateSBBNo((String)"tcnfep_kj_declare_main");
                refresh = true;
            } else {
                QFilter q1 = new QFilter("businessno", "=", (Object)draftNumber);
                QFilter q2 = new QFilter("templatetype", "=", (Object)"kjqysds");
                DynamicObject nsrxx = QueryServiceHelper.queryOne((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (String)"id,billno", (QFilter[])new QFilter[]{q1, q2});
                if (nsrxx != null) {
                    sbbid = nsrxx.getLong("id");
                    qysdssbbbillno = nsrxx.getString("billno");
                } else {
                    sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_KJ_DECLARE_MAIN_NEW);
                    qysdssbbbillno = DeclareServiceHelper.generateSBBNo((String)"tcnfep_kj_declare_main");
                    refresh = true;
                }
            }
            this.getModel().setValue(DECLARE_NUMBER, (Object)qysdssbbbillno);
            this.getPageCache().put("sbbbillno", qysdssbbbillno);
            this.getPageCache().put("billno", qysdssbbbillno);
            this.getPageCache().put("sbbid", String.valueOf(sbbid));
            this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
            this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
            this.loadData(skssqq, skssqz, false, refresh);
        }
        if (name.equals("org")) {
            newValue = args.getChangeSet()[0].getNewValue();
            Object oldValue = args.getChangeSet()[0].getOldValue();
            if (newValue == null && null != oldValue) {
                boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)((DynamicObject)oldValue).get("id").toString(), (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
                if (checkResult) {
                    return;
                }
                this.getModel().setValue("org", oldValue);
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String orgid = org.getString("id");
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getModel().setValue("org", oldValue);
            } else {
                this.getPageCache().put("orgid", orgid);
                DynamicObject oldValueObj = (DynamicObject)oldValue;
                this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString("id"));
            }
            this.getModel().setValue(DRAFT_NUMBER, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("recalc".equals(operateKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject draft = (DynamicObject)this.getModel().getValue(DRAFT_NUMBER);
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcnfepKjqysdsDeclarePlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (draft == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e95\u7a3f\u7f16\u7801", (String)"DraftNumberListener_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("recalc".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String templatetype = this.getTemplateType();
            String orgIdStr = this.getPageCache().get("orgid");
            Long orgId = StringUtil.isNotEmpty((CharSequence)orgIdStr) ? Long.parseLong(orgIdStr) : 0L;
            OperatorDialogUtils.operateDialog((String)templatetype, (String)"tcnfep_kj_declare_new", (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"TcnfepKjqysdsDeclareNewPlugin_01", (String)"taxc-tcnfep", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"TcnfepKjqysdsDeclareNewPlugin_02", (String)"taxc-tcnfep", (Object[])new Object[0]), this.getPageCache().get("billno")), (Long)orgId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("save".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject draft = (DynamicObject)this.getModel().getValue(DRAFT_NUMBER);
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcnfepKjqysdsDeclarePlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            if (draft == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e95\u7a3f\u7f16\u7801", (String)"DraftNumberListener_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            String sbbid = this.getPageCache().get("sbbid") != null ? this.getPageCache().get("sbbid") : "0";
            DynamicObject sbbObj = QueryServiceHelper.queryOne((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (String)"billstatus,datatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)draft.get("id"), (String)TCNFEP_WITHHOLD_REMIT);
            String qysdssbbid = object.getString("qysdssbbid.id");
            if (StringUtils.isNotEmpty((CharSequence)qysdssbbid) && !Objects.equals(qysdssbbid, sbbid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5e95\u7a3f", (String)"TcnfepKjqysdsDeclarePlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            if (sbbObj != null && !"A".equals(sbbObj.getString("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u4fdd\u5b58", (String)"TcnfepKjqysdsDeclarePlugin_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
        }
        super.itemClick(evt);
    }

    protected void viewDraft() {
        this.taxSourceHyperLink();
    }

    public void init() {
    }

    public String getTaxType() {
        return null;
    }

    private void taxSourceHyperLink() {
        DynamicObject draft = (DynamicObject)this.getModel().getValue(DRAFT_NUMBER);
        if (draft != null) {
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)TCNFEP_WITHHOLD_REMIT, (Object)draft.get("id"), (IFormView)this.getView(), new HashMap(), (BillOperationStatus)BillOperationStatus.VIEW);
        }
    }

    public String getTemplateType() {
        return "kjqysds";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        String sbbbillno = dataMap.get(TPO_DECLARE_MAIN_TSC_BILLNO);
        String sbbid = dataMap.get("tpo_declare_main_tsc#id");
        this.getPageCache().put("sbbid", sbbid);
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        this.getModel().setValue("org", (Object)orgId);
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        Object daftnumber = this.getModel().getValue(DRAFT_NUMBER);
        return Objects.nonNull(daftnumber);
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSCOO1.getModel();
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        DynamicObject value;
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.put("businessno", (value = (DynamicObject)this.getModel().getValue(DRAFT_NUMBER)) != null ? value.getString("number") : "");
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        requestModel.addBusinessValue(CACHE_KEY_TAXSOURCEID, value != null ? value.getString("id") : "0");
        return requestModel;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        return null;
    }

    protected QFilter getDeclareMainQueryParams() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sbbId = this.getPageCache().get("sbbid");
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(StringUtil.isBlank((CharSequence)sbbId) ? "0" : sbbId));
        return filter;
    }

    protected void doInLoadFromHyperLinkClick(String sbbid) {
        DynamicObjectCollection object = QueryServiceHelper.query((String)TCNFEP_WITHHOLD_REMIT, (String)"id,billno,contract.id as contractid", (QFilter[])new QFilter[]{new QFilter("qysdssbbid", "=", (Object)Long.parseLong(sbbid))});
        if (CollectionUtils.isNotEmpty((Collection)object)) {
            this.getModel().setValue(DRAFT_NUMBER, (Object)((DynamicObject)object.get(0)).getLong("id"));
            DynamicObject nsrxx = QueryServiceHelper.queryOne((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
            this.getModel().setValue(DECLARE_NUMBER, nsrxx != null ? nsrxx.getString("billno") : null);
            String taxsourceid = ((DynamicObject)object.get(0)).getString("id");
            this.getPageCache().put(CACHE_KEY_TAXSOURCEID, taxsourceid);
        }
        this.getPageCache().put("sbbid", sbbid);
    }

    protected String getUniKey() {
        String draftNumber = Optional.ofNullable((DynamicObject)this.getModel().getValue(DRAFT_NUMBER)).map(s -> s.getString("number")).orElseGet(() -> "");
        return String.format("%s_%s", draftNumber, this.getTemplateType());
    }

    protected void doAfterSuccessSave() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(DRAFT_NUMBER);
        if (value != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)value.getLong("id"), (String)TCNFEP_WITHHOLD_REMIT);
            DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"declareRequest", DeclareRequestModel.class);
            object.set("qysdssbbid", (Object)requestModel.getId());
            object.set("qysdsbasetype", (Object)"tpo_declare_base");
            SaveServiceHelper.update((DynamicObject)object);
        }
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        if (!checkResult) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgid));
            this.getPageCache().put("orgid", orgid);
            this.getModel().setValue(DRAFT_NUMBER, customParams.get("draftid"));
            this.getPageCache().put(CACHE_KEY_TAXSOURCEID, String.valueOf(customParams.get("draftid")));
            DynamicObject withholdRemit = BusinessDataServiceHelper.loadSingle((Object)customParams.get("draftid"), (String)TCNFEP_WITHHOLD_REMIT);
            Date skssqq = withholdRemit.getDate("skssqq");
            String skssqqstr = DateUtils.format((Date)skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            Date skssqz = withholdRemit.getDate("skssqz");
            String skssqzstr = DateUtils.format((Date)skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            Long sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_KJ_DECLARE_MAIN_NEW);
            this.getPageCache().put("sbbid", String.valueOf(sbbid));
            String sbbbillno = DeclareServiceHelper.generateSBBNo((String)"tcnfep_kj_declare_main");
            this.getPageCache().put("sbbbillno", sbbbillno);
            this.getModel().setValue(DECLARE_NUMBER, (Object)sbbbillno);
            this.getPageCache().put("businessno", withholdRemit.getString("billno"));
            this.loadData(skssqq, skssqz, false, false);
        }
    }
}

