/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPlugin;
import kd.taxc.tcnfep.formplugin.declare.DraftNumberListener;
import kd.taxc.tcnfep.formplugin.declare.KjqysdsOrgListener;
import org.apache.commons.lang3.StringUtils;

public class TcnfepKjqysdsDeclarePlugin
extends AbstractDeclareReportPlugin
implements BeforeF7SelectListener {
    public static final String TCNFEP_WITHHOLD_REMIT = "tcnfep_withhold_remit";
    public static final String TCNFEP_KJ_DECLARE_MAIN = "tcnfep_kj_declare_main";
    public static final String VIEW_DRAFT_KEY = "bar_viewdraft";
    private static List<IControlListener> controlListeners = new ArrayList<IControlListener>();

    public TcnfepKjqysdsDeclarePlugin() {
        this.setControlListeners(controlListeners);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit draftNumber = (BasedataEdit)this.getControl("draft_number");
        draftNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            DynamicObject draft = (DynamicObject)this.getModel().getValue("draft_number");
            String sbbid = this.getPageCache().get("sbbid");
            DynamicObject sbbObj = YbnsrService.queryYbnsr((String)sbbid);
            if (draft != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)draft.get("id"), (String)TCNFEP_WITHHOLD_REMIT);
                String qysdssbbid = object.getString("qysdssbbid.id");
                if (StringUtils.isNotEmpty((CharSequence)qysdssbbid) && !Objects.equals(qysdssbbid, sbbid)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5e95\u7a3f", (String)"TcnfepKjqysdsDeclarePlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    return;
                }
                if (sbbObj != null && !"A".equals(sbbObj.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u4fdd\u5b58", (String)"TcnfepKjqysdsDeclarePlugin_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
                    return;
                }
            }
        } else if (VIEW_DRAFT_KEY.equals(key)) {
            this.taxSourceHyperLink();
        }
        super.itemClick(evt);
    }

    private void taxSourceHyperLink() {
        DynamicObject draft = (DynamicObject)this.getModel().getValue("draft_number");
        if (draft != null) {
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)TCNFEP_WITHHOLD_REMIT, (Object)draft.get("id"), (IFormView)this.getView(), new HashMap(), (BillOperationStatus)BillOperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("draft_number".equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcnfepKjqysdsDeclarePlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("org", "=", (Object)org.getLong("id")));
        }
    }

    public String getTemplateType() {
        return "kjqysds";
    }

    protected void setRequestModel(DeclareRequestModel requestModel) {
        requestModel.addBusinessValue("taxsourceid", this.getPageCache().get("taxsourceid"));
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("businessno", this.getPageCache().get("businessno"));
        requestModel.setExtendParams(extendParams);
    }

    protected void doInLoadFromHyperLinkClick(DynamicObject nsrxx) {
        String businessno = nsrxx.getString("businessno");
        DynamicObject object = QueryServiceHelper.queryOne((String)TCNFEP_WITHHOLD_REMIT, (String)"id,billno,contract.id as contractid", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)businessno)});
        if (object != null) {
            String taxsourceid = object.getString("id");
            this.getModel().setValue("draft_number", (Object)object.getLong("id"));
            this.getPageCache().put("taxsourceid", taxsourceid);
        }
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        if (!checkResult) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgid));
            this.getPageCache().put("orgid", orgid);
            this.getModel().setValue("draft_number", customParams.get("draftid"));
            this.getPageCache().put("taxsourceid", String.valueOf(customParams.get("draftid")));
            DynamicObject withholdRemit = BusinessDataServiceHelper.loadSingle((Object)customParams.get("draftid"), (String)TCNFEP_WITHHOLD_REMIT);
            Date skssqq = withholdRemit.getDate("skssqq");
            String skssqqstr = DateUtils.format((Date)skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            Date skssqz = withholdRemit.getDate("skssqz");
            String skssqzstr = DateUtils.format((Date)skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            Long sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_KJ_DECLARE_MAIN);
            this.getPageCache().put("sbbid", String.valueOf(sbbid));
            String sbbbillno = DeclareServiceHelper.generateSBBNo((String)TCNFEP_KJ_DECLARE_MAIN);
            this.getPageCache().put("sbbbillno", sbbbillno);
            this.getModel().setValue("declarenumber", (Object)sbbbillno);
            this.getPageCache().put("businessno", withholdRemit.getString("billno"));
            this.openDeclarePage(false);
        }
    }

    public boolean initModelValue(boolean orgChange, String orgId) {
        Date date = new Date();
        Date startDate = DateUtils.getFirstDateOfMonth((Date)date);
        Date endDate = DateUtils.getLastDateOfMonth1((Date)date);
        this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
        this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        return false;
    }

    public void afterPropertyChanged(PropertyChangedArgs args, String changetype) {
        Long sbbid;
        String draftNumber = this.getPageCache().get("businessno");
        QFilter qFilter = new QFilter("billno", "=", (Object)draftNumber);
        DynamicObject object = QueryServiceHelper.queryOne((String)TCNFEP_WITHHOLD_REMIT, (String)"skssqq,skssqz,qysdssbbid.billno as qysdssbbbillno", (QFilter[])new QFilter[]{qFilter});
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        String qysdssbbbillno = object.getString("qysdssbbbillno");
        String operationStatus = "read";
        boolean refresh = false;
        if (StringUtil.isBlank((CharSequence)qysdssbbbillno)) {
            operationStatus = "edit";
            sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_KJ_DECLARE_MAIN);
            qysdssbbbillno = DeclareServiceHelper.generateSBBNo((String)TCNFEP_KJ_DECLARE_MAIN);
            refresh = true;
        } else {
            QFilter q1 = new QFilter("businessno", "=", (Object)draftNumber);
            QFilter q2 = new QFilter("type", "=", (Object)"kjqysds");
            DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billno", (QFilter[])new QFilter[]{q1, q2});
            if (nsrxx != null) {
                sbbid = nsrxx.getLong("id");
                qysdssbbbillno = nsrxx.getString("billno");
            } else {
                operationStatus = "edit";
                sbbid = DeclareServiceHelper.generateSBBId((String)TCNFEP_KJ_DECLARE_MAIN);
                qysdssbbbillno = DeclareServiceHelper.generateSBBNo((String)TCNFEP_KJ_DECLARE_MAIN);
                refresh = true;
            }
        }
        this.getModel().setValue("declarenumber", (Object)qysdssbbbillno);
        this.getPageCache().put("sbbid", String.valueOf(sbbid));
        this.getPageCache().put("sbbbillno", qysdssbbbillno);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
        this.showInnerPage(refresh, operationStatus);
    }

    protected DynamicObject queryNsrxx(String orgId, String templateType, String startdate, String enddate) {
        return YbnsrService.queryYbnsr((String)this.getPageCache().get("sbbid"));
    }

    protected void operationBill(String operationKey) {
        String draftNumber;
        if ("save".equals(operationKey) && EmptyCheckUtils.isNotEmpty((Object)(draftNumber = this.getPageCache().get("businessno")))) {
            QFilter qFilter = new QFilter("billno", "=", (Object)draftNumber);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)TCNFEP_WITHHOLD_REMIT, (String)"id,qysdssbbid", (QFilter[])new QFilter[]{qFilter});
            object.set("qysdssbbid", (Object)Long.parseLong(this.getPageCache().get("sbbid")));
            object.set("qysdsbasetype", (Object)"bdtaxr_nsrxx");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    static {
        controlListeners.add((IControlListener)new KjqysdsOrgListener());
        controlListeners.add(new DraftNumberListener());
    }
}

