/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.draft;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.route.TaxDeclareRouteHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcnfep.business.draft.ExtRecordServiceHelper;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;
import org.apache.commons.lang3.ObjectUtils;

public class WithholdRemitEdit
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    private static final String CONTRACT = "contract";
    private static final String SSYWFL = "ssywfl";
    private static final String TREATYNAME = "treatyname";
    private static final String TREATYAGREEMENT = "treatyagreement";
    private static final String COUNTRY = "country";
    private static final String NEEDPAYZZS = "needpayzzs";
    private static final String RECALC = "recalc";
    private static final String PAYACCOUNTNUMBER = "payaccountnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit contract = (BasedataEdit)this.getControl(CONTRACT);
        contract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ssywfl = (BasedataEdit)this.getControl(SSYWFL);
        ssywfl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit treatyname = (BasedataEdit)this.getControl(TREATYNAME);
        treatyname.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit treatyagreement = (BasedataEdit)this.getControl(TREATYAGREEMENT);
        treatyagreement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit businessNumberTextEdit = (TextEdit)this.getControl(PAYACCOUNTNUMBER);
        businessNumberTextEdit.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Date now = new Date();
        this.getModel().setValue("skssqq", (Object)DateUtils.getFirstDateOfMonth((Date)now));
        this.getModel().setValue("skssqz", (Object)DateUtils.getLastDateOfMonth1((Date)now));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String appId = this.getView().getFormShowParameter().getAppId();
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtil.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String version = TaxDeclareRouteHelper.getDeclareRouteOfApp((String)appId);
            if ("3.0".equals(version)) {
                dataEntity.set("dkdjbasetype", (Object)"tpo_declare_base");
                dataEntity.set("qysdsbasetype", (Object)"tpo_declare_base");
            } else {
                dataEntity.set("dkdjbasetype", (Object)"bdtaxr_nsrxx");
                dataEntity.set("qysdsbasetype", (Object)"bdtaxr_nsrxx");
            }
        }
        if (StringUtil.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            DynamicObject payee = (DynamicObject)this.getModel().getValue("payee");
            DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
            if (contract != null && payee != null && contract.getDynamicObject("peyeename").getLong("id") != payee.getLong("id")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u53f7\u4e0d\u7b26", (String)"WithholdRemitEdit_3", (String)"taxc-tcnfep", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (RECALC.equals(afterDoOperationEventArgs.getOperateKey())) {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(RECALC);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u6570\u636e\uff08\u5305\u62ec\u624b\u5de5\u8c03\u6574\u7684\u6570\u636e\uff09\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u64cd\u4f5c\uff1f", (String)"WithholdRemitEdit_1", (String)"taxc-tcnfep", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (RECALC.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.reSetYnse();
            this.setMustInput();
            this.calcSqfkjermb();
            this.calcYfsjhj();
        }
    }

    public void afterBindData(EventObject e) {
        this.setMustInput();
        this.setSsywflMustInput();
        this.getView().setVisible(Boolean.FALSE, new String[]{"payeeaddress"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("tcnfep_ext_payment_acc_createdraft".equals(customParams.get("source"))) {
            this.getModel().setValue("org", customParams.get("org"));
            this.getModel().setValue(CONTRACT, customParams.get(CONTRACT));
            this.getModel().setValue(PAYACCOUNTNUMBER, customParams.get(PAYACCOUNTNUMBER));
            this.getModel().setValue("payee", customParams.get("payee"));
            this.getModel().setValue("isrelatedparty", customParams.get("isrelatedparty"));
            this.getModel().setValue("skssqq", customParams.get("skssqq"));
            this.getModel().setValue("skssqz", customParams.get("skssqz"));
            this.getModel().setValue("paymentcurrency", customParams.get("paymentcurrency"));
            this.getModel().setValue("payrate", customParams.get("payrate"));
            this.getModel().setValue("sqfkjewb", customParams.get("sqfkjewb"));
            customParams.put("source", "");
        }
    }

    private void setMustInput() {
        String payqysds = (String)this.getModel().getValue("payqysds");
        Boolean needpayqysds = this.convertBoolean(payqysds);
        DecimalEdit jsjc_qysds = (DecimalEdit)this.getControl("jsjc_qysds");
        jsjc_qysds.setMustInput(needpayqysds.booleanValue());
        FieldProp jsjc_qysds_property = (FieldProp)this.getModel().getProperty("jsjc_qysds");
        jsjc_qysds_property.setMustInput(needpayqysds.booleanValue());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if ("sqfkjewb".equals(name)) {
            this.calcSqfkjermb();
            this.reSetYnse();
        } else if ("payrate".equals(name)) {
            this.calcSqfkjermb();
        } else if ("yfse_qysds".equals(name) || "yfse_zzs".equals(name)) {
            this.calcYfsjhj();
            this.calcsjfkjermb();
        } else if ("sqfkjermb".equals(name)) {
            this.calcsjfkjermb();
            this.reSetYnse();
            this.setMustInput();
        } else if ("sfxsssxdyh".equals(name) || "hdlrl_qysds".equals(name) || "discountrate_qysds".equals(name) || "rate_zzs".equals(name) || "rate_qysds".equals(name) || "payqysds".equals(name)) {
            this.reSetYnse();
            this.setMustInput();
        } else if (CONTRACT.equals(name)) {
            this.getModel().setValue(PAYACCOUNTNUMBER, null);
            this.getModel().setValue("sqfkjewb", null);
            this.getModel().setValue("payrate", null);
            this.getModel().setValue("sbsrwb", null);
            this.getModel().setValue("yfsjhj", null);
            this.getModel().setValue("sjfkjermb", null);
            this.getModel().setValue("remark", null);
            DynamicObject contract = (DynamicObject)changeData[0].getNewValue();
            if (contract != null) {
                this.getModel().setValue("payee", contract.get("peyeename"));
            }
            this.reSetYnse();
            this.setMustInput();
        } else if ("jsjctz_qysds".equals(name)) {
            this.reSetYnse();
        } else if (PAYACCOUNTNUMBER.equals(name)) {
            String payaccountnumber = (String)this.getModel().getValue(PAYACCOUNTNUMBER);
            DynamicObject account = ExtRecordServiceHelper.getAccount(payaccountnumber);
            if (ObjectUtils.isNotEmpty((Object)account)) {
                this.getModel().setValue("sqfkjewb", (Object)account.getBigDecimal("currentpaymentamount"));
                DynamicObject paymentcurrency = account.getDynamicObject("paymentcurrency");
                this.getModel().setValue("paymentcurrency", (Object)paymentcurrency.getLong("id"));
                BigDecimal payrate = "CNY".equals(paymentcurrency.getString("number")) ? BigDecimal.ONE : null;
                this.getModel().setValue("payrate", (Object)payrate);
            } else {
                this.getModel().setValue("sqfkjewb", null);
                this.getModel().setValue("paymentcurrency", null);
                this.getModel().setValue("payrate", null);
            }
        }
        if ("payee".equals(name) || "skssqq".equals(name) || "skssqz".equals(name) || "sfxsssxdyh".equals(name) && ((Boolean)changeData[0].getNewValue()).booleanValue()) {
            if (this.getModel().getValue("payee") == null) {
                this.getModel().setValue(TREATYNAME, null);
                this.getModel().setValue(TREATYAGREEMENT, null);
                this.getModel().setValue(COUNTRY, null);
                return;
            }
            DynamicObject payee = (DynamicObject)this.getModel().getValue("payee");
            if (payee != null) {
                this.getModel().setValue(COUNTRY, payee.get("country.id"));
            }
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            List<DynamicObject> collect = WithholdRemitHelper.findFitTreaty((DynamicObject)this.getModel().getValue("payee"), (Date)this.getModel().getValue("skssqq"), skssqz == null ? null : DateUtils.getDayFirst((Date)skssqz));
            if (collect.size() == 1) {
                this.getModel().setValue(TREATYNAME, collect.get(0).get(TREATYNAME));
                this.getModel().setValue(TREATYAGREEMENT, collect.get(0).get(TREATYAGREEMENT));
            } else {
                this.getModel().setValue(TREATYNAME, null);
                this.getModel().setValue(TREATYAGREEMENT, null);
            }
        } else if (TREATYNAME.equals(name) || TREATYAGREEMENT.equals(name)) {
            DynamicObject first;
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            List<DynamicObject> collect = WithholdRemitHelper.findFitTreaty((DynamicObject)this.getModel().getValue("payee"), (Date)this.getModel().getValue("skssqq"), skssqz == null ? null : DateUtils.getDayFirst((Date)skssqz));
            if (changeData[0].getNewValue() != null && TREATYNAME.equals(name)) {
                first = collect.stream().filter(s -> s.get("treatyname.id").equals(((DynamicObject)changeData[0].getNewValue()).get("id"))).findFirst().orElse(null);
                if (first != null) {
                    this.getModel().setValue(TREATYAGREEMENT, first.get(TREATYAGREEMENT));
                }
            } else if (changeData[0].getNewValue() != null && (first = (DynamicObject)collect.stream().filter(s -> s.get("treatyagreement.id").equals(((DynamicObject)changeData[0].getNewValue()).get("id"))).findFirst().orElse(null)) != null) {
                this.getModel().setValue(TREATYNAME, first.get(TREATYNAME));
            }
        } else if (NEEDPAYZZS.equals(name)) {
            this.setSsywflMustInput();
        }
    }

    private void calcsjfkjermb() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
        BigDecimal sjfkjermb = (BigDecimal)this.getModel().getValue("sqfkjermb");
        if (contract != null) {
            String swzzcdqysds;
            String swzzcdzzs = contract.getString("swzzcdzzs");
            if ("0".equals(swzzcdzzs)) {
                BigDecimal yfse_zzs = (BigDecimal)this.getModel().getValue("yfse_zzs");
                sjfkjermb = BigDecimalUtil.subtractObject((Object)sjfkjermb, (Object)yfse_zzs);
            }
            if ("0".equals(swzzcdqysds = contract.getString("swzzcdqysds"))) {
                BigDecimal yfse_qysds = (BigDecimal)this.getModel().getValue("yfse_qysds");
                sjfkjermb = BigDecimalUtil.subtractObject((Object)sjfkjermb, (Object)yfse_qysds);
            }
        }
        this.getModel().setValue("sjfkjermb", (Object)sjfkjermb);
    }

    private boolean isYqkjAndGxhlsd() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String contracttype = dataEntity.getString("contracttype");
        String incomeitems = dataEntity.getString("contract.incomeitems.value");
        return "yqkj".equals(contracttype) && this.getGxhlsd().equals(incomeitems);
    }

    private String getGxhlsd() {
        return ResManager.loadKDString((String)"\u80a1\u606f\u7ea2\u5229\u6240\u5f97", (String)"WithholdRemitEdit_6", (String)"taxc-tcnfep", (Object[])new Object[0]);
    }

    private void calcYfsjhj() {
        BigDecimal amount = BigDecimalUtil.addObject((Object)this.getModel().getValue("yfse_qysds"), (Object)this.getModel().getValue("yfse_zzs"));
        this.getModel().setValue("yfsjhj", (Object)amount);
    }

    private void calcSqfkjermb() {
        BigDecimal amount = BigDecimalUtil.multiplyObject((Object)this.getModel().getValue("sqfkjewb"), (Object)this.getModel().getValue("payrate"), (int)2, (int)4);
        this.getModel().setValue("sqfkjermb", (Object)amount);
    }

    private void reSetYnse() {
        DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (contract != null) {
            Boolean sfxsssxdyh = (Boolean)this.getModel().getValue("sfxsssxdyh");
            String payqysds = (String)this.getModel().getValue("payqysds");
            String swzzcdzzs = contract.getString("swzzcdzzs");
            String swzzcdqysds = contract.getString("swzzcdqysds");
            Boolean needpayqysds = this.convertBoolean(payqysds);
            Boolean sfswzzcdzzs = this.convertBoolean(swzzcdzzs);
            Boolean sfswzzcdqysds = this.convertBoolean(swzzcdqysds);
            BigDecimal hdlrl_qysds = dataEntity.getBigDecimal("hdlrl_qysds");
            BigDecimal jsjc_zzs = dataEntity.getBigDecimal("jsjc_zzs");
            BigDecimal jsjc_qysds = dataEntity.getBigDecimal("jsjctz_qysds");
            BigDecimal rate_zzs = dataEntity.getBigDecimal("rate_zzs");
            BigDecimal rate_qysds = dataEntity.getBigDecimal("rate_qysds");
            BigDecimal discountrate_qysds = dataEntity.getBigDecimal("discountrate_qysds");
            this.getModel().setValue("formula_zzs", (Object)WithholdRemitHelper.getExpression("zzs", sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, hdlrl_qysds, discountrate_qysds));
            BigDecimal formulaValue = WithholdRemitHelper.calclateZss(sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, jsjc_zzs, rate_zzs, rate_qysds, hdlrl_qysds, discountrate_qysds);
            if (formulaValue != null) {
                this.getModel().setValue("jsyj_zzs", (Object)formulaValue);
                this.getModel().setValue("yfse_zzs", (Object)formulaValue.multiply(rate_zzs));
            }
            boolean yqkjAndGxhlsd = this.isYqkjAndGxhlsd();
            BigDecimal sqfkjewb = dataEntity.getBigDecimal("sqfkjewb");
            if (yqkjAndGxhlsd) {
                this.getModel().setValue("formula_qysds", (Object)"jsjc*qysdsl");
                this.getModel().setValue("yfse_qysds", (Object)BigDecimalUtil.multiplyObject((Object)jsjc_qysds, (Object)rate_qysds, (int)2));
                this.getModel().setValue("sbsrwb", (Object)sqfkjewb);
            } else {
                this.getModel().setValue("formula_qysds", (Object)WithholdRemitHelper.getExpression("qysds", sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, hdlrl_qysds, discountrate_qysds));
                this.getModel().setValue("yfse_qysds", (Object)WithholdRemitHelper.calclateQysds(sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, jsjc_qysds, rate_zzs, rate_qysds, hdlrl_qysds, discountrate_qysds));
                this.getModel().setValue("sbsrwb", (Object)WithholdRemitHelper.calclateSbsr(sfxsssxdyh, needpayqysds, sfswzzcdzzs, sfswzzcdqysds, sqfkjewb, rate_zzs, rate_qysds, hdlrl_qysds, discountrate_qysds));
            }
        }
    }

    private Boolean convertBoolean(String value) {
        if ("0".equals(value)) {
            return Boolean.FALSE;
        }
        if ("1".equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (CONTRACT.equals(name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5207\u6362\u540e\uff0c\u5c06\u6e05\u9664\u201c\u652f\u4ed8\u4fe1\u606f\u201d\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\u5207\u6362\u3002", (String)"WithholdRemitEdit_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("org", "=", (Object)org.getLong("id")));
                if (this.getModel().getValue("payee") != null) {
                    beforeF7SelectEvent.addCustomQFilter(new QFilter("peyeename", "=", (Object)((DynamicObject)this.getModel().getValue("payee")).getLong("id")));
                }
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"WithholdRemitEdit_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
            }
        } else if (SSYWFL.equals(name)) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("number", "not like", (Object)"1%"));
        } else if (TREATYNAME.equals(name)) {
            List<DynamicObject> collect = WithholdRemitHelper.findFitTreaty((DynamicObject)this.getModel().getValue("payee"), (Date)this.getModel().getValue("skssqq"), skssqz == null ? null : DateUtils.getDayFirst((Date)skssqz));
            List idList = collect.stream().map(a -> a.getLong("treatyname.id")).collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", idList));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("source", (Object)"WithholdRemit");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u6536\u534f\u5b9a\u540d\u79f0", (String)"WithholdRemitEdit_4", (String)"taxc-tcnfep", (Object[])new Object[0]));
        } else if (TREATYAGREEMENT.equals(name)) {
            List<DynamicObject> collect = WithholdRemitHelper.findFitTreaty((DynamicObject)this.getModel().getValue("payee"), (Date)this.getModel().getValue("skssqq"), skssqz == null ? null : DateUtils.getDayFirst((Date)skssqz));
            List idList = collect.stream().map(a -> a.getLong("treatyagreement.id")).collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", idList));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("source", (Object)"WithholdRemit");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u6536\u534f\u5b9a\u6761\u6b3e", (String)"WithholdRemitEdit_5", (String)"taxc-tcnfep", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)PAYACCOUNTNUMBER)) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue(CONTRACT);
            if (Objects.isNull(contract)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5408\u540c\u7f16\u53f7\u201d\u3002", (String)"WithholdRemitEdit_7", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            String billno = (String)this.getModel().getValue("billno");
            QFilter q1 = new QFilter("contractname", "=", (Object)contract.getLong("id"));
            QFilter q2 = new QFilter("draftnumber", "=", (Object)"").or("draftnumber", "=", (Object)" ").or("draftnumber", "is null", (Object)"").or("draftnumber", "=", (Object)billno);
            ListShowParameter listShowParameter = ExtRecordServiceHelper.getPayaccountListShowParameter(Arrays.asList(q1, q2));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PAYACCOUNTNUMBER);
            listShowParameter.setCloseCallBack(closeCallBack);
            listShowParameter.setCustomParam("ShowFilter", Arrays.asList("org.name", "billno", "paydate", "contractname.contractname", "contractname.incomeitems.value", "billstatus"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)PAYACCOUNTNUMBER) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            this.getModel().setValue(PAYACCOUNTNUMBER, (Object)listDatas.get(0).getBillNo());
        }
    }

    private void setSsywflMustInput() {
        BasedataEdit ssywfl = (BasedataEdit)this.getControl(SSYWFL);
        if ("0".equals(this.getModel().getValue(NEEDPAYZZS))) {
            ssywfl.setMustInput(false);
        } else {
            ssywfl.setMustInput(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dyo = this.getModel().getDataEntity();
        DynamicProperty textProp = dyo.getDynamicObjectType().getProperty("needpayqysds");
        dyo.getDataEntityState().setBizChanged(textProp.getOrdinal(), false);
    }
}

