/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.draft;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclarePageOpenHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.taxdeclare.enums.TaxDeclareMetaRouteEnum;
import kd.taxc.bdtaxr.common.taxdeclare.route.TaxDeclareRouteHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import org.apache.commons.collections.CollectionUtils;

public class WithholdRemitList
extends AbstractListPlugin {
    public void packageData(PackageDataEvent e) {
        DynamicObject object;
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String dkdjbasetype = data.getString("dkdjbasetype");
        String qysdsbasetype = data.getString("qysdsbasetype");
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        }
        if ("dkdjsbbid.declarestatus".equals(columnDesc.getKey())) {
            if (data.getDynamicObject("dkdjsbbid") == null) {
                return;
            }
            object = BusinessDataServiceHelper.loadSingle((Object)data.getDynamicObject("dkdjsbbid").getLong("id"), (String)dkdjbasetype);
            e.setFormatValue((Object)this.getDeclarestatusName(object, object.getString("declarestatus")));
        }
        if ("qysdssbbid.declarestatus".equals(columnDesc.getKey())) {
            if (data.getDynamicObject("qysdssbbid") == null) {
                return;
            }
            object = BusinessDataServiceHelper.loadSingle((Object)data.getDynamicObject("qysdssbbid").getLong("id"), (String)qysdsbasetype);
            e.setFormatValue((Object)this.getDeclarestatusName(object, object.getString("declarestatus")));
        }
    }

    private String getDeclarestatusName(DynamicObject object, String status) {
        IDataEntityProperty declarestatus = (IDataEntityProperty)object.getDataEntityType().getProperties().get((Object)"declarestatus");
        List comboItems = ((BillStatusProp)declarestatus).getComboItems();
        return comboItems.stream().filter(s -> s.getValue().equals(status)).map(s -> s.getName().getLocaleValue()).findFirst().orElseGet(() -> "");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key = evt.getOperateKey();
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (("dkdjbg".equals(key) || "kjqysds".equals(key)) && (CollectionUtils.isEmpty((Collection)list) || list.size() > 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5e95\u7a3f\u6570\u636e", (String)"WithholdRemitList_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
            return;
        }
        if ("dkdjbg".equals(key)) {
            DynamicObject withholdRemit = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcnfep_withhold_remit"));
            if (withholdRemit.get("dkdjsbbid") != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4ee3\u6263\u4ee3\u7f34\u62a5\u544a\u8868", (String)"WithholdRemitList_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            if (!"C".equals(withholdRemit.getString("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u5e95\u7a3f\u4e0d\u80fd\u751f\u6210\u4ee3\u6263\u4ee3\u7f34\u62a5\u544a\u8868", (String)"WithholdRemitList_4", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            if (withholdRemit.getString("needpayzzs").equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9700\u7f34\u7eb3\u589e\u503c\u7a0e\uff0c\u4e0d\u652f\u6301\u751f\u6210\u4ee3\u6263\u4ee3\u7f34\u62a5\u544a\u3002", (String)"WithholdRemitList_6", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            String currentShowMeta = TaxDeclareRouteHelper.getCurrentShowMeta((String)TaxDeclareMetaRouteEnum.tcnfep_dkdj.getName());
            this.toSbpage(withholdRemit, currentShowMeta);
        } else if ("kjqysds".equals(key)) {
            DynamicObject withholdRemit = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcnfep_withhold_remit"));
            if (withholdRemit.get("qysdssbbid") != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u62a5\u544a\u8868", (String)"WithholdRemitList_2", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            if (!"C".equals(withholdRemit.getString("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u5e95\u7a3f\u4e0d\u80fd\u751f\u6210\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u62a5\u544a\u8868", (String)"WithholdRemitList_5", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            String currentShowMeta = TaxDeclareRouteHelper.getCurrentShowMeta((String)TaxDeclareMetaRouteEnum.tcnfep_kj.getName());
            this.toSbpage(withholdRemit, currentShowMeta);
        }
    }

    private void toSbpage(DynamicObject withholdRemit, String sbpage) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("draftid", withholdRemit.getPkValue());
        param.put("orgid", withholdRemit.getString("org.id"));
        param.put("createsbb", true);
        param.put("skssqq", DateUtils.format((Date)withholdRemit.getDate("skssqq")));
        param.put("skssqz", DateUtils.format((Date)withholdRemit.getDate("skssqz")));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        PageShowCommon.showForm((OperationStatus)formShowParameter.getStatus(), (ShowType)ShowType.MainNewTabPage, (String)sbpage, (IFormView)this.getView(), param, (IFormPlugin)this);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long sbbid;
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject objectDraft = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcnfep_withhold_remit");
        String fieldName = args.getFieldName();
        String dkdjbasetype = null;
        String qysdsbasetype = null;
        if ("dkdjsbbid_billno".equals(fieldName)) {
            sbbid = objectDraft.getLong("dkdjsbbid.id");
            dkdjbasetype = objectDraft.getString("dkdjbasetype");
        } else if ("qysdssbbid_billno".equals(fieldName)) {
            sbbid = objectDraft.getLong("qysdssbbid.id");
            qysdsbasetype = objectDraft.getString("qysdsbasetype");
        } else {
            return;
        }
        args.setCancel(true);
        DynamicObject object = null;
        String type = null;
        HashMap<String, Object> customParams = new HashMap(30);
        try {
            if ("tpo_declare_base".equals(dkdjbasetype) || "tpo_declare_base".equals(qysdsbasetype)) {
                object = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tpo_declare_main_tsc");
                type = object.getDynamicObject("templatetype").getString("number");
                customParams = DeclareCustomParamsHelper.buildCustomParams((DynamicObject)object);
            }
            if ("bdtaxr_nsrxx".equals(dkdjbasetype) || "bdtaxr_nsrxx".equals(qysdsbasetype)) {
                object = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
                type = object.getString("type");
                customParams = DeclareCustomParamsHelper.buildCustomParams((DynamicObject)object);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u5b58\u5728", (String)"WithholdRemitList_3", (String)"taxc-tcnfep", (Object[])new Object[0]));
            return;
        }
        if (object == null) {
            return;
        }
        if ("tpo_declare_base".equals(dkdjbasetype) || "tpo_declare_base".equals(qysdsbasetype)) {
            String declarestatus = object.getString("declarestatus");
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus, dkdjbasetype, qysdsbasetype);
        } else {
            DeclarePageOpenHelper.linkDeclarePageByPkId((IFormView)this.getView(), (Object)sbbid);
        }
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, String dkdjbasetype, String qysdsbasetype) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            String formId = TemplateEnum.DKDJ == templateEnum && "tpo_declare_base".equals(dkdjbasetype) || TemplateEnum.KJQYSDS == templateEnum && "tpo_declare_base".equals(qysdsbasetype) ? "multi_declare_show" : templateEnum.getDeclareShowPage();
            param.setFormId(formId);
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        } else {
            String declarePage = templateEnum.getDeclarePage();
            TaxDeclareMetaRouteEnum metaRouteEnum = TaxDeclareMetaRouteEnum.getEnumByDeclarePage((String)declarePage);
            if (metaRouteEnum == null) {
                param.setFormId(declarePage);
            } else {
                param.setFormId(TaxDeclareRouteHelper.getCurrentShowMeta((String)metaRouteEnum.getName()));
            }
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

