/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.formplugin.record;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcnfep.business.draft.ExtRecordServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class ExtRecordFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        TextEdit businessNumberTextEdit = (TextEdit)this.getControl("accnumber");
        businessNumberTextEdit.addClickListener((ClickListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl("contract");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.getModel().getValue("org") == null) {
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
            Long orgId = OrgCheckUtil.setDefaultOrg(null, (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
            this.getModel().setValue("org", (Object)orgId);
        }
        if (customParams.get("source") != null && customParams.get("source").equals("paymentaccount")) {
            this.getModel().setValue("org", customParams.get("orgid"));
            DynamicObject acc = ExtRecordServiceHelper.queryAccount(customParams.get("id"));
            if (acc != null) {
                DynamicObject contract = (DynamicObject)acc.get("contractname");
                this.getModel().setValue("contract", (Object)acc.getLong("contractname.id"));
                this.getModel().setValue("accnumber", acc.get("billno"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"contract"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"accnumber"});
                this.setContractValue(contract);
                this.setAccountValue(acc);
            }
        }
        if ((org = (DynamicObject)this.getModel().getValue("org")) != null) {
            String appid = this.getView().getFormShowParameter().getAppId();
            TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
            String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)org.get("id").toString(), (String)appid, (String)categoryType);
            if (checkResult) {
                this.getModel().setValue("org", null);
                return;
            }
            DynamicObject result = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id")).getData();
            if (result != null) {
                DynamicObject taxorg = result.getDynamicObject("taxorg");
                this.getModel().setValue("unifiedsocialcode", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg));
                DynamicObjectCollection bankentity = result.getDynamicObjectCollection("entryentity");
                if (bankentity.size() > 0) {
                    this.getModel().setValue("bankname", (Object)((DynamicObject)bankentity.get(0)).getString("bankname"));
                    this.getModel().setValue("bankacct", (Object)((DynamicObject)bankentity.get(0)).getString("bankacct"));
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("source") != null && customParams.get("source").equals("paymentaccount")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String accnumber;
        DynamicObject acc;
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        if (e.getProperty().getName().equals("contract")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract != null) {
                this.setContractValue(contract);
            }
            this.getModel().setValue("accnumber", null);
            this.getModel().setValue("collectionbank", null);
            this.getModel().setValue("collectionaccount", null);
            this.getModel().setValue("currentpaymentamount", null);
            this.getModel().setValue("paymentcurrency", null);
            this.getModel().setValue("paydate", null);
        }
        if (e.getProperty().getName().equals("accnumber") && (acc = ExtRecordServiceHelper.getAccount(accnumber = (String)this.getModel().getValue("accnumber"))) != null) {
            this.setAccountValue(acc);
        }
    }

    private void setContractValue(DynamicObject contract) {
        if (contract != null) {
            this.getModel().setValue("correlation", (Object)contract.getString("relatetrader"));
            this.getModel().setValue("contractnumber", (Object)contract.getString("billno"));
            this.getModel().setValue("qdhtrq", contract.get("qdhtrq"));
            this.getModel().setValue("htzxqsrq", contract.get("htzxqsrq"));
            this.getModel().setValue("htzxzzrq", contract.get("htzxzzrq"));
            this.getModel().setValue("contractcurrency", contract.get("contractcurrency"));
            this.getModel().setValue("contractamount", contract.get("contractamount"));
            this.getModel().setValue("contractamount", contract.get("contractamount"));
            this.getModel().setValue("payeename", contract.get("peyeename.name"));
        }
    }

    private void setAccountValue(DynamicObject acc) {
        if (acc != null) {
            this.getModel().setValue("collectionbank", (Object)acc.getString("collectionbank"));
            this.getModel().setValue("collectionaccount", (Object)acc.getString("collectionaccount"));
            this.getModel().setValue("currentpaymentamount", acc.get("sjfkjeyb"));
            this.getModel().setValue("paymentcurrency", acc.get("paymentcurrency"));
            this.getModel().setValue("paydate", acc.get("paydate"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"accnumber")) {
            Object org = this.getModel().getValue("org");
            if (Objects.isNull(org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"PaymentAccountPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
            if (contract == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\uff01\u8bf7\u5148\u9009\u62e9\u5408\u540c\u540d\u79f0", (String)"ExtRecordFormPlugin_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                return;
            }
            QFilter recordnumberFilter = new QFilter("recordnumber", "=", (Object)" ").or(new QFilter("recordnumber", "=", (Object)"")).or(new QFilter("recordnumber", "=", null));
            QFilter contractFilter = new QFilter("contractname.contractname", "=", (Object)contract.getString("contractname"));
            QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)org).get("id"));
            QFilter usdCurrentPaymentAmountFilter = new QFilter("usdcurrentpaymentamount", ">", (Object)BigDecimal.valueOf(50000L));
            ListShowParameter listShowParameter = ExtRecordServiceHelper.getPayaccountListShowParameter(Arrays.asList(recordnumberFilter, contractFilter, orgFilter, usdCurrentPaymentAmountFilter));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "accnumber");
            listShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject contract;
        FormOperate operate = (FormOperate)args.getSource();
        if (("save".equals(operate.getOperateKey()) || "submit".equals(operate.getOperateKey())) && (contract = (DynamicObject)this.getModel().getValue("contract")) != null && StringUtil.isNotBlank((CharSequence)contract.getString("recordnumber"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5408\u540c\u5df2\u5b58\u5728\u5bf9\u5916\u652f\u4ed8\u5907\u6848\u53f7\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u652f\u4ed8\u5907\u6848\u53f0\u8d26\u3002", (String)"ExtRecordFormPlugin_0", (String)"taxc-tcnfep", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"accnumber") && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            this.getModel().setValue("accnumber", (Object)listDatas.get(0).getBillNo());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("contract".equals(name)) {
            Object org = this.getModel().getValue("org");
            if (Objects.isNull(org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"PaymentAccountPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)org).get("id"));
            QFilter recordnumberFilter = new QFilter("recordnumber", "=", (Object)" ").or(new QFilter("recordnumber", "=", (Object)"")).or(new QFilter("recordnumber", "=", null));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
            formShowParameter.getListFilterParameter().getQFilters().add(recordnumberFilter);
        }
    }
}

