/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.opplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcnfep.business.draft.ExtRecordServiceHelper;

public class PaymentAccountImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        List<String> taxrecordnumberList = billdatas.stream().filter(a -> a.getData() != null && StringUtils.isNotBlank((CharSequence)a.getData().getString("taxrecordnumber"))).map(a -> a.getData().getString("taxrecordnumber")).collect(Collectors.toList());
        Map<String, String> existTaxrecordnumberMap = ExtRecordServiceHelper.getTaxRecordNumbers(taxrecordnumberList);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData data = iterator.next();
            Integer index = data.getStartIndex();
            JSONObject contract = data.getData().getJSONObject("contractname");
            String billno = contract.getString("billno");
            String taxrecordnumber = data.getData().getString("taxrecordnumber");
            boolean exsit = this.exsitContract(billno);
            if (!exsit) {
                logger.log(index, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u5408\u540c\u7f16\u7801\u4e3a\uff1a%s \u7684\u5408\u540c\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01", (String)"PaymentAccountImportOp_0", (String)"taxc-tcnfep", (Object[])new Object[0]), billno)).fail();
                iterator.remove();
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)taxrecordnumber) || existTaxrecordnumberMap.get(billno) != null && (existTaxrecordnumberMap.get(billno) == null || existTaxrecordnumberMap.get(billno).equals(taxrecordnumber))) continue;
            logger.log(index, String.format(ResManager.loadKDString((String)"\u201c\u652f\u4ed8\u5907\u6848\u8868\u7f16\u53f7\uff08\u7a0e\u5c40\uff09\u201d\u672a\u5728\u3010\u5bf9\u5916\u652f\u4ed8\u7a0e\u52a1\u5907\u6848\u8868\u3011\u4e2d\u627e\u5230\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u4e2d\u662f\u5426\u5df2\u4fdd\u5b58\u300a\u5bf9\u5916\u652f\u4ed8\u7a0e\u52a1\u5907\u6848\u8868\u300b\u3002", (String)"PaymentAccountImportOp_1", (String)"taxc-tcnfep", (Object[])new Object[0]), billno)).fail();
            iterator.remove();
        }
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        rowdatas.forEach(e -> {
            String dollarexchangerateStr;
            e.getData().put("datasource", (Object)"1");
            e.getData().put("billstatus", (Object)"C");
            e.getData().put("auditor_id", (Object)RequestContext.get().getCurrUserId());
            e.getData().put("auditdate", (Object)new Date());
            String currentpaymentamountStr = e.getData().getString("currentpaymentamount");
            String string = dollarexchangerateStr = e.getData().getString("dollarexchangerate") == null ? "0" : e.getData().getString("dollarexchangerate");
            if (currentpaymentamountStr.matches("[-+]?\\d+(?:\\.\\d+)?") && dollarexchangerateStr.matches("[-+]?\\d+(?:\\.\\d+)?")) {
                BigDecimal currentpaymentamount = e.getData().getBigDecimal("currentpaymentamount");
                BigDecimal dollarexchangerate = e.getData().getBigDecimal("dollarexchangerate");
                dollarexchangerate = dollarexchangerate == null ? BigDecimal.ZERO : dollarexchangerate;
                e.getData().put("usdcurrentpaymentamount", (Object)currentpaymentamount.multiply(dollarexchangerate).setScale(2, 4));
                e.getData().put("dollarexchangerate", (Object)dollarexchangerateStr);
            }
        });
        return super.save(rowdatas, logger);
    }

    private boolean exsitContract(String billno) {
        return QueryServiceHelper.exists((String)"tcnfep_contract_info", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno).and("billstatus", "=", (Object)"C")});
    }
}

