/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.opplugin.draft;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcnfep.business.draft.ExtRecordServiceHelper;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;
import kd.taxc.tcnfep.opplugin.draft.WithholdRemitValidator;
import org.apache.commons.lang3.ObjectUtils;

public class WithholdRemitSaveOp
extends AbstractOperationServicePlugIn {
    private static final List<String> fields = Arrays.asList("org", "contract", "payee", "skssqq", "skssqz", "payaccountnumber", "treatyname", "treatyagreement", "yfsjhj", "yfse_qysds", "yfse_zzs");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(fields);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WithholdRemitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject data : e.getDataEntities()) {
            String payaccountnumber = data.getString("payaccountnumber");
            String billno = data.getString("billno");
            DynamicObject dynamicObject = WithholdRemitHelper.queryDraftByBillno(billno);
            if (!ObjectUtils.isEmpty((Object)dynamicObject) && payaccountnumber.equals(dynamicObject.getString("payaccountnumber"))) continue;
            this.updateAccountDraftnumber(data);
        }
    }

    public void updateAccountDraftnumber(DynamicObject data) {
        DynamicObject dynamicObject;
        String billno = data.getString("billno");
        ExtRecordServiceHelper.clearPayaccountDraftnumber(Collections.singletonList(billno));
        String payaccountnumber = data.getString("payaccountnumber");
        if (StringUtil.isNotBlank((CharSequence)payaccountnumber) && ObjectUtils.isNotEmpty((Object)(dynamicObject = ExtRecordServiceHelper.getAccount(payaccountnumber)))) {
            dynamicObject.set("draftnumber", (Object)billno);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }
}

