/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.opplugin.draft;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;

public class WithholdRemitValidator
extends AbstractValidator {
    private static final BigDecimal CALIBRATION_VALUE = new BigDecimal(5);

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            BigDecimal yfse_zzs;
            BigDecimal yfse_qysds;
            BigDecimal total;
            DynamicObject dynamicObject = entity.getDataEntity();
            DynamicObject org = dynamicObject.getDynamicObject("org");
            if (org != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WithholdRemitValidator_4", (String)"taxc-tcnfep", (Object[])new Object[0]));
                continue;
            }
            BigDecimal yfsjhj = (BigDecimal)entity.getValue("yfsjhj");
            if (BigDecimalUtil.subtractObject((Object)yfsjhj, (Object)(total = BigDecimalUtil.addObject((Object)(yfse_qysds = (BigDecimal)entity.getValue("yfse_qysds")), (Object)(yfse_zzs = (BigDecimal)entity.getValue("yfse_zzs"))))).abs().compareTo(CALIBRATION_VALUE) > 0) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u3010\u7a0e\u91d1\u5408\u8ba1\u3011\u4fee\u6539\u540e\u503c\u4e0d\u5f97\u7684\u8d85\u8fc7\u539f\u503c\u7684\u6b63\u8d1f5", (String)"WithholdRemitValidator_1", (String)"taxc-tcnfep", (Object[])new Object[0]));
                continue;
            }
            DynamicObject contract = dynamicObject.getDynamicObject("contract");
            DynamicObject payee = dynamicObject.getDynamicObject("payee");
            if (contract != null && payee != null && contract.getDynamicObject("peyeename").getLong("id") != payee.getLong("id")) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u53f7\u4e0d\u7b26", (String)"WithholdRemitValidator_3", (String)"taxc-tcnfep", (Object[])new Object[0]));
            }
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            DynamicObject treatyname = dynamicObject.getDynamicObject("treatyname");
            DynamicObject treatyagreement = dynamicObject.getDynamicObject("treatyagreement");
            List<DynamicObject> collect = WithholdRemitHelper.findFitTreaty(payee, skssqq, skssqz == null ? null : DateUtils.getDayFirst((Date)skssqz));
            if (payee == null || (treatyname == null || collect.stream().anyMatch(a -> treatyname.getLong("id") == a.getLong("treatyname.id"))) && (treatyagreement == null || collect.stream().anyMatch(a -> treatyagreement.getLong("id") == a.getLong("treatyagreement.id")))) continue;
            this.addFatalErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546%s\u5728\u672c\u671f\u95f4\u5185\u4e0d\u4eab\u53d7\u6b64\u7a0e\u6536\u534f\u5b9a\uff0c\u8bf7\u5728[\u57fa\u7840\u8bbe\u7f6e]\u2192[\u4f9b\u5e94\u5546]\u91cc\u518d\u6b21\u786e\u8ba4\u3002", (String)"WithholdRemitValidator_5", (String)"taxc-tcnfep", (Object[])new Object[0]), payee.getString("name")));
        }
    }
}

