/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.opplugin.record;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tcnfep.business.draft.ExtRecordServiceHelper;

public class ExtRecordSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("billno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("submit".equalsIgnoreCase(operateKey)) {
                    List<Long> contractIds = Arrays.stream(this.dataEntities).map(a -> a.getDataEntity().getLong("contract.id")).collect(Collectors.toList());
                    Map<Long, String> contractMap = ExtRecordServiceHelper.getMapByContractId(contractIds);
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject data = dataEntity.getDataEntity();
                        if (data == null) continue;
                        if (contractMap.get(data.getLong("contract.id")) != null && !contractMap.get(data.getLong("contract.id")).equals(data.getString("billno"))) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e00\u4efd\u5408\u540c\u4ec5\u652f\u6301\u63d0\u4ea4\u4e00\u4efd\u5bf9\u5916\u652f\u4ed8\u5907\u6848\uff0c\u6b64\u5408\u540c\u5df2\u751f\u6210\u5bf9\u5916\u652f\u4ed8\u5907\u6848%s,\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"ExtRecordSubmitOp_0", (String)"taxc-tcnfep", (Object[])new Object[0]), contractMap.get(data.getLong("contract.id"))));
                            continue;
                        }
                        contractMap.put(data.getLong("contract.id"), data.getString("billno"));
                    }
                }
            }
        });
    }
}

