/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PaymentAccountDataUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PaymentAccountDataUpgradeService.class);
    private static final String SQL_SELECT_PAYMENTACCOUNT = "select a.fid,b.fneedpayzzs,b.fswzzcdzzs,b.fpayqysds,b.fswzzcdqysds from t_tcnfep_ext_payment_acc a inner join t_tcnfep_contract_info b on a.fcontractname=b.fid where (a.fneedpayzzs = ' ' or a.fneedpayzzs = '' or a.fneedpayzzs is null) or (a.fswzzcdzzs = ' ' or a.fswzzcdzzs = '' or a.fswzzcdzzs is null)or (a.fpayqysds = ' ' or a.fpayqysds = '' or a.fpayqysds is null) or (a.fswzzcdqysds = ' ' or a.fswzzcdqysds = '' or a.fswzzcdqysds is null)";
    private static final String SQL_UPDATE = "update t_tcnfep_ext_payment_acc set fneedpayzzs = ?,fswzzcdzzs = ?,fpayqysds = ?,fswzzcdqysds = ? where fid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_ext_payment_acc") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_contract_info")) {
            DataSet rows = DB.queryDataSet((String)"PaymentAccountDataUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)SQL_SELECT_PAYMENTACCOUNT);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            while (rows.hasNext()) {
                Row row = rows.next();
                Long id = row.getLong("FID");
                String needpayzzs = row.getString("FNEEDPAYZZS");
                String swzzcdzzs = row.getString("FSWZZCDZZS");
                String payqysds = row.getString("FPAYQYSDS");
                String swzzcdqysds = row.getString("FSWZZCDQYSDS");
                Object[] param = new Object[]{needpayzzs, swzzcdzzs, payqysds, swzzcdqysds, id};
                paramList.add(param);
            }
            rows.close();
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

