/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PaymentAccountDatePayreasonUpagradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PaymentAccountDatePayreasonUpagradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        String sql = "select a.fid fid,a.fcreatetime fcreatetime,b.fcontractname fcontractname from t_tcnfep_ext_payment_acc a left join t_tcnfep_contract_info b on a.fcontractname=b.fid where a.fstartdate is null;";
        DataSet rows = DB.queryDataSet((String)"WithholdRemitDraftSbsrwbUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(500);
        while (rows.hasNext()) {
            Row row = rows.next();
            Long id = row.getLong("FID");
            String payreason = String.format(ResManager.loadKDString((String)"%s\u4ed8\u6b3e", (String)"PaymentAccountDatePayreasonUpagradeService_0", (String)"taxc-tcnfep-mservice", (Object[])new Object[0]), row.getString("FCONTRACTNAME"));
            Date createtime = row.getDate("FCREATETIME");
            if (ObjectUtils.isEmpty((Object)createtime)) continue;
            Date enddate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)createtime));
            Date startdate = DateUtils.getFirstDateOfMonth((Date)enddate);
            Object[] param = new Object[]{payreason, startdate, enddate, id};
            paramList.add(param);
        }
        rows.close();
        String updateSql = "update t_tcnfep_ext_payment_acc set fpayreason=?,fstartdate=?,fenddate=? where fid=?;";
        if (!paramList.isEmpty()) {
            DBUtils.executeBatch((String)updateSql, paramList);
        }
    }
}

