/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PaymentAccountTaxRecordNumberUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PaymentAccountTaxRecordNumberUpgradeService.class);
    private static final String SQL_SELECT1 = "select c.fid,c.fpaydate,c.fcontractname from t_tcnfep_ext_payment_acc c inner join t_tcnfep_contract_info b on c.fcontractname = b.fid";
    private static final String SQL_SELECT2 = "select c.fpaydate,c.fcontractname from t_tcnfep_ext_payment_acc c inner join t_tcnfep_ext_record d on c.fbillno = d.faccnumber where d.fbillstatus = 'C'";
    private static final String SQL_UPDATE = "update t_tcnfep_ext_payment_acc a set ftaxrecordnumber = (select frecordnumber from t_tcnfep_contract_info b where a.fcontractname = b.fid) where fid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_ext_payment_acc") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_contract_info") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_ext_record")) {
            List queryAccount = DBUtils.query((String)SQL_SELECT1);
            List queryPayDate = DBUtils.query((String)SQL_SELECT2);
            if (EmptyCheckUtils.isNotEmpty((Object)queryAccount)) {
                Map<String, Object> accountMap = queryPayDate.stream().collect(Collectors.toMap(a -> String.valueOf(a.get("FCONTRACTNAME")), b -> b.get("FPAYDATE"), (m, n) -> m));
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (Map row : queryAccount) {
                    Date paydate = (Date)row.get("FPAYDATE");
                    if (accountMap.get(String.valueOf(row.get("FCONTRACTNAME"))) == null || paydate.compareTo((Date)accountMap.get(String.valueOf(row.get("FCONTRACTNAME")))) <= 0) continue;
                    Object fid = row.get("FID");
                    paramList.add(new Object[]{fid});
                }
                try (TXHandle h = TX.required();){
                    try {
                        if (EmptyCheckUtils.isNotEmpty(paramList)) {
                            DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE, paramList);
                        }
                    }
                    catch (Exception e) {
                        h.markRollback();
                        LOGGER.error(ERROR_INFO, (Throwable)e);
                    }
                }
            }
        }
    }
}

