/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.compress.utils.Lists;

public class TaxPaymentUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxPaymentUpgradeService.class);
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String BDTAXR_PAY_RECORD = "bdtaxr_pay_record";
    private static final String TCNFEP_DECLARE_ENTRY = "tcnfep_declare_entry";
    private static final String TCNFEP_KJQYSDS_ENTITY = "tcnfep_kjqysds_entity";
    private static final int PAGE_SIZE = 100;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7a0e\u91d1\u7f34\u7eb3\uff1a\u4ee3\u6263\u4ee3\u7f34\u548c\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u4e2d\u5386\u53f2\u6570\u636e\u5904\u7406\u6210\u529f\uff01", (String)"TaxPaymentUpgradeService_0", (String)"taxc-tcnfep-mservice", (Object[])new Object[0]);
        try {
            if (this.hasMetaData() && !this.hasHisData()) {
                this.updateNxxBqybtse();
                this.updateData();
            } else {
                log = ResManager.loadKDString((String)"\u7a0e\u91d1\u7f34\u7eb3\uff1a\u4ee3\u6263\u4ee3\u7f34\u548c\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u4e2d\u5386\u53f2\u6570\u636e\u4e0d\u9700\u8981\u505a\u5904\u7406\uff01", (String)"TaxPaymentUpgradeService_1", (String)"taxc-tcnfep-mservice", (Object[])new Object[0]);
            }
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void updateNxxBqybtse() {
        int pageNum = 0;
        QFilter filter = new QFilter("type", "in", Arrays.asList("dkdj", "kjqysds"));
        String field = "id,type,bqybtse";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TCVAT_NSRXX, (String)field, (QFilter[])new QFilter[]{filter}, (String)"id", (int)pageNum, (int)100);
        while (null != dynamicObjects && dynamicObjects.length > 0) {
            ArrayList records = Lists.newArrayList();
            Arrays.stream(dynamicObjects).forEach(one -> {
                String type = one.getString("type");
                Object id = one.get("id");
                BigDecimal result = null;
                if ("dkdj".equals(type)) {
                    result = this.getDkdjBqybtse(TCNFEP_DECLARE_ENTRY, "sjsezzs", id);
                } else if ("kjqysds".equals(type)) {
                    result = this.getDkdjBqybtse(TCNFEP_KJQYSDS_ENTITY, "sjse", id);
                }
                if (result != null) {
                    one.set("bqybtse", (Object)result);
                    records.add(one);
                }
            });
            if (!CollectionUtils.isEmpty((Collection)records)) {
                SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[0]));
                LOGGER.info("\u4ee3\u6263\u4ee3\u7f34\u548c\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u4e2dNXX\u5386\u53f2\u6570\u636e\u5904\u7406\u4e2d\u6210\u529f\u6267\u884c\u4e86{}\u884c", (Object)records.size());
            }
            dynamicObjects = BusinessDataServiceHelper.load((String)TCVAT_NSRXX, (String)field, (QFilter[])new QFilter[]{filter}, (String)"id", (int)(++pageNum), (int)100);
        }
    }

    public BigDecimal getDkdjBqybtse(String table, String field, Object id) {
        QFilter filter = new QFilter("sbbid", "in", id);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)table, (String)field, (QFilter[])new QFilter[]{filter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0].getBigDecimal(field);
        }
        return null;
    }

    public void updateData() {
        int pageNum = 0;
        QFilter filter1 = new QFilter("type", "in", Arrays.asList("dkdj", "kjqysds"));
        QFilter filter3 = new QFilter("declarestatus", "=", (Object)"declared");
        QFilter filter4 = new QFilter("paystatus", "=", (Object)"unpaid");
        String fields = "id,org,bqybtse,billno,type,bqybtse,skssqq,skssqz,taxauthority,payer,declarestatus,paystatus";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TCVAT_NSRXX, (String)fields, (QFilter[])new QFilter[]{filter1, filter3, filter4}, (String)"id", (int)pageNum, (int)100);
        while (null != dynamicObjects && dynamicObjects.length > 0) {
            ArrayList records = Lists.newArrayList();
            Arrays.stream(dynamicObjects).forEach(one -> {
                Object org = one.get("org");
                long orgId = org instanceof Long ? ((Long)org).longValue() : ((DynamicObject)org).getLong("id");
                DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)BDTAXR_PAY_RECORD);
                String number = CodeRuleServiceHelper.getNumber((String)BDTAXR_PAY_RECORD, (DynamicObject)record, (String)String.valueOf(orgId));
                record.set("billno", (Object)number);
                record.set("yjje", one.get("bqybtse"));
                record.set("jkbl", (Object)BigDecimal.ONE);
                record.set("paystatus", (Object)"2");
                record.set("sbbno", (Object)one.getString("billno"));
                record.set("taxtype", (Object)one.getString("type"));
                record.set("sjje", (Object)BigDecimal.ZERO);
                record.set("syqjje", one.get("bqybtse"));
                record.set("sbbid", one.get("id"));
                record.set("sbbentryid", (Object)0);
                record.set("accountorg", (Object)this.getDefaultAccountOrg(orgId, null, null).get(0));
                record.set("org", one.get("org"));
                record.set("skssqq", (Object)one.getDate("skssqq"));
                record.set("skssqz", (Object)one.getDate("skssqz"));
                String skssqqStr = DateUtils.format((Date)one.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                String skssqzStr = DateUtils.format((Date)one.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                record.set("sssq", (Object)skssqqStr.concat("-").concat(skssqzStr));
                record.set("nsrtype", (Object)one.getString("type"));
                record.set("billstatus", (Object)"C");
                record.set("deadline", (Object)DateUtils.addDay((Date)one.getDate("skssqz"), (int)7));
                record.set("taxauthority", one.get("taxauthority"));
                record.set("payer", one.get("payer"));
                Long sbbentryid = one.getString("type").equals("dkdj") ? this.getDkdjEntryId(one.getLong("id")) : this.getKjqysdsEntryId(one.getLong("id"));
                record.set("sbbentryid", (Object)sbbentryid);
                DynamicObjectCollection entryentity = record.getDynamicObjectCollection("entryentity");
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("taxitem", (Object)one.getString("type"));
                dynamicObject.set("yjjemx", one.get("bqybtse"));
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
                dynamicObject.set("syqjjemx", one.get("bqybtse"));
                dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
                records.add(record);
            });
            Object[] save = SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            LOGGER.info("\u4ee3\u6263\u4ee3\u7f34\u548c\u6263\u7f34\u4f01\u4e1a\u6240\u5f97\u7a0e\u4e2d\u5386\u53f2\u6570\u636e\u5904\u7406\u4e2d\u6210\u529f\u6267\u884c\u4e86{}\u884c", (Object)save.length);
            dynamicObjects = BusinessDataServiceHelper.load((String)TCVAT_NSRXX, (String)fields, (QFilter[])new QFilter[]{filter1, filter3, filter4}, (String)"id", (int)(++pageNum), (int)100);
        }
    }

    private Long getDkdjEntryId(Long sbbid) {
        QFilter filter = new QFilter("sbbid", "=", (Object)sbbid);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)TCNFEP_DECLARE_ENTRY, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"id");
        if (EmptyCheckUtils.isNotEmpty((Object)objects)) {
            return objects[0].getLong("id");
        }
        return null;
    }

    private Long getKjqysdsEntryId(Long sbbid) {
        QFilter filter = new QFilter("sbbid", "=", (Object)sbbid);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)TCNFEP_KJQYSDS_ENTITY, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"id");
        if (EmptyCheckUtils.isNotEmpty((Object)objects)) {
            return objects[0].getLong("id");
        }
        return null;
    }

    private List<Long> getDefaultAccountOrg(Long taxOrg, Date startDate, Date endDate) {
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
        return !CollectionUtils.isEmpty((Collection)orgRelations) ? orgRelations.stream().distinct().collect(Collectors.toList()) : com.google.common.collect.Lists.newArrayList((Object[])new Long[]{0L});
    }

    private boolean hasHisData() {
        QFilter filter = new QFilter("taxtype", "in", Arrays.asList("dkdj", "kjqysds"));
        return QueryServiceHelper.exists((String)BDTAXR_PAY_RECORD, (QFilter[])new QFilter[]{filter});
    }

    private boolean hasMetaData() {
        return this.metaIsExist(TCVAT_NSRXX) != false && this.metaIsExist(BDTAXR_PAY_RECORD) != false;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    protected IUpgradeService getService() {
        return this;
    }
}

