/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class WithholdRemitCountryUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(WithholdRemitCountryUpgradeService.class);
    private static final String SQL_SELECT_WITHHOLDREMIT = "select fid,fpayeeaddressid from t_tcnfep_withhold_remit where (fcountryid = 0 or fcountryid is null) and (fpayeeaddressid != ' ' and fpayeeaddressid != '' and fpayeeaddressid is not null)";
    private static final String SQL_SELECT_BD_ADMINDIVISION = "select fid,fcountryid from t_bd_admindivision where fid in (%s)";
    private static final String SQL_UPDATE_WITHHOLDREMIT = "update t_tcnfep_withhold_remit set fcountryid = ? where fid = ?";
    private static final String SQL_SELECT_DECLAREENTRY = "select fid,fgj from t_tcnfep_declare_entry where (fcountryid = 0 or fcountryid is null) and (fgj != 0 and fgj is not null)";
    private static final String SQL_UPDATE_DECLAREENTRY = "update t_tcnfep_declare_entry set fcountryid = ? where fid = ?";
    private static final Map<Object, Object> countryIdMap = new HashMap<Object, Object>(){
        {
            this.put("1005772187937808384", "1000005");
            this.put("1005772187937808385", "1000003");
            this.put("1005772187937808386", "1000004");
        }
    };

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.updateWithholdRemit();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        try {
            this.updateDeclareEntry();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void updateWithholdRemit() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_withhold_remit") && DB.exitsTable((DBRoute)DBRoute.of((String)"sys"), (String)"t_bd_admindivision") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_WITHHOLDREMIT)))) {
            List payeeaddressIds = needUpdateDatas.stream().map(s -> s.get("FPAYEEADDRESSID")).collect(Collectors.toList());
            List admindivisionDatas = DBUtils.query((String)"sys", (String)String.format(SQL_SELECT_BD_ADMINDIVISION, StringUtils.join((Object[])payeeaddressIds.toArray(), (String)",")));
            Map<String, Object> idMap = admindivisionDatas.stream().collect(Collectors.toMap(a -> a.get("FID") + "", b -> b.get("FCOUNTRYID"), (m, n) -> m));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : needUpdateDatas) {
                Object fcountryid;
                Object fid;
                if (idMap.get(row.get("FPAYEEADDRESSID") + "") == null) continue;
                if (countryIdMap.containsKey(row.get("FPAYEEADDRESSID") + "")) {
                    fid = row.get("FID");
                    fcountryid = Long.valueOf(countryIdMap.get(row.get("FPAYEEADDRESSID") + "").toString());
                    paramList.add(new Object[]{fcountryid, fid});
                    continue;
                }
                fid = row.get("FID");
                fcountryid = idMap.get(row.get("FPAYEEADDRESSID") + "");
                paramList.add(new Object[]{fcountryid, fid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE_WITHHOLDREMIT, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }

    private void updateDeclareEntry() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_declare_entry") && DB.exitsTable((DBRoute)DBRoute.of((String)"sys"), (String)"t_bd_admindivision") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_DECLAREENTRY)))) {
            List payeeaddressIds = needUpdateDatas.stream().map(s -> s.get("FGJ")).collect(Collectors.toList());
            List admindivisionDatas = DBUtils.query((String)"sys", (String)String.format(SQL_SELECT_BD_ADMINDIVISION, StringUtils.join((Object[])payeeaddressIds.toArray(), (String)",")));
            Map<String, Object> idMap = admindivisionDatas.stream().collect(Collectors.toMap(a -> a.get("FID") + "", b -> b.get("FCOUNTRYID"), (m, n) -> m));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (Map row : needUpdateDatas) {
                Object fcountryid;
                Object fid;
                if (idMap.get(row.get("FGJ") + "") == null) continue;
                if (countryIdMap.containsKey(row.get("FGJ") + "")) {
                    fid = row.get("FID");
                    fcountryid = Long.valueOf(countryIdMap.get(row.get("FGJ") + "").toString());
                    paramList.add(new Object[]{fcountryid, fid});
                    continue;
                }
                fid = row.get("FID");
                fcountryid = idMap.get(row.get("FGJ") + "");
                paramList.add(new Object[]{fcountryid, fid});
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_UPDATE_DECLAREENTRY, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

