/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import org.apache.commons.lang3.ObjectUtils;

public class WithholdRemitDraftSbsrwbUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(WithholdRemitDraftSbsrwbUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        String sql = "select t1.fid fid,t1.fneedpayqysds fneedpayqysds,t1.fsfxsssxdyh fsfxsssxdyh,t2.fsfswzzcdzzs fsfswzzcdzzs,t2.fsfswzzcdqysds fsfswzzcdqysds,t1.fsqfkjewb fsqfkjewb,t1.frate_zzs frate_zzs,t1.frate_qysds frate_qysds,t1.fdiscountrate_qysds fdiscountrate_qysds from t_tcnfep_withhold_remit t1 left join t_tcnfep_contract_info t2 on t2.fid = t1.fcontractid where t1.fhdlrl_qysds=0 and (t1.fsbsrwb =0 or t1.fsbsrwb is null);";
        DataSet rows = DB.queryDataSet((String)"WithholdRemitDraftSbsrwbUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(500);
        while (rows.hasNext()) {
            Row row = rows.next();
            Long fid = row.getLong("FID");
            BigDecimal sbsrwb = this.calSbsrwb(row.getBoolean("FNEEDPAYQYSDS"), row.getBoolean("FSFXSSSXDYH"), row.getBoolean("FSFSWZZCDZZS"), row.getBoolean("FSFSWZZCDQYSDS"), row.getBigDecimal("FSQFKJEWB"), row.getString("FRATE_ZZS"), row.getBigDecimal("FRATE_QYSDS"), row.getBigDecimal("FDISCOUNTRATE_QYSDS"));
            Object[] param = new Object[]{sbsrwb, fid};
            paramList.add(param);
        }
        rows.close();
        String updateSql = "update t_tcnfep_withhold_remit set fsbsrwb=? where fid=?";
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, paramList);
        }
    }

    public BigDecimal calSbsrwb(Boolean fneedpayqysds, Boolean fsfxsssxdyh, Boolean fsfswzzcdzzs, Boolean fsfswzzcdqysds, BigDecimal fsqfkjewb, String frate_zzs, BigDecimal frate_qysds, BigDecimal fdiscountrate_qysds) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{fneedpayqysds, fsfxsssxdyh, fsfswzzcdzzs, fsfswzzcdqysds, fsqfkjewb, frate_zzs, frate_qysds, fdiscountrate_qysds})) {
            BigDecimal rate_zzs = BigDecimalUtil.toBigDecimal((Object)frate_zzs);
            if (!fneedpayqysds.booleanValue() && fsfswzzcdqysds.booleanValue()) {
                return BigDecimal.ZERO;
            }
            if (!fsfswzzcdzzs.booleanValue() && !fsfswzzcdqysds.booleanValue() && BigDecimal.ZERO.compareTo(BigDecimal.ONE.add(rate_zzs)) != 0) {
                return fsqfkjewb.divide(BigDecimal.ONE.add(rate_zzs), 2, RoundingMode.HALF_UP);
            }
            if (!fsfswzzcdzzs.booleanValue() && fsfswzzcdqysds.booleanValue() && BigDecimal.ZERO.compareTo(BigDecimal.ONE.add(rate_zzs)) != 0 && BigDecimal.ZERO.compareTo(BigDecimal.ONE.subtract(frate_qysds)) != 0) {
                return fsqfkjewb.divide(BigDecimal.ONE.add(rate_zzs), 8, RoundingMode.HALF_UP).divide(BigDecimal.ONE.subtract(frate_qysds), 2, RoundingMode.HALF_UP);
            }
            if (fsfswzzcdzzs.booleanValue() && !fsfswzzcdqysds.booleanValue() && BigDecimal.ZERO.compareTo(BigDecimal.ONE.subtract(frate_qysds)) != 0) {
                return fsqfkjewb;
            }
            if (fsfswzzcdzzs.booleanValue() && fsfswzzcdqysds.booleanValue()) {
                if (fsfxsssxdyh.booleanValue()) {
                    if (BigDecimal.ZERO.compareTo(BigDecimal.ONE.subtract(fdiscountrate_qysds)) != 0) {
                        return fsqfkjewb.divide(BigDecimal.ONE.subtract(fdiscountrate_qysds), 2, RoundingMode.HALF_UP);
                    }
                } else if (BigDecimal.ZERO.compareTo(BigDecimal.ONE.subtract(frate_qysds)) != 0) {
                    return fsqfkjewb.divide(BigDecimal.ONE.subtract(frate_qysds), 2, RoundingMode.HALF_UP);
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

