/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcnfep.mservice.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcnfep.business.draft.WithholdRemitHelper;

public class WithholdRemitUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_DATA = "select fid,fformula_zzs,fyfse_zzs,fformula_qysds,fyfse_qysds,fsfxsssxdyh,fneedpayqysds ,fcontractid,fhdlrl_qysds,fjsjc_zzs,frate_zzs,frate_qysds,fjsjc_qysds,fdiscountrate_qysds from t_tcnfep_withhold_remit where fjsyj_zzs is null or fjsyj_zzs = 0;";
    private static final String UPDATE_DATA = "update t_tcnfep_withhold_remit set fformula_zzs = ?,fjsyj_zzs = ?,fyfse_zzs = ?,fformula_qysds = ?,fyfse_qysds = ? where fid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(WithholdRemitUpgradeService.class);
    private static final List<String> ZZS_RECAL_LIST = Collections.singletonList("jsjc/(1-qysdsl)/(1+zzsl)");
    private static final List<String> QYSDS_RECAL_LIST = Arrays.asList("jsjc/(1-zzsl)*qysdsl", "jsjc/(1-zzsl)*discountrate");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u8ba1\u7a0e\u5e95\u7a3f\u5347\u7ea7\u6210\u529f", (String)"WithholdRemitUpgradeService_0", (String)"taxc-tcnfep-mservice", (Object[])new Object[0]);
        try {
            boolean exit = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcnfep_withhold_remit");
            if (exit) {
                this.update();
            } else {
                info = log = ResManager.loadKDString((String)"\u65e0\u9700\u5347\u7ea7\u4ee3\u6263\u4ee3\u7f34\u8ba1\u7a0e\u5e95\u7a3f", (String)"WithholdRemitUpgradeService_1", (String)"taxc-tcnfep-mservice", (Object[])new Object[0]);
            }
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        List needUpdateList = DBUtils.query((String)QUERY_DATA);
        if (CollectionUtils.isEmpty((Collection)needUpdateList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(needUpdateList.size());
        for (Map updateMap : needUpdateList) {
            long id = Long.parseLong(String.valueOf(updateMap.get("FID")));
            Boolean sfxsssxdyh = "1".equals(updateMap.get("FSFXSSSXDYH"));
            Boolean needpayqysds = "1".equals(updateMap.get("FNEEDPAYQYSDS"));
            long contractid = Long.parseLong(String.valueOf(updateMap.get("FCONTRACTID")));
            DynamicObject contractObj = BusinessDataServiceHelper.loadSingle((Object)contractid, (String)"tcnfep_contract_info");
            Boolean sfswzzcdzzs = contractObj.getBoolean("sfswzzcdzzs");
            Boolean sfswzzcdqysds = contractObj.getBoolean("sfswzzcdqysds");
            BigDecimal hdlrlQysds = (BigDecimal)updateMap.get("FHDLRL_QYSDS");
            BigDecimal jsjcZzs = (BigDecimal)updateMap.get("FJSJC_ZZS");
            BigDecimal jsjcQysds = (BigDecimal)updateMap.get("FJSJC_QYSDS");
            BigDecimal rateZzs = new BigDecimal((String)updateMap.get("FRATE_ZZS"));
            BigDecimal rateQysds = (BigDecimal)updateMap.get("FRATE_QYSDS");
            BigDecimal discountrateQysds = (BigDecimal)updateMap.get("FDISCOUNTRATE_QYSDS");
            String formulaZzs = WithholdRemitHelper.getExpression((String)"zzs", (Boolean)sfxsssxdyh, (Boolean)needpayqysds, (Boolean)sfswzzcdzzs, (Boolean)sfswzzcdqysds, (BigDecimal)hdlrlQysds, (BigDecimal)discountrateQysds);
            BigDecimal jsyjZzs = WithholdRemitHelper.calclateZss((Boolean)sfxsssxdyh, (Boolean)needpayqysds, (Boolean)sfswzzcdzzs, (Boolean)sfswzzcdqysds, (BigDecimal)jsjcZzs, (BigDecimal)rateZzs, (BigDecimal)rateQysds, (BigDecimal)hdlrlQysds, (BigDecimal)discountrateQysds);
            BigDecimal yfseZzs = (BigDecimal)updateMap.get("FYFSE_ZZS");
            if (ZZS_RECAL_LIST.contains(formulaZzs)) {
                yfseZzs = jsyjZzs.multiply(rateZzs);
            }
            String formulaQysds = (String)updateMap.get("FFORMULA_QYSDS");
            BigDecimal yfseQysds = (BigDecimal)updateMap.get("FYFSE_QYSDS");
            if (QYSDS_RECAL_LIST.contains(formulaQysds)) {
                formulaQysds = WithholdRemitHelper.getExpression((String)"qysds", (Boolean)sfxsssxdyh, (Boolean)needpayqysds, (Boolean)sfswzzcdzzs, (Boolean)sfswzzcdqysds, (BigDecimal)hdlrlQysds, (BigDecimal)discountrateQysds);
                yfseQysds = WithholdRemitHelper.calclateQysds((Boolean)sfxsssxdyh, (Boolean)needpayqysds, (Boolean)sfswzzcdzzs, (Boolean)sfswzzcdqysds, (BigDecimal)jsjcQysds, (BigDecimal)rateZzs, (BigDecimal)rateQysds, (BigDecimal)hdlrlQysds, (BigDecimal)discountrateQysds);
            }
            paramsList.add(new Object[]{formulaZzs, jsyjZzs, yfseZzs, formulaQysds, yfseQysds, id});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_DATA, paramsList);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

