/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.dimension.ProvisionDimensionHelper;
import kd.taxc.tcret.common.enums.YhsPrepayTypeEnum;

public class PrePayAccountServiceHepler {
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String EXPIRYDATE = "expirydate";

    public static void runEngine(DynamicObjectCollection queryprepay, String gathernumber) {
        for (DynamicObject object : queryprepay) {
            Long taxorg = object.getLong("orgid");
            boolean dimensionByAccountOrg = ProvisionDimensionHelper.isDimensionByAccountOrg(taxorg, DeclareTaxType.YHS.getBaseTaxId(), object.getDate(EFFECTIVEDATE), object.getDate(EXPIRYDATE));
            QFilter[] filters = new QFilter[]{new QFilter("orgentryentity.orgid", "=", (Object)taxorg), new QFilter("entryentity.taxitem.number", "=", object.get("tnumber"))};
            DynamicObject mappingObject = QueryServiceHelper.queryOne((String)"tcret_taxitem_mapping", (String)"entryentity.precollectitem,entryentity.taxitem.number,entryentity.subitem,entryentity.subitem.value,orgentryentity.orgid", (QFilter[])filters);
            if (mappingObject == null) continue;
            List monthBetween = DateUtils.getMonthBetween((Date)object.getDate(EFFECTIVEDATE), (Date)object.getDate(EXPIRYDATE), (String)"yyyy-MM-dd");
            List<Date> monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
            QFilter filter = new QFilter("org", "=", (Object)taxorg).and(new QFilter("billstatus", "=", (Object)"C"));
            QFilter timefilter = new QFilter("skssqq", "=", (Object)object.getDate(EFFECTIVEDATE)).and(new QFilter("skssqz", "=", (Object)object.getDate(EXPIRYDATE)));
            monthList.forEach(s -> timefilter.or(new QFilter("skssqq", "=", s).and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)s)))));
            DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,declareserialno,accountorg", (QFilter[])new QFilter[]{filter, timefilter});
            if (dimensionByAccountOrg) {
                Map<Long, List<DynamicObject>> prepayDeclareBillMap = prepayDeclareQuery.stream().collect(Collectors.groupingBy(d -> d.getLong("accountorg")));
                for (Map.Entry<Long, List<DynamicObject>> entry : prepayDeclareBillMap.entrySet()) {
                    Long accountorg = entry.getKey();
                    PrePayAccountServiceHepler.calcPrePay(gathernumber, object, taxorg, accountorg, mappingObject, entry.getValue());
                }
                continue;
            }
            PrePayAccountServiceHepler.calcPrePay(gathernumber, object, taxorg, 0L, mappingObject, (List<DynamicObject>)prepayDeclareQuery);
        }
    }

    private static void calcPrePay(String gathernumber, DynamicObject object, Long taxorg, Long accountorg, DynamicObject mappingObject, List<DynamicObject> prepayDeclareQuery) {
        List declareserialnoList;
        QFilter accountFilter;
        DynamicObjectCollection prepayAccount;
        if (prepayDeclareQuery != null && prepayDeclareQuery.size() > 0 && (prepayAccount = QueryServiceHelper.query((String)"tcvat_project_account", (String)"orgid,taxoffice,prepaytype,startdate,enddate,declareserialno,entryentity.taxtype,entryentity.prepayrate,entryentity.prepaybase,entryentity", (QFilter[])new QFilter[]{accountFilter = new QFilter("orgid", "=", (Object)taxorg).and(new QFilter("declareserialno", "in", declareserialnoList = prepayDeclareQuery.stream().map(p -> p.getString("declareserialno")).collect(Collectors.toList()))).and(new QFilter("prepaytype", "in", YhsPrepayTypeEnum.getTypeByItem(mappingObject.getString("entryentity.precollectitem")))).and(new QFilter("taxoffice", "=", object.get("taxoffice"))).and(new QFilter("entryentity.taxtype", "=", (Object)ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"PrePayAccountServiceHepler_0", (String)"taxc-tcret", (Object[])new Object[0])))})) != null && prepayAccount.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    PrePayAccountServiceHepler.deleteAccount(accountorg, object);
                    PrePayAccountServiceHepler.prepayAccountCalculate(accountorg, object, gathernumber, prepayAccount, mappingObject);
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new RuntimeException(t);
                }
            }
        }
    }

    private static void deleteAccount(Long accountorg, DynamicObject object) {
        QFilter orgFilter = new QFilter("org", "=", object.get("orgid"));
        QFilter accountorgFilter = new QFilter("accountorg", "=", (Object)accountorg);
        QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)object.getDate(EFFECTIVEDATE)).and(new QFilter("skssqz", "=", (Object)object.getDate(EXPIRYDATE)));
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", object.get("taxoffice"));
        QFilter taxitemFilter = new QFilter("taxitem", "=", object.get("taxitem"));
        QFilter verifyrateFilter = new QFilter("verifyrate", "=", object.get("hdrate"));
        QFilter paytypeFilter = new QFilter("paytype", "=", (Object)"ydjn");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcret_yhs_tax_account", (String)"id,org,skssqq,skssqz,taxitem", (QFilter[])new QFilter[]{orgFilter, accountorgFilter, skssqqzFilter, new QFilter("datasource", "=", (Object)"prepay"), taxitemFilter, verifyrateFilter, taxofficeFilter, paytypeFilter});
        if (query.size() > 0) {
            List ids = query.stream().map(b -> b.getString("id")).collect(Collectors.toList());
            QFilter serialnoQFilter = new QFilter("taxaccountserialno", "in", ids);
            DeleteServiceHelper.delete((String)"tcret_yhs_prepay_deta", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, serialnoQFilter});
        }
        DeleteServiceHelper.delete((String)"tcret_yhs_tax_account", (QFilter[])new QFilter[]{orgFilter, accountorgFilter, skssqqzFilter, taxofficeFilter, new QFilter("datasource", "=", (Object)"prepay"), taxitemFilter, verifyrateFilter, paytypeFilter});
    }

    private static void prepayAccountCalculate(Long accountorg, DynamicObject object, String gathernumber, DynamicObjectCollection prepayAccount, DynamicObject mappingObject) {
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>(prepayAccount.size());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(prepayAccount.size());
        ArrayList<DynamicObject> prepayDetailList = new ArrayList<DynamicObject>(1);
        List<String> declareserialnoList = prepayAccount.stream().map(a -> a.getString("declareserialno")).collect(Collectors.toList());
        long id = DBUtils.getLongId((String)"tcret_yhs_tax_account");
        DynamicObject summary = PrePayAccountServiceHepler.getSummaryObject(id, accountorg, object, gathernumber, mappingObject);
        PrePayAccountServiceHepler.setPrepayDetailList(object.getLong("orgid"), object.getDate(EFFECTIVEDATE), object.getDate(EXPIRYDATE), prepayDetailList, declareserialnoList, id, prepayAccount, summary);
        summary.set("taxoffice", object.get("taxoffice"));
        BigDecimal totalTaxableitem = BigDecimalUtil.sumDynamicObjectAmount(prepayDetailList, (String)"amount");
        summary.set("calctaxamount", (Object)totalTaxableitem);
        summaryAccountingList.addAll(prepayDetailList);
        summaryList.add(summary);
        SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
    }

    private static void setPrepayDetailList(Long taxorg, Date startDate, Date endDate, List<DynamicObject> summaryAccountingList, List<String> declareserialnoList, long id, DynamicObjectCollection prepayAccount, DynamicObject summary) {
        Optional<BigDecimal> reduce;
        DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,modifytime,declareserialno", (QFilter[])new QFilter[]{new QFilter("declareserialno", "in", declareserialnoList)});
        List modifytimeList = prepayDeclareQuery.stream().sorted(Comparator.comparing(s -> s.getDate("modifytime"))).collect(Collectors.toList());
        Optional<DynamicObject> first = prepayAccount.stream().filter(s -> s.get("declareserialno").equals(((DynamicObject)modifytimeList.get(0)).get("declareserialno")) && s.get("entryentity.taxtype").equals(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"PrePayAccountServiceHepler_0", (String)"taxc-tcret", (Object[])new Object[0]))).findFirst();
        if (first.isPresent()) {
            String taxrate = first.get().getString("entryentity.prepayrate");
            if (taxrate.contains("%")) {
                BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("%", ""));
                taxrateBigDecimal = taxrateBigDecimal.multiply(BigDecimal.valueOf(10L));
                taxrate = taxrateBigDecimal.toString() + "\u2030";
            }
            summary.set("taxrate", (Object)taxrate);
        }
        if ((reduce = prepayAccount.stream().filter(s -> startDate.compareTo(s.getDate("startdate")) <= 0 && endDate.compareTo(s.getDate("enddate")) >= 0).map(e -> e.getBigDecimal("entryentity.prepaybase")).reduce(BigDecimal::add)).isPresent()) {
            DynamicObject detailObject = BusinessDataServiceHelper.newDynamicObject((String)"tcret_yhs_prepay_deta");
            detailObject.set("id", (Object)id);
            detailObject.set("taxaccountserialno", (Object)String.valueOf(id));
            detailObject.set("org", (Object)taxorg);
            detailObject.set("skssqq", (Object)startDate);
            detailObject.set("skssqz", (Object)endDate);
            detailObject.set("taxorg", (Object)taxorg);
            detailObject.set("amount", (Object)reduce.get());
            detailObject.set("prepayitem", (Object)YhsPrepayTypeEnum.getItemByType(((DynamicObject)prepayAccount.get(0)).get("prepaytype").toString()));
            summaryAccountingList.add(detailObject);
        }
    }

    private static DynamicObject getSummaryObject(long id, Long accountorg, DynamicObject object, String gathernumber, DynamicObject mappingObject) {
        DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"tcret_yhs_tax_account");
        summary.set("id", (Object)id);
        summary.set("org", object.get("orgid"));
        summary.set("accountorg", (Object)accountorg);
        summary.set("skssqq", (Object)object.getDate(EFFECTIVEDATE));
        summary.set("skssqz", (Object)object.getDate(EXPIRYDATE));
        String billno = CodeRuleServiceHelper.getNumber((String)"tcret_yhs_tax_account", (DynamicObject)summary, null);
        summary.set("billno", (Object)billno);
        summary.set("taxitem", object.get("taxitem"));
        summary.set("billstatus", (Object)"A");
        summary.set("declaretype", object.get("declaretype"));
        summary.set("datasource", (Object)"prepay");
        summary.set("taxlimit", object.get("taxlimit"));
        summary.set("createtime", (Object)new Date());
        summary.set("gathernumber", (Object)gathernumber);
        summary.set("taxation", (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"));
        summary.set("verifyrate", object.get("hdrate"));
        String taxrate = object.getString("taxrate");
        if (object.get("tnumber").equals("02001")) {
            taxrate = mappingObject.getString("entryentity.subitem.value");
        }
        summary.set("taxrate", (Object)taxrate);
        summary.set("subtaxitem", (Object)mappingObject.getLong("entryentity.subitem"));
        summary.set("paytype", (Object)"ydjn");
        return summary;
    }
}

