/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.accrual.AccrualCalcDtoBuilder;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.common.enums.CcsTypeEnum;

public class CcsAccrualServiceImpl
implements AccrualCalcService {
    private static final List<String> clzbzl = CcsTypeEnum.CCSCL.getJsyj();
    private static final List<String> cbft = CcsTypeEnum.CCSCB.getJsyj();

    @Override
    public DynamicObject doCalAccrualInfo(AccrualCalcDto accrualCalcDto) {
        return AccrualCalcDtoBuilder.doInitAccrualObj(accrualCalcDto, "tcret_ccs_accrual_draft");
    }

    @Override
    public DynamicObjectCollection doCalcAccrualDetails(DynamicObject accrualDraftObj) {
        DynamicObjectCollection detailList = accrualDraftObj.getDynamicObjectCollection("entryentity");
        long orgId = accrualDraftObj.getDynamicObject("org").getLong("id");
        Date skssqq = accrualDraftObj.getDate("skssqq");
        Date skssqz = accrualDraftObj.getDate("skssqz");
        QFilter clOrgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter cbOrgFilter = new QFilter("orgfield", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sfdkdjFilter = new QFilter("withheld", "=", (Object)"0");
        QFilter dateFilter = new QFilter("vehicleregdate", "<=", (Object)skssqz).and(new QFilter("closedate", "is null", null).or(new QFilter("closedate", ">=", (Object)skssqq)));
        QFilter dateCbFilter = new QFilter("ownershipdate", "<=", (Object)skssqz).and(new QFilter("closedate", "is null", null).or(new QFilter("closedate", ">=", (Object)skssqq)));
        DynamicObject[] tdmCarTaxFundInfos = BusinessDataServiceHelper.load((String)"tdm_car_tax_fund_info", (String)"vehicleregdate,closedate,itemcollection,dwse,zbzl,entryentity.ratio,entryentity.start,entryentity.end", (QFilter[])new QFilter[]{clOrgFilter, enableFilter, sfdkdjFilter, dateFilter});
        Map<String, List<DynamicObject>> itemcollection = Arrays.stream(tdmCarTaxFundInfos).collect(Collectors.groupingBy(s -> s.getString("itemcollection")));
        itemcollection.forEach((k, v) -> {
            DynamicObject detail = detailList.addNew();
            detail.set("taxitem", k);
            detail.set("hbssl", ((DynamicObject)v.get(0)).get("dwse"));
            BigDecimal jsyjSum = BigDecimal.ZERO;
            BigDecimal ynseSum = BigDecimal.ZERO;
            BigDecimal jmseSum = BigDecimal.ZERO;
            BigDecimal jtynseSum = BigDecimal.ZERO;
            for (DynamicObject object : v) {
                Date closedate = object.getDate("closedate");
                Date minEndDate = DateUtils.getMinDate((Date[])new Date[]{skssqz, closedate != null ? DateUtils.addMonth((Date)closedate, (int)-1) : null});
                Date maxStartDate = DateUtils.getMaxDate((Date[])new Date[]{skssqq, object.getDate("vehicleregdate")});
                int monthDiff = DateUtils.subtractDatesForMonth((Date)minEndDate, (Date)maxStartDate);
                BigDecimal jsyj = clzbzl.contains(k) ? object.getBigDecimal("zbzl").setScale(2, 4) : BigDecimal.ONE;
                jsyjSum = jsyjSum.add(jsyj);
                BigDecimal ynse = jsyj.multiply(detail.getBigDecimal("hbssl")).multiply(BigDecimal.valueOf(monthDiff + 1)).divide(BigDecimal.valueOf(12L), 2, 4);
                ynseSum = ynseSum.add(ynse);
                BigDecimal reduce = object.getDynamicObjectCollection("entryentity").stream().filter(s -> s.getDate("start").compareTo(skssqq) <= 0 && (s.getDate("end") == null || s.getDate("end").compareTo(skssqz) >= 0)).map(s -> s.getBigDecimal("ratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal jmse = ynse.multiply(reduce).setScale(2, 4);
                jmseSum = jmseSum.add(jmse);
                jtynseSum = jtynseSum.add(ynse.subtract(jmse));
            }
            detail.set("calsource", (Object)jsyjSum);
            detail.set("ynse", (Object)ynseSum);
            detail.set("jmse", (Object)jmseSum);
            detail.set("jtynse", (Object)jtynseSum);
        });
        DynamicObject[] tdmShipTaxFundInfos = BusinessDataServiceHelper.load((String)"tdm_ship_tax_fund_info", (String)"ownershipdate,closedate,itemcollection,dwse,hulllength,jdw,entryentity.ratio,entryentity.start,entryentity.end", (QFilter[])new QFilter[]{cbOrgFilter, enableFilter, sfdkdjFilter, dateCbFilter});
        Map<String, List<DynamicObject>> itemcollectionCb = Arrays.stream(tdmShipTaxFundInfos).collect(Collectors.groupingBy(s -> s.getString("itemcollection")));
        itemcollectionCb.forEach((k, v) -> {
            DynamicObject detail = detailList.addNew();
            detail.set("taxitem", (Object)("cb" + k));
            detail.set("hbssl", ((DynamicObject)v.get(0)).get("dwse"));
            BigDecimal jsyjSum = BigDecimal.ZERO;
            BigDecimal ynseSum = BigDecimal.ZERO;
            BigDecimal jmseSum = BigDecimal.ZERO;
            BigDecimal jtynseSum = BigDecimal.ZERO;
            for (DynamicObject object : v) {
                Date closedate = object.getDate("closedate");
                Date minEndDate = DateUtils.getMinDate((Date[])new Date[]{skssqz, closedate != null ? DateUtils.addMonth((Date)closedate, (int)-1) : null});
                Date maxStartDate = DateUtils.getMaxDate((Date[])new Date[]{skssqq, object.getDate("ownershipdate")});
                int monthDiff = DateUtils.subtractDatesForMonth((Date)minEndDate, (Date)maxStartDate);
                BigDecimal jsyj = cbft.contains(k) ? object.getBigDecimal("hulllength") : object.getBigDecimal("jdw");
                jsyjSum = jsyjSum.add(jsyj);
                BigDecimal ynse = jsyj.multiply(detail.getBigDecimal("hbssl")).multiply(BigDecimal.valueOf(monthDiff + 1)).divide(BigDecimal.valueOf(12L), 2, 4);
                ynseSum = ynseSum.add(ynse);
                BigDecimal reduce = object.getDynamicObjectCollection("entryentity").stream().filter(s -> s.getDate("start").compareTo(skssqq) <= 0 && (s.getDate("end") == null || s.getDate("end").compareTo(skssqz) >= 0)).map(s -> s.getBigDecimal("ratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal jmse = ynse.multiply(reduce).setScale(2, 4);
                jmseSum = jmseSum.add(jmse);
                jtynseSum = jtynseSum.add(ynse.subtract(jmse));
            }
            detail.set("calsource", (Object)jsyjSum);
            detail.set("ynse", (Object)ynseSum);
            detail.set("jmse", (Object)jmseSum);
            detail.set("jtynse", (Object)jtynseSum);
        });
        accrualDraftObj.set("jtynsesum", (Object)this.doSumJtynse(detailList));
        return detailList;
    }
}

