/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcret.business.accrual.AccrualCalcDtoBuilder;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.formplugin.accrual.handler.AbstractFcsAccrualDraftCalHandler;
import kd.taxc.tcret.formplugin.accrual.handler.FcsHireAccrualCalHandler;
import kd.taxc.tcret.formplugin.accrual.handler.FcsPriceAccrualCalHandler;
import kd.taxc.tcret.formplugin.accrual.handler.FctdsAccrualCalHandler;

public class FcsAccrualServiceImpl
implements AccrualCalcService {
    private static final Map<String, AbstractFcsAccrualDraftCalHandler> calServiceMap = new HashMap<String, AbstractFcsAccrualDraftCalHandler>();

    @Override
    public DynamicObject doCalAccrualInfo(AccrualCalcDto accrualCalcDto) {
        return AccrualCalcDtoBuilder.doInitAccrualObj(accrualCalcDto, "tcret_fcs_accrual_draft");
    }

    @Override
    public DynamicObjectCollection doCalcAccrualDetails(DynamicObject accrualDraftObj) {
        DynamicObjectCollection detailList = accrualDraftObj.getDynamicObjectCollection("entryentity");
        Object taxtype = accrualDraftObj.get("taxtype");
        if (taxtype instanceof DynamicObject) {
            taxtype = ((DynamicObject)taxtype).getLong("id");
        }
        if (BaseTaxCategory.FCS.equals(taxtype)) {
            this.calFcsList(this.doCreateAccrualCalcDto(accrualDraftObj), detailList);
        } else if (BaseTaxCategory.CZTDSYS.equals(taxtype)) {
            this.calTdsList(this.doCreateAccrualCalcDto(accrualDraftObj), detailList);
        }
        this.setScaleOfAmount(detailList);
        accrualDraftObj.set("jtynsesum", (Object)this.doSumJtynse(detailList));
        return detailList;
    }

    private AccrualCalcDto doCreateAccrualCalcDto(DynamicObject accrualDraftObj) {
        AccrualCalcDto accrualCalcDto = new AccrualCalcDto();
        Object org = accrualDraftObj.get("org");
        Long orgId = null;
        if (org instanceof Long) {
            orgId = (Long)org;
        } else if (org instanceof DynamicObject) {
            orgId = ((DynamicObject)org).getLong("id");
        }
        accrualCalcDto.setOrgId(orgId);
        accrualCalcDto.setSkssqq(accrualDraftObj.getDate("skssqq"));
        accrualCalcDto.setSkssqz(accrualDraftObj.getDate("skssqz"));
        return accrualCalcDto;
    }

    private void calTdsList(AccrualCalcDto accrualCalcDto, DynamicObjectCollection detailList) {
        AbstractFcsAccrualDraftCalHandler cjHandler = calServiceMap.get("cztdsys");
        List<DynamicObject> tdAccrualDetail = cjHandler.cal(accrualCalcDto);
        accrualCalcDto.setTaxType(BaseTaxCategory.CZTDSYS);
        tdAccrualDetail.forEach(t -> {
            DynamicObject detail = detailList.addNew();
            this.doSetEntry((DynamicObject)t, detail, accrualCalcDto);
            detail.set("calsource", t.get("occupylandarea"));
            detail.set("taxitem", t.get("landlevel"));
            detail.set("taxrate", t.get("taxstandard"));
        });
    }

    private void calFcsList(AccrualCalcDto accrualCalcDto, DynamicObjectCollection detailList) {
        AbstractFcsAccrualDraftCalHandler cjHandler = calServiceMap.get("fcscj");
        List<DynamicObject> priceAccrualDetail = cjHandler.cal(accrualCalcDto);
        AbstractFcsAccrualDraftCalHandler czHandler = calServiceMap.get("fcscz");
        List<DynamicObject> hireAccrualDetail = czHandler.cal(accrualCalcDto);
        accrualCalcDto.setTaxType(BaseTaxCategory.FCS);
        priceAccrualDetail.forEach(p -> {
            DynamicObject detail = detailList.addNew();
            this.doSetEntry((DynamicObject)p, detail, accrualCalcDto);
            detail.set("calsource", p.get("taxbasis"));
            detail.set("taxitem", (Object)ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsAccrualServiceImpl_0", (String)"taxc-tcret", (Object[])new Object[0]));
            detail.set("taxrate", p.get("taxrate"));
        });
        hireAccrualDetail.forEach(h -> {
            DynamicObject detail = detailList.addNew();
            this.doSetEntry((DynamicObject)h, detail, accrualCalcDto);
            detail.set("calsource", h.get("currental"));
            detail.set("taxitem", (Object)ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsAccrualServiceImpl_1", (String)"taxc-tcret", (Object[])new Object[0]));
            detail.set("taxrate", h.get("taxrate"));
            detail.set("itemno", h.get("leasecontractno"));
        });
    }

    private void doSetEntry(DynamicObject d, DynamicObject detail, AccrualCalcDto accrualCalcDto) {
        detail.set("itemno", d.get("number"));
        detail.set("ynse", d.get("currentpayable"));
        detail.set("jmse", d.get("currentjmamount"));
        detail.set("jtynse", (Object)detail.getBigDecimal("ynse").subtract(detail.getBigDecimal("jmse")));
        detail.set("projectname", d.get("name"));
        detail.set("taxlimit", d.get("taxlimit"));
        DynamicObject sourceid = d.getDynamicObject("sourceid");
        detail.set("taxsourceid", sourceid == null ? Long.valueOf(0L) : sourceid.get("id"));
        if (sourceid != null) {
            this.addDimensionData(detail, accrualCalcDto, sourceid);
        }
    }

    private void addDimensionData(DynamicObject detail, AccrualCalcDto accrualCalcDto, DynamicObject sourceid) {
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(accrualCalcDto.getOrgId()), (Long)accrualCalcDto.getTaxType(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)accrualCalcDto.getSkssqq(), (Date)accrualCalcDto.getSkssqz());
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
            boolean isdimprovision = entry.getBoolean("ruleentity.rule.isdimprovision");
            String provisiondimension = entry.getString("ruleentity.rule.provisiondimension");
            if (isdimprovision && provisiondimension.contains("accountorg")) {
                if (sourceid.containsProperty("accountorg")) {
                    detail.set("accorg", sourceid.get("accountorg"));
                } else {
                    detail.set("accorg", sourceid.get("accorg"));
                }
            }
            if (isdimprovision && provisiondimension.contains("businessdimension")) {
                detail.set("bizdimensiontype", sourceid.get("bizdimensiontype"));
                detail.set("bizdimensionname", sourceid.get("bizdimensionname"));
                detail.set("bizdimensionid", sourceid.get("bizdimensionid"));
            }
        }
    }

    private void setScaleOfAmount(DynamicObjectCollection detailList) {
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return;
        }
        detailList.forEach(d -> {
            d.set("calsource", (Object)d.getBigDecimal("calsource").setScale(2, 4));
            d.set("ynse", (Object)d.getBigDecimal("ynse").setScale(2, 4));
            d.set("jmse", (Object)d.getBigDecimal("jmse").setScale(2, 4));
            d.set("jtynse", (Object)d.getBigDecimal("jtynse").setScale(2, 4));
        });
    }

    static {
        calServiceMap.put("fcscj", new FcsPriceAccrualCalHandler());
        calServiceMap.put("fcscz", new FcsHireAccrualCalHandler());
        calServiceMap.put("cztdsys", new FctdsAccrualCalHandler());
    }
}

