/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.yhs.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcret.business.accrual.yhs.YhsAccrualDataService;

public abstract class AbstractYhsAccrualDataServiceImpl
implements YhsAccrualDataService {
    private static final String EFFECTIVEDATE = "effectivedate";
    private static final String EXPIRYDATE = "expirydate";
    protected static final Date beginDate = DateUtils.stringToDate((String)"2022-06-30 23:59:59", (String)"yyyy-MM-dd HH:mm:ss");

    protected abstract void setAccrualDetailList(DynamicObjectCollection var1, EngineModel var2, List<DynamicObject> var3, List<Long> var4) throws Exception;

    @Override
    public void execute(DynamicObjectCollection detailList, EngineModel engineModel) throws Exception {
        String orgId = engineModel.getOrgId();
        Date skssqq = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)engineModel.getEndDate());
        List<Long> fitTaxItem = this.findFitTaxItem(Long.valueOf(orgId), skssqq, skssqz);
        List<DynamicObject> rules = this.queryRuleList(orgId);
        this.setAccrualDetailList(detailList, engineModel, rules, fitTaxItem);
    }

    Map<String, List<String>> addTaxitemList(Map<String, List<String>> targetMap, Map<String, List<String>> sourceMap) {
        for (Map.Entry<String, List<String>> entry : sourceMap.entrySet()) {
            List<String> stringList = this.addAmountsIntoTargetList(targetMap.get(entry.getKey()), entry.getValue());
            if (CollectionUtils.isEmpty(stringList)) continue;
            targetMap.put(entry.getKey(), stringList);
        }
        return targetMap;
    }

    List<String> addAmountsIntoTargetList(List<String> targetList, List<String> sourceList) {
        if (CollectionUtils.isEmpty(targetList) && CollectionUtils.isEmpty(sourceList)) {
            return new ArrayList<String>();
        }
        if (CollectionUtils.isEmpty(targetList)) {
            return sourceList;
        }
        if (CollectionUtils.isEmpty(sourceList)) {
            return targetList;
        }
        for (int i = 0; i < targetList.size(); ++i) {
            String s2;
            if (i == 1 || i == 3) continue;
            String s1 = targetList.get(i);
            if (s1.isEmpty()) {
                s1 = "0";
            }
            if ((s2 = sourceList.get(i)).isEmpty()) {
                s2 = "0";
            }
            targetList.set(i, new BigDecimal(s1).add(new BigDecimal(s2)).toString());
        }
        return targetList;
    }

    private List<DynamicObject> queryRuleList(String orgId) {
        ArrayList<DynamicObject> allRules = new ArrayList<DynamicObject>();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter ruleuseFilter = new QFilter("rulepurpose", "like", (Object)"%sjjt%");
        DynamicObject[] yshtpz = BusinessDataServiceHelper.load((String)"tcsd_rule_yshtpz", (String)MetadataUtil.getAllSubFieldString((String)"tcsd_rule_yshtpz"), (QFilter[])new QFilter[]{orgFilter, ruletypeFilter, ruleuseFilter, enableFilter});
        allRules.addAll(Arrays.stream(yshtpz).collect(Collectors.toList()));
        DynamicObject[] cqzysj = BusinessDataServiceHelper.load((String)"tcsd_rule_cqzysj", (String)MetadataUtil.getAllSubFieldString((String)"tcsd_rule_cqzysj"), (QFilter[])new QFilter[]{orgFilter, ruletypeFilter, ruleuseFilter, enableFilter});
        allRules.addAll(Arrays.stream(cqzysj).collect(Collectors.toList()));
        DynamicObject[] zjzb = BusinessDataServiceHelper.load((String)"tcsd_rule_zjzb", (String)MetadataUtil.getAllSubFieldString((String)"tcsd_rule_zjzb"), (QFilter[])new QFilter[]{orgFilter, ruletypeFilter, ruleuseFilter, enableFilter});
        allRules.addAll(Arrays.stream(zjzb).collect(Collectors.toList()));
        ArrayList<QFilter> planQfilters = new ArrayList<QFilter>();
        QFilter sharingOrg = new QFilter("orgentity.orgid", "=", (Object)Long.parseLong(orgId));
        planQfilters.add(sharingOrg);
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcsd_sharingplan", (String)"ruleentity.ruleid as ruleid, ruleentity.type as type", (QFilter[])planQfilters.toArray(new QFilter[0]));
        Map<String, List<DynamicObject>> groups = sharingRules.stream().collect(Collectors.groupingBy(s -> s.getString("type")));
        Set yshtpzIds = ((List)groups.getOrDefault("yshtpz", new ArrayList())).stream().map(s -> s.getLong("ruleid")).collect(Collectors.toSet());
        QFilter yshtFilter = new QFilter("id", "in", yshtpzIds);
        DynamicObject[] yshtShareCollect = BusinessDataServiceHelper.load((String)"tcsd_rule_yshtpz", (String)MetadataUtil.getAllSubFieldString((String)"tcsd_rule_yshtpz"), (QFilter[])new QFilter[]{yshtFilter, ruleuseFilter, enableFilter});
        allRules.addAll(Arrays.stream(yshtShareCollect).collect(Collectors.toList()));
        Set cqzysjIds = ((List)groups.getOrDefault("cqzysj", new ArrayList())).stream().map(s -> s.getLong("ruleid")).collect(Collectors.toSet());
        QFilter cqzysjFilter = new QFilter("id", "in", cqzysjIds);
        DynamicObject[] qzysjShareCollect = BusinessDataServiceHelper.load((String)"tcsd_rule_cqzysj", (String)MetadataUtil.getAllSubFieldString((String)"tcsd_rule_cqzysj"), (QFilter[])new QFilter[]{cqzysjFilter, ruleuseFilter, enableFilter});
        allRules.addAll(Arrays.stream(qzysjShareCollect).collect(Collectors.toList()));
        Set zjzbIds = ((List)groups.getOrDefault("zjzb", new ArrayList())).stream().map(s -> s.getLong("ruleid")).collect(Collectors.toSet());
        QFilter zjzbFilter = new QFilter("id", "in", zjzbIds);
        DynamicObject[] zjzbShareCollect = BusinessDataServiceHelper.load((String)"tcsd_rule_zjzb", (String)MetadataUtil.getAllSubFieldString((String)"tcsd_rule_zjzb"), (QFilter[])new QFilter[]{zjzbFilter, ruleuseFilter, enableFilter});
        allRules.addAll(Arrays.stream(zjzbShareCollect).collect(Collectors.toList()));
        return allRules;
    }

    private List<Long> findFitTaxItem(Long orgId, Date skssqq, Date skssqz) {
        TaxResult taxResult;
        Boolean yhsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)orgId).getData();
        if (yhsEnable.booleanValue() && (taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgId))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            return ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity").stream().filter(a -> {
                if (Lists.newArrayList((Object[])new String[]{"013", "014"}).contains(a.getString("taxrate.number"))) {
                    return false;
                }
                Date startDate = DateUtils.getFirstDateOfMonth((Date)skssqq);
                Date endDate = DateUtils.getLastDateOfMonth2((Date)skssqz);
                Date effectivedate = a.getDate(EFFECTIVEDATE);
                Date expirydate = a.getDate(EXPIRYDATE);
                if (effectivedate == null || expirydate == null) {
                    return false;
                }
                return effectivedate.compareTo(startDate) <= 0 && expirydate.compareTo(endDate) >= 0;
            }).map(s -> s.getLong("taxrate.id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

