/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.yhs.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.TaxcCustomSourceDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.DiscountHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.accrual.yhs.impl.AbstractYhsAccrualDataServiceImpl;
import kd.taxc.tcret.business.accrual.yhs.impl.QFilterBuilder;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.utils.DynamicUtils;
import kd.taxc.tcret.common.utils.YhsAccrualUtils;
import kd.taxc.tcret.common.utils.YhsUtils;

public class DimensionYhsAccrualDataServiceImpl
extends AbstractYhsAccrualDataServiceImpl {
    private static final String SPLIT = "#";

    @Override
    protected void setAccrualDetailList(DynamicObjectCollection detailList, EngineModel engineModel, List<DynamicObject> rules, List<Long> fitTaxItem) {
        HashMap<String, List<String>> allCollectMap = new HashMap<String, List<String>>();
        if (EmptyCheckUtils.isNotEmpty(rules)) {
            long orgId = Long.parseLong(engineModel.getOrgId());
            String isXxwlqy = (String)engineModel.getCustomValue("isxxwlqy");
            List<DynamicObject> yhsEntityList = YhsUtils.queryYhsEntityList(orgId);
            List<DynamicObject> accountDetailList = this.getYhsRules(engineModel, yhsEntityList, allCollectMap, fitTaxItem, rules);
            this.setDetail(allCollectMap, detailList, accountDetailList, isXxwlqy);
        }
    }

    private List<DynamicObject> getYhsRules(EngineModel engineModel, List<DynamicObject> yhsEntityList, Map<String, List<String>> allCollectMap, List<Long> fitTaxItem, List<DynamicObject> rules) {
        Date skssqq = DateUtils.stringToDate2((String)engineModel.getStartDate());
        Date skssqz = DateUtils.stringToDate2((String)engineModel.getEndDate());
        String isXxwlqy = (String)engineModel.getCustomValue("isxxwlqy");
        ArrayList<DynamicObject> accountDetailList = new ArrayList<DynamicObject>();
        String serialNo = UUID.randomUUID();
        for (DynamicObject rule : rules) {
            DynamicObject subtaxitem;
            String taxitem = rule.getDynamicObject("taxitem").getString("name");
            String subtaxitemid = "0";
            String rate = rule.getDynamicObject("taxitem").getString("taxrate");
            DataEntityPropertyCollection properties = rule.getDynamicObjectType().getProperties();
            if (properties.get((Object)"subtaxitem") != null && null != (subtaxitem = rule.getDynamicObject("subtaxitem")) && skssqz.after(beginDate)) {
                String value = subtaxitem.getString("value");
                if (!StringUtils.isEmpty((Object)value)) {
                    rate = value;
                }
                subtaxitemid = subtaxitem.getString("id");
            }
            String taxrate = rate.replace("\u2030", "");
            DynamicObject deductioncode = rule.getDynamicObject("deductioncode");
            BigDecimal jmrate = DiscountHelper.calculateDiscountRate((DynamicObject)deductioncode, (String)isXxwlqy);
            DynamicObjectCollection ruleSettingList = rule.getDynamicObjectCollection("entryentity");
            if (!fitTaxItem.contains(rule.getLong("taxitem.id"))) {
                ruleSettingList.removeIf(d -> !"tcret_yhs_tax_source_info".equals(d.getDynamicObject("table").getString("entityname")));
            }
            if (EmptyCheckUtils.isEmpty((Object)ruleSettingList)) continue;
            for (DynamicObject ruleSetting : ruleSettingList) {
                long dataSourceId = ruleSetting.getLong("table.id");
                String conditionJson = ruleSetting.getString("conditionjson");
                String advancedConfJson = ruleSetting.getString("advancedconfjson");
                String amountFieldEntity = ruleSetting.getDynamicObject("amountfield").getString("fieldsubname");
                String amountFieldNum = ruleSetting.getDynamicObject("amountfield").getString("fieldname");
                BigDecimal hdRate = YhsAccrualUtils.findHdRateInYhsEntitys(yhsEntityList, taxitem, skssqq, skssqz, ruleSetting.getDynamicObject("table"));
                BigDecimal jsbl = null;
                String datatype = ruleSetting.getString("datatype");
                if ("gjqs".equals(datatype)) {
                    jsbl = ruleSetting.getBigDecimal("jsbl");
                }
                String entityname = ruleSetting.getDynamicObject("table").getString("entityname");
                conditionJson = QFilterBuilder.addDefaultQFilters(conditionJson, rule, entityname);
                List list = TaxcCustomSourceDataServiceHelper.queryGroupBizData((Long)Long.parseLong(engineModel.getOrgId()), (Date)skssqq, (Date)skssqz, (Long)dataSourceId, (String)amountFieldNum, (String)amountFieldEntity, (String)conditionJson, (String)advancedConfJson, (Long)DeclareTaxType.YHS.getBaseTaxId());
                if (!EmptyCheckUtils.isNotEmpty((Object)list)) continue;
                for (Map amountMap : list) {
                    DynamicObject accountDetail = YhsAccountServiceHelper.createAccountDetailDynamicObject("tcret_yhs_sjjt_detail", amountMap, serialNo, engineModel, skssqq, skssqz, rule, ruleSetting);
                    accountDetail.set("taxitem", (Object)taxitem);
                    accountDetail.set("subtaxitem", (Object)subtaxitemid);
                    String deductiontype = deductioncode != null ? deductioncode.getString("deductiontype") : "";
                    accountDetail.set("deductiontype", (Object)deductiontype);
                    String declaretype = rule.getString("declaretype");
                    String taxlimit = YhsAccrualUtils.findPeriodInYhsEntitys(yhsEntityList, taxitem, skssqq, skssqz, declaretype);
                    accountDetail.set("taxlimit", (Object)taxlimit);
                    accountDetailList.add(accountDetail);
                    Long accountorg = amountMap.get("accountorg") != null ? amountMap.get("accountorg") : Long.valueOf(0L);
                    String bizdimensiontype = amountMap.get("bizdimensiontype") != null ? amountMap.get("bizdimensiontype") : "";
                    String bizdimensionname = amountMap.get("bizdimensionname") != null ? amountMap.get("bizdimensionname") : "";
                    String bizdimensionid = amountMap.get("bizdimensionid") != null ? amountMap.get("bizdimensionid") : "";
                    String allCollectMapKey = accountorg + SPLIT + bizdimensiontype + SPLIT + bizdimensionname + SPLIT + bizdimensionid + SPLIT + taxitem + SPLIT + subtaxitemid + SPLIT + deductiontype + SPLIT + taxlimit;
                    if ("tcret_yhs_tax_source_info".equals(entityname)) {
                        accountDetail.set("datasource", (Object)"tcret_yhs_tax_source_info");
                        allCollectMapKey = allCollectMapKey + SPLIT + "tcret_yhs_tax_source_info";
                    }
                    List<String> currentAmountList = YhsAccrualUtils.getAmountList(accountDetail.getBigDecimal("amount"), hdRate, jsbl, taxrate, jmrate);
                    if (allCollectMap.containsKey(allCollectMapKey)) {
                        allCollectMap.put(allCollectMapKey, this.addAmountsIntoTargetList(allCollectMap.get(allCollectMapKey), currentAmountList));
                        continue;
                    }
                    allCollectMap.put(allCollectMapKey, currentAmountList);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])accountDetailList.toArray(new DynamicObject[0]));
        return accountDetailList;
    }

    private void setDetail(Map<String, List<String>> allCollectMap, DynamicObjectCollection detailList, List<DynamicObject> accountDetailList, String isXxwlqy) {
        DataEntityPropertyCollection properties = detailList.getDynamicObjectType().getProperties();
        for (Map.Entry<String, List<String>> entry : allCollectMap.entrySet()) {
            String key = entry.getKey();
            List<String> amountList = entry.getValue();
            String[] keys = key.split(SPLIT);
            DynamicObject rententryentity = detailList.addNew();
            rententryentity.set("accorg", (Object)DynamicUtils.setDynamicObject(properties, "accorg", Long.valueOf(keys[0])));
            rententryentity.set("bizdimensiontype", (Object)DynamicUtils.setDynamicObject(properties, "bizdimensiontype", keys[1]));
            rententryentity.set("bizdimensionname", (Object)keys[2]);
            rententryentity.set("bizdimensionid", (Object)keys[3]);
            String taxitem = keys[4];
            rententryentity.set("taxitem", (Object)taxitem);
            rententryentity.set("subtaxitem", (Object)DynamicUtils.setDynamicObject(properties, "subtaxitem", Long.valueOf(keys[5])));
            String deductiontype = keys[6];
            rententryentity.set("deductiontype", (Object)deductiontype);
            rententryentity.set("taxlimit", (Object)keys[7]);
            BigDecimal jsje = BigDecimalUtil.setScale((Object)amountList.get(0), (int)2);
            rententryentity.set("jsje", (Object)jsje);
            String hdbl = amountList.get(1);
            if (BigDecimalUtil.toBigDecimal((Object)hdbl).compareTo(BigDecimal.ZERO) > 0) {
                rententryentity.set("hdbl", (Object)BigDecimalUtil.setScale((Object)hdbl, (int)2));
            }
            BigDecimal calsource = YhsAccrualUtils.calculateCalSource(jsje, BigDecimalUtil.toBigDecimal((Object)hdbl));
            rententryentity.set("calsource", (Object)calsource);
            rententryentity.set("taxrate", (Object)amountList.get(3));
            BigDecimal ynse = YhsAccrualUtils.calculateYnse(calsource, BigDecimalUtil.toBigDecimal((Object)amountList.get(3)));
            rententryentity.set("ynse", (Object)ynse);
            BigDecimal jmrate = DiscountHelper.calculateDiscountRate((String)deductiontype, (String)isXxwlqy);
            BigDecimal jmse = YhsAccrualUtils.calculateJmse(ynse, jmrate);
            rententryentity.set("jmse", (Object)jmse);
            BigDecimal jtynse = YhsAccrualUtils.calculateJtynse(ynse, jmse, BigDecimal.ZERO);
            rententryentity.set("jtynse", (Object)jtynse);
            if (!key.endsWith("#tcret_yhs_tax_source_info")) continue;
            rententryentity.set("datasource", (Object)"tcret_yhs_tax_source_info");
        }
    }
}

