/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.yhs.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class QFilterBuilder {
    public static String addDefaultQFilters(String conditionJson, DynamicObject rule, String entityname) {
        if ("tcret_yhs_tax_source_info".equals(entityname)) {
            Map<String, List> filterConditionMap = new HashMap();
            if (EmptyCheckUtils.isNotEmpty((Object)conditionJson)) {
                filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionJson, Map.class);
            }
            List filterRows = filterConditionMap.getOrDefault("FilterRow", new ArrayList());
            filterRows.add(QFilterBuilder.createSimpleFilterRow("isxgm", "0"));
            if (rule.containsProperty("taxitem")) {
                filterRows.add(QFilterBuilder.createSimpleFilterRow("taxitem", rule.getString("taxitem.id")));
            }
            if (rule.containsProperty("subtaxitem") && EmptyCheckUtils.isNotEmpty((Object)rule.getString("subtaxitem.id"))) {
                filterRows.add(QFilterBuilder.createSimpleFilterRow("subtaxitem", rule.getString("subtaxitem.id")));
            } else {
                filterRows.add(QFilterBuilder.createSimpleFilterRow("subtaxitem", "0"));
            }
            filterConditionMap.put("_Type_", (List)((Object)"FilterCondition"));
            filterConditionMap.put("FilterRow", filterRows);
            return SerializationUtils.toJsonString(filterConditionMap);
        }
        return conditionJson;
    }

    private static Map<String, Object> createSimpleFilterRow(String fieldName, Object value) {
        LinkedHashMap<String, Object> simpleFilterRow = new LinkedHashMap<String, Object>();
        simpleFilterRow.put("_Type_", "SimpleFilterRow");
        simpleFilterRow.put("Id", Uuid16.create().toString());
        simpleFilterRow.put("RightBracket", "");
        simpleFilterRow.put("LeftBracket", "");
        ArrayList values = new ArrayList();
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        valueMap.put("_Type_", "FilterValue");
        valueMap.put("Value", value);
        valueMap.put("Id", Uuid16.create().toString());
        values.add(valueMap);
        simpleFilterRow.put("Value", values);
        simpleFilterRow.put("CompareType", "105");
        simpleFilterRow.put("Logic", "0");
        simpleFilterRow.put("FieldName", fieldName);
        return simpleFilterRow;
    }
}

