/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.compare.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.compare.CompareCalcService;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.utils.DynamicUtils;
import org.apache.commons.collections.CollectionUtils;

public class FcsTdsCompareCalcServiceImpl
implements CompareCalcService {
    private static final String SEPARATE = "_";

    @Override
    public DynamicObjectCollection doCalcCompareDetails(DynamicObject compareObj) {
        DynamicObjectCollection detailList = compareObj.getDynamicObjectCollection("entryentity");
        String drafttype = compareObj.getString("drafttype");
        boolean isdimprovision = false;
        String provisiondimension = null;
        Date skssqq = compareObj.getDate("skssqq");
        Date skssqz = compareObj.getDate("skssqz");
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(compareObj.getLong("org.id")), (Long)("fcs_bd".equals(drafttype) ? 7L : 9L), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz);
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData()))) {
            DynamicObjectCollection dataList = (DynamicObjectCollection)taxResult.getData();
            DynamicObject object = (DynamicObject)dataList.get(0);
            isdimprovision = object.getBoolean("ruleentity.rule.isdimprovision");
            provisiondimension = object.getString("ruleentity.rule.provisiondimension");
        }
        Long defaultAccountOrg = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)compareObj.getLong("org.id")).getData();
        if ("fcs_bd".equals(drafttype)) {
            this.calFcsList(compareObj, detailList, isdimprovision, provisiondimension, defaultAccountOrg);
        } else if ("cztdsys_bd".equals(drafttype)) {
            this.calTdsList(compareObj, detailList, isdimprovision, provisiondimension, defaultAccountOrg);
        }
        return detailList;
    }

    private void calFcsList(DynamicObject compareObj, DynamicObjectCollection detailList, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg) {
        detailList.clear();
        DynamicObjectCollection jtPriceDetail = this.findJtDetail(compareObj, FcsTypeEnum.FCS_BY_PRICE, defaultAccountOrg);
        DynamicObjectCollection jtHireDetail = this.findJtDetail(compareObj, FcsTypeEnum.FCS_BY_HIRE, defaultAccountOrg);
        DynamicObjectCollection sbbPriceDetail = this.findSbbDetail(compareObj, FcsTypeEnum.FCS_BY_PRICE, defaultAccountOrg);
        DynamicObjectCollection sbbHireDetail = this.findSbbDetail(compareObj, FcsTypeEnum.FCS_BY_HIRE, defaultAccountOrg);
        Map<String, List<DynamicObject>> jtPriceGroup = jtPriceDetail.stream().collect(Collectors.groupingBy(this.jtGroupByFunction(isdimprovision, provisiondimension)));
        Map<String, List<DynamicObject>> jtHireGroup = jtHireDetail.stream().collect(Collectors.groupingBy(this.jtGroupByFunction(isdimprovision, provisiondimension)));
        Map<String, List<DynamicObject>> sbbPriceGroup = sbbPriceDetail.stream().collect(Collectors.groupingBy(this.sbbGroupByFunction(isdimprovision, provisiondimension, FcsTypeEnum.FCS_BY_PRICE, "sourceid.accountorg")));
        Map<String, List<DynamicObject>> sbbHireGroup = sbbHireDetail.stream().collect(Collectors.groupingBy(this.sbbGroupByFunction(isdimprovision, provisiondimension, FcsTypeEnum.FCS_BY_HIRE, "sourceid.accorg")));
        this.createFcsDetail(FcsTypeEnum.FCS_BY_PRICE, jtPriceDetail, sbbPriceDetail, isdimprovision, provisiondimension, defaultAccountOrg, jtPriceGroup, sbbPriceGroup, detailList);
        this.createFcsDetail(FcsTypeEnum.FCS_BY_HIRE, jtHireDetail, sbbHireDetail, isdimprovision, provisiondimension, defaultAccountOrg, jtHireGroup, sbbHireGroup, detailList);
    }

    private void calTdsList(DynamicObject compareObj, DynamicObjectCollection detailList, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg) {
        DynamicObjectCollection jtDetail = this.findJtDetail(compareObj, FcsTypeEnum.TDS, defaultAccountOrg);
        DynamicObjectCollection sbbDetail = this.findSbbDetail(compareObj, FcsTypeEnum.TDS, defaultAccountOrg);
        Map<String, List<DynamicObject>> jtGroup = jtDetail.stream().collect(Collectors.groupingBy(this.jtGroupByFunction(isdimprovision, provisiondimension)));
        Map<String, List<DynamicObject>> sbbGroup = sbbDetail.stream().collect(Collectors.groupingBy(this.sbbGroupByFunction(isdimprovision, provisiondimension, FcsTypeEnum.TDS, "sourceid.accountorg")));
        this.createTdsDetail(jtDetail, sbbDetail, isdimprovision, provisiondimension, defaultAccountOrg, jtGroup, sbbGroup, detailList);
    }

    private void createFcsDetail(FcsTypeEnum typeEnum, DynamicObjectCollection jtDetail, DynamicObjectCollection sbbDetail, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg, Map<String, List<DynamicObject>> jtGroup, Map<String, List<DynamicObject>> sbbGroup, DynamicObjectCollection detailList) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(jtGroup.keySet());
        keys.addAll(sbbGroup.keySet());
        Set<Long> sourceIds = jtDetail.stream().map(a -> a.getLong("taxsourceid")).collect(Collectors.toSet());
        sourceIds.addAll(sbbDetail.stream().map(a -> a.getLong("sourceid")).collect(Collectors.toSet()));
        Map<Long, DynamicObject> sourcesMap = this.findSource(sourceIds, typeEnum.getSourceEntity());
        DataEntityPropertyCollection properties = detailList.getDynamicObjectType().getProperties();
        for (String key : keys) {
            Optional<DynamicObject> optional;
            List<DynamicObject> sbbEntityList;
            DynamicObject entity = detailList.addNew();
            List<DynamicObject> jtEntityList = jtGroup.get(key);
            if (EmptyCheckUtils.isNotEmpty(jtEntityList)) {
                DynamicObject jtEntity = jtEntityList.get(0);
                this.setEntityByJt(properties, entity, jtEntityList, isdimprovision, provisiondimension, defaultAccountOrg);
                entity.set("projectnumber", (Object)DynamicUtils.setDynamicObject(properties, "projectnumber", jtEntity.getLong("taxsourceid")));
                if (sourcesMap.get(jtEntity.getLong("taxsourceid")) != null) {
                    entity.set("taxoffice", sourcesMap.get(jtEntity.getLong("taxsourceid")).get("taxauthority"));
                    entity.set("itemnumber", sourcesMap.get(jtEntity.getLong("taxsourceid")).get("number"));
                    entity.set("projectname", sourcesMap.get(jtEntity.getLong("taxsourceid")).get("name"));
                    if (FcsTypeEnum.FCS_BY_HIRE == typeEnum) {
                        entity.set("projectnumber", sourcesMap.get(jtEntity.getLong("taxsourceid")).get("fcsbasicinfo"));
                        entity.set("itemnumber", sourcesMap.get(jtEntity.getLong("taxsourceid")).get("leasecontractno"));
                        entity.set("projectname", sourcesMap.get(jtEntity.getLong("taxsourceid")).get("fcsbasicinfo.name"));
                    }
                }
            }
            if (EmptyCheckUtils.isNotEmpty(sbbEntityList = sbbGroup.get(key)) && (optional = sbbEntityList.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getString("taxlimit"))).findFirst()).isPresent()) {
                DynamicObject sbbEntity = optional.get();
                this.setEntityBySbb(properties, entity, sbbEntityList, sbbEntity, isdimprovision, provisiondimension, defaultAccountOrg, typeEnum);
                entity.set("projectnumber", (Object)DynamicUtils.setDynamicObject(properties, "projectnumber", sbbEntity.getLong("sourceid")));
                if (FcsTypeEnum.FCS_BY_HIRE == typeEnum) {
                    entity.set("projectnumber", (Object)DynamicUtils.setDynamicObject(properties, "projectnumber", sbbEntity.getLong("sourceid.fcsbasicinfo")));
                }
                if (sourcesMap.get(sbbEntity.getLong("sourceid")) != null) {
                    entity.set("taxoffice", sourcesMap.get(sbbEntity.getLong("sourceid")).get("taxauthority"));
                    entity.set("itemnumber", sourcesMap.get(sbbEntity.getLong("sourceid")).get("number"));
                    entity.set("projectname", sourcesMap.get(sbbEntity.getLong("sourceid")).get("name"));
                    if (FcsTypeEnum.FCS_BY_HIRE == typeEnum) {
                        entity.set("itemnumber", sourcesMap.get(sbbEntity.getLong("sourceid")).get("leasecontractno"));
                        entity.set("projectname", sourcesMap.get(sbbEntity.getLong("sourceid")).get("fcsbasicinfo.name"));
                    }
                }
            }
            entity.set("btse", (Object)BigDecimalUtil.subtractObject((Object)entity.getBigDecimal("sbse"), (Object)entity.getBigDecimal("jtse")));
        }
    }

    private void createTdsDetail(DynamicObjectCollection jtDetail, DynamicObjectCollection sbbDetail, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg, Map<String, List<DynamicObject>> jtGroup, Map<String, List<DynamicObject>> sbbGroup, DynamicObjectCollection detailList) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(jtGroup.keySet());
        keys.addAll(sbbGroup.keySet());
        Set<Long> sourceIds = jtDetail.stream().map(a -> a.getLong("taxsourceid")).collect(Collectors.toSet());
        sourceIds.addAll(sbbDetail.stream().map(a -> a.getLong("sourceid")).collect(Collectors.toSet()));
        Map<Long, DynamicObject> sourcesMap = this.findSource(sourceIds, "tdm_tds_basic_info");
        DataEntityPropertyCollection properties = detailList.getDynamicObjectType().getProperties();
        detailList.clear();
        for (String key : keys) {
            Optional<DynamicObject> optional;
            List<DynamicObject> sbbEntityList;
            DynamicObject entity = detailList.addNew();
            List<DynamicObject> jtEntityList = jtGroup.get(key);
            if (EmptyCheckUtils.isNotEmpty(jtEntityList)) {
                DynamicObject jtEntity = jtEntityList.get(0);
                this.setEntityByJt(properties, entity, jtEntityList, isdimprovision, provisiondimension, defaultAccountOrg);
                entity.set("taxoffice", sourcesMap.get(jtEntity.getLong("taxsourceid")) == null ? Long.valueOf(0L) : sourcesMap.get(jtEntity.getLong("taxsourceid")).get("taxauthority"));
                entity.set("landnumber", (Object)DynamicUtils.setDynamicObject(properties, "landnumber", jtEntity.getLong("taxsourceid")));
                entity.set("projectname", sourcesMap.get(jtEntity.getLong("taxsourceid")) == null ? " " : sourcesMap.get(jtEntity.getLong("taxsourceid")).get("name"));
            }
            if (EmptyCheckUtils.isNotEmpty(sbbEntityList = sbbGroup.get(key)) && (optional = sbbEntityList.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getString("taxlimit"))).findFirst()).isPresent()) {
                DynamicObject sbbEntity = optional.get();
                this.setEntityBySbb(properties, entity, sbbEntityList, sbbEntity, isdimprovision, provisiondimension, defaultAccountOrg, FcsTypeEnum.TDS);
                entity.set("taxoffice", sourcesMap.get(sbbEntity.getLong("sourceid")) == null ? Long.valueOf(0L) : sourcesMap.get(sbbEntity.getLong("sourceid")).get("taxauthority"));
                entity.set("landnumber", (Object)DynamicUtils.setDynamicObject(properties, "landnumber", sbbEntity.getLong("sourceid")));
                entity.set("projectname", sourcesMap.get(sbbEntity.getLong("sourceid")) == null ? " " : sourcesMap.get(sbbEntity.getLong("sourceid")).get("name"));
            }
            entity.set("btse", (Object)BigDecimalUtil.subtractObject((Object)entity.getBigDecimal("sbse"), (Object)entity.getBigDecimal("jtse")));
        }
    }

    private void setEntityByJt(DataEntityPropertyCollection properties, DynamicObject entity, List<DynamicObject> jtEntityList, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg) {
        DynamicObject jtEntity = jtEntityList.get(0);
        entity.set("taxitem", (Object)jtEntity.getString("taxitem"));
        entity.set("taxlimit", (Object)jtEntity.getString("taxlimit"));
        if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
            entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", jtEntity.getLong("accountorg")));
        } else {
            entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", defaultAccountOrg));
        }
        if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
            entity.set("bizdimensiontype", (Object)DynamicUtils.setDynamicObject(properties, "bizdimensiontype", jtEntity.getString("bizdimensiontype")));
            entity.set("bizdimensionname", (Object)jtEntity.getString("bizdimensionname"));
            entity.set("bizdimensionid", (Object)jtEntity.getString("bizdimensionid"));
        }
        entity.set("jtse", (Object)BigDecimalUtil.sumDynamicObjectAmount(jtEntityList, (String)"jtynse"));
    }

    private void setEntityBySbb(DataEntityPropertyCollection properties, DynamicObject entity, List<DynamicObject> sbbEntityList, DynamicObject sbbEntity, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg, FcsTypeEnum typeEnum) {
        if (FcsTypeEnum.TDS == typeEnum) {
            entity.set("taxitem", (Object)sbbEntity.getString("landlevel"));
        } else if (FcsTypeEnum.FCS_BY_PRICE == typeEnum) {
            entity.set("taxitem", (Object)ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsTdsCompareCalcServiceImpl_0", (String)"taxc-tcret", (Object[])new Object[0]));
        } else if (FcsTypeEnum.FCS_BY_HIRE == typeEnum) {
            entity.set("taxitem", (Object)ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsTdsCompareCalcServiceImpl_1", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        entity.set("taxlimit", (Object)sbbEntity.getString("taxlimit"));
        if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
            entity.set("bizdimensiontype", (Object)DynamicUtils.setDynamicObject(properties, "bizdimensiontype", sbbEntity.getString("sourceid.bizdimensiontype")));
            entity.set("bizdimensionname", (Object)sbbEntity.getString("sourceid.bizdimensionname"));
            entity.set("bizdimensionid", (Object)sbbEntity.getString("sourceid.bizdimensionid"));
        }
        if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
            if (sbbEntity.containsProperty("sourceid.accountorg")) {
                entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", sbbEntity.getLong("sourceid.accountorg")));
            } else {
                entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", sbbEntity.getLong("sourceid.accorg")));
            }
        } else {
            entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", defaultAccountOrg));
        }
        entity.set("sbse", (Object)this.calSbse(sbbEntityList));
    }

    private BigDecimal calSbse(List<DynamicObject> sbbEntityList) {
        List notXgmList = sbbEntityList.stream().filter(e -> !e.getBoolean("isxgm")).collect(Collectors.toList());
        List xgmList = sbbEntityList.stream().filter(e -> e.getBoolean("isxgm")).collect(Collectors.toList());
        BigDecimal sbseNotXgm = notXgmList.stream().map(a -> a.getBigDecimal("currentpayable").subtract(a.getBigDecimal("currentjmamount"))).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal jmseXgm = xgmList.stream().map(a -> a.getBigDecimal("currentjmamount")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return sbseNotXgm.subtract(jmseXgm);
    }

    private Function<DynamicObject, String> jtGroupByFunction(boolean isdimprovision, String provisiondimension) {
        return a -> {
            String key = a.getString("taxsourceid") + SEPARATE + a.getString("taxitem");
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
                key = key + SEPARATE + a.getString("accountorg");
            }
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
                key = key + SEPARATE + a.getString("bizdimensiontype") + SEPARATE + a.getString("bizdimensionname");
            }
            return key;
        };
    }

    private Function<DynamicObject, String> sbbGroupByFunction(boolean isdimprovision, String provisiondimension, FcsTypeEnum typeEnum, String accorgName) {
        return a -> {
            StringBuilder sb = new StringBuilder();
            sb.append(a.getString("sourceid")).append(SEPARATE);
            if (FcsTypeEnum.TDS == typeEnum) {
                sb.append(a.getString("landlevel"));
            } else if (FcsTypeEnum.FCS_BY_PRICE == typeEnum) {
                sb.append(ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsTdsCompareCalcServiceImpl_0", (String)"taxc-tcret", (Object[])new Object[0]));
            } else {
                sb.append(ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsTdsCompareCalcServiceImpl_1", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
                sb.append(SEPARATE).append(a.getString(accorgName));
            }
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
                sb.append(SEPARATE).append(a.getString("sourceid.bizdimensiontype")).append(SEPARATE).append(a.getString("sourceid.bizdimensionname"));
            }
            return sb.toString();
        };
    }

    private DynamicObjectCollection findJtDetail(DynamicObject compareObj, FcsTypeEnum typeEnum, Long defaultAccountOrg) {
        String selectFields = "entryentity.taxitem as taxitem,entryentity.taxlimit as taxlimit,entryentity.accorg as accountorg,entryentity.jtynse as jtynse,entryentity.bizdimensiontype as bizdimensiontype,entryentity.bizdimensionname as bizdimensionname,entryentity.bizdimensionid as bizdimensionid,entryentity.taxsourceid as taxsourceid,entryentity.projectname as projectname";
        QFilter q1 = new QFilter("org", "=", compareObj.get("org.id"));
        QFilter q2 = new QFilter("skssqq", ">=", compareObj.get("skssqq"));
        QFilter q3 = new QFilter("skssqz", "<=", compareObj.get("skssqz"));
        QFilter q4 = new QFilter("entryentity.taxlimit", "=", compareObj.get("frequency"));
        QFilter q5 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q6 = new QFilter("taxtype", "=", (Object)typeEnum.getTaxCategory());
        if (FcsTypeEnum.FCS_BY_PRICE == typeEnum) {
            q6.and(new QFilter("entryentity.taxitem", "=", (Object)ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsTdsCompareCalcServiceImpl_0", (String)"taxc-tcret", (Object[])new Object[0])));
        } else if (FcsTypeEnum.FCS_BY_HIRE == typeEnum) {
            q6.and(new QFilter("entryentity.taxitem", "=", (Object)ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsTdsCompareCalcServiceImpl_1", (String)"taxc-tcret", (Object[])new Object[0])));
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tcret_fcs_accrual_draft", (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
        dynamicObjectCollection.forEach(a -> {
            if (a.getLong("accountorg") == 0L) {
                a.set("accountorg", (Object)defaultAccountOrg);
            }
        });
        return dynamicObjectCollection;
    }

    private DynamicObjectCollection findSbbDetail(DynamicObject compareObj, FcsTypeEnum typeEnum, Long defaultAccountOrg) {
        String selectFields = "id,sourceid,number,name,taxlimit,currentpayable,currentjmamount,sourceid.bizdimensiontype,sourceid.bizdimensionname,isxgm";
        QFilter q1 = new QFilter("org", "=", compareObj.get("org.id"));
        QFilter q2 = new QFilter("entryentity.startdate", ">=", compareObj.get("skssqq"));
        QFilter q3 = new QFilter("entryentity.enddate", "<=", compareObj.get("skssqz"));
        QFilter q4 = new QFilter("entryentity.taxtype", "in", (Object)(FcsTypeEnum.TDS == typeEnum ? "cztdsys" : "fcs"));
        QFilter q5 = new QFilter("declarestatus", "=", (Object)"declared");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tcret_query_report", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        List sbbIds = dynamicObjectCollection.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
        if (FcsTypeEnum.TDS == typeEnum) {
            selectFields = selectFields + ",sourceid.accountorg,landlevel";
        } else if (FcsTypeEnum.FCS_BY_PRICE == typeEnum) {
            selectFields = selectFields + ",sourceid.accountorg";
        } else if (FcsTypeEnum.FCS_BY_HIRE == typeEnum) {
            selectFields = selectFields + ",sourceid.accorg,sourceid.fcsbasicinfo";
        }
        QFilter dateFilter = new QFilter("skssqq", ">=", compareObj.get("skssqq")).and(new QFilter("skssqz", "<=", compareObj.get("skssqz")));
        QFilter sbbFilter = new QFilter("sbbid", "in", sbbIds);
        QFilter xgmFilter = new QFilter("isxgm", "=", (Object)false);
        QFilter taxlimitFilter = new QFilter("taxlimit", "=", (Object)compareObj.getString("frequency"));
        DynamicObjectCollection taxsources = QueryServiceHelper.query((String)typeEnum.getEntityName(), (String)selectFields, (QFilter[])new QFilter[]{sbbFilter, dateFilter, taxlimitFilter, xgmFilter});
        Set ids = taxsources.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        Set sourceids = taxsources.stream().map(a -> a.getLong("sourceid")).collect(Collectors.toSet());
        QFilter xgmFilter1 = new QFilter("isxgm", "=", (Object)true);
        DynamicObjectCollection taxsources1 = QueryServiceHelper.query((String)typeEnum.getEntityName(), (String)selectFields, (QFilter[])new QFilter[]{sbbFilter, dateFilter, xgmFilter1, new QFilter("sourceid", "in", sourceids), new QFilter("id", "not in", ids)});
        taxsources.addAll((Collection)taxsources1);
        taxsources.forEach(a -> {
            if (a.containsProperty("sourceid.accountorg") && a.getLong("sourceid.accountorg") == 0L) {
                a.set("sourceid.accountorg", (Object)defaultAccountOrg);
            } else if (a.containsProperty("sourceid.accorg") && a.getLong("sourceid.accorg") == 0L) {
                a.set("sourceid.accorg", (Object)defaultAccountOrg);
            }
        });
        return taxsources;
    }

    private Map<Long, DynamicObject> findSource(Set<Long> sourceidSet, String entityname) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])sourceidSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityname));
        Map<Long, DynamicObject> idMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(a -> a.getLong("id"), b -> b, (m, n) -> m));
        return idMap;
    }
}

