/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.compare.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.compare.CompareCalcService;
import kd.taxc.tcret.common.utils.DynamicUtils;
import org.apache.commons.collections.CollectionUtils;

public class YhsCompareCalcServiceImpl
implements CompareCalcService {
    private static final String SPLIT = "#";
    private static final String YHS_ACCRUAL_ENTITY_FIELDS = "entryentity.taxitem as taxitem,entryentity.taxlimit as taxlimit,entryentity.accorg as accountorg,entryentity.jtynse as jtynse,entryentity.bizdimensiontype as bizdimensiontype,entryentity.bizdimensionname as bizdimensionname,entryentity.bizdimensionid as bizdimensionid";
    private static final String YHS_PAY_RECORD_ENTITY_FIELDS = "skssqq,skssqz,entryentity.taxitem as taxitem,entryentity.yjjemx as yjjemx,entryentity.accorg as accountorg,entryentity.bizdimensiontype as bizdimensiontype,entryentity.bizdimensionname as bizdimensionname,entryentity.bizdimensionid as bizdimensionid";

    @Override
    public DynamicObjectCollection doCalcCompareDetails(DynamicObject compareObj) {
        long orgId = compareObj.getLong("org.id");
        Date skssqq = compareObj.getDate("skssqq");
        Date skssqz = compareObj.getDate("skssqz");
        String frequency = compareObj.getString("frequency");
        boolean isdimprovision = false;
        String provisiondimension = null;
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)BaseTaxCategory.YHS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz);
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData()))) {
            DynamicObjectCollection dataList = (DynamicObjectCollection)taxResult.getData();
            DynamicObject object = (DynamicObject)dataList.get(0);
            isdimprovision = object.getBoolean("ruleentity.rule.isdimprovision");
            provisiondimension = object.getString("ruleentity.rule.provisiondimension");
        }
        Long defaultAccountOrg = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)orgId).getData();
        List<DynamicObject> yhsAccrualEntryEntities = this.queryYhsAccrualEntryEntities(frequency, orgId, skssqq, skssqz);
        Map<String, List<DynamicObject>> yhsAccrualEntryEntityMap = yhsAccrualEntryEntities.stream().collect(Collectors.groupingBy(this.getYhsEntryEntityGroupFunction(isdimprovision, provisiondimension, false)));
        List<DynamicObject> yhsPayRecordEntryEntities = this.queryYhsPayRecordEntryEntities(frequency, orgId, skssqq, skssqz);
        Map<String, List<DynamicObject>> yhsPayRecordEntityMap = yhsPayRecordEntryEntities.stream().collect(Collectors.groupingBy(this.getYhsEntryEntityGroupFunction(isdimprovision, provisiondimension, true)));
        return this.setCompareEntryEntities(compareObj, isdimprovision, provisiondimension, defaultAccountOrg, yhsAccrualEntryEntityMap, yhsPayRecordEntityMap);
    }

    private Function<DynamicObject, String> getYhsEntryEntityGroupFunction(boolean isdimprovision, String provisiondimension, boolean calculateTaxLimitBySkssq) {
        return d -> {
            String key = calculateTaxLimitBySkssq ? d.getString("taxitem") + SPLIT + DateUtils.getTaxLimit((Date)d.getDate("skssqq"), (Date)d.getDate("skssqz")) : d.getString("taxitem") + SPLIT + d.getString("taxlimit");
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
                key = key + SPLIT + d.getString("accountorg");
            }
            if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
                key = key + SPLIT + d.getString("bizdimensiontype") + SPLIT + d.getString("bizdimensionname");
            }
            return key;
        };
    }

    private DynamicObjectCollection setCompareEntryEntities(DynamicObject compareObj, boolean isdimprovision, String provisiondimension, Long defaultAccountOrg, Map<String, List<DynamicObject>> yhsAccrualEntryEntityMap, Map<String, List<DynamicObject>> yhsPayRecordEntityMap) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(yhsAccrualEntryEntityMap.keySet());
        keys.addAll(yhsPayRecordEntityMap.keySet());
        DynamicObjectCollection entryentity = compareObj.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = entryentity.getDynamicObjectType().getProperties();
        entryentity.clear();
        for (String key : keys) {
            List<DynamicObject> yhsPayRecordEntryEntityList;
            DynamicObject entity = entryentity.addNew();
            List<DynamicObject> yhsAccrualEntryEntityList = yhsAccrualEntryEntityMap.get(key);
            if (EmptyCheckUtils.isNotEmpty(yhsAccrualEntryEntityList)) {
                DynamicObject yhsAccrualEntryEntity = yhsAccrualEntryEntityList.get(0);
                entity.set("taxitem", (Object)yhsAccrualEntryEntity.getString("taxitem"));
                entity.set("taxlimit", (Object)yhsAccrualEntryEntity.getString("taxlimit"));
                if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
                    entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", yhsAccrualEntryEntity.getLong("accountorg")));
                } else {
                    entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", defaultAccountOrg));
                }
                if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
                    entity.set("bizdimensiontype", (Object)DynamicUtils.setDynamicObject(properties, "bizdimensiontype", yhsAccrualEntryEntity.getString("bizdimensiontype")));
                    entity.set("bizdimensionname", (Object)yhsAccrualEntryEntity.getString("bizdimensionname"));
                    entity.set("bizdimensionid", (Object)yhsAccrualEntryEntity.getString("bizdimensionid"));
                }
                entity.set("jtse", (Object)BigDecimalUtil.sumDynamicObjectAmount(yhsAccrualEntryEntityList, (String)"jtynse"));
            }
            if (EmptyCheckUtils.isNotEmpty(yhsPayRecordEntryEntityList = yhsPayRecordEntityMap.get(key))) {
                DynamicObject yhsPayRecordEntryEntity = yhsPayRecordEntryEntityList.get(0);
                entity.set("taxitem", (Object)yhsPayRecordEntryEntity.getString("taxitem"));
                if (EmptyCheckUtils.isEmpty((Object)entity.getString("taxlimit"))) {
                    entity.set("taxlimit", (Object)DateUtils.getTaxLimit((Date)yhsPayRecordEntryEntity.getDate("skssqq"), (Date)yhsPayRecordEntryEntity.getDate("skssqz")));
                }
                if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("businessdimension")) {
                    entity.set("bizdimensiontype", (Object)DynamicUtils.setDynamicObject(properties, "bizdimensiontype", yhsPayRecordEntryEntity.getString("bizdimensiontype")));
                    entity.set("bizdimensionname", (Object)yhsPayRecordEntryEntity.getString("bizdimensionname"));
                    entity.set("bizdimensionid", (Object)yhsPayRecordEntryEntity.getString("bizdimensionid"));
                }
                if (isdimprovision && EmptyCheckUtils.isNotEmpty((Object)provisiondimension) && provisiondimension.contains("accountorg")) {
                    entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", yhsPayRecordEntryEntity.getLong("accountorg")));
                } else {
                    entity.set("accountorg", (Object)DynamicUtils.setDynamicObject(properties, "accountorg", defaultAccountOrg));
                }
                entity.set("sbse", (Object)BigDecimalUtil.sumDynamicObjectAmount(yhsPayRecordEntryEntityList, (String)"yjjemx"));
            }
            entity.set("btse", (Object)BigDecimalUtil.subtractObject((Object)entity.getBigDecimal("sbse"), (Object)entity.getBigDecimal("jtse")));
        }
        return entryentity;
    }

    private List<DynamicObject> queryYhsPayRecordEntryEntities(String frequency, long orgId, Date skssqq, Date skssqz) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz);
        if ("year".equals(frequency)) {
            q2 = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        }
        QFilter q3 = new QFilter("taxtype", "=", (Object)"yhs");
        QFilter q4 = new QFilter("entryentity.taxitem", "is not null", null);
        return QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)YHS_PAY_RECORD_ENTITY_FIELDS, (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    private List<DynamicObject> queryYhsAccrualEntryEntities(String frequency, long orgId, Date skssqq, Date skssqz) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz);
        QFilter q3 = new QFilter("taxtype", "=", (Object)BaseTaxCategory.YHS);
        QFilter q4 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q5 = new QFilter("entryentity.taxlimit", "=", (Object)frequency);
        if ("season".equals(frequency)) {
            q5.or("entryentity.taxlimit", "=", (Object)"single");
        }
        return QueryServiceHelper.query((String)"tcret_yhs_acccrual", (String)YHS_ACCRUAL_ENTITY_FIELDS, (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
    }
}

