/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.mq.datasynchronize.DataSynchronizeMQSender;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.tcret.business.declare.DeclareItemServiceHelper;
import kd.taxc.tcret.business.declare.RequestValidator;
import kd.taxc.tcret.business.declare.engine.EngineModelBuilder;
import kd.taxc.tcret.business.draft.DraftDateService;
import kd.taxc.tcret.business.draft.DraftWriteBackService;
import kd.taxc.tcret.common.enums.TcretTaxTypeEnum;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;
import org.apache.commons.lang.StringUtils;

public class DeclareServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(DeclareServiceHelper.class);
    private static final String YWJSFA_ENBALE = "1";

    public static Map<String, Object> generate(DeclareRequest requestVo) {
        EngineModel engineModel = EngineModelBuilder.buildEngineModel(requestVo);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        DynamicObjectCollection declareItemList = DeclareItemServiceHelper.queryList(engineModel.getCustom());
        if (EmptyCheckUtils.isEmpty((Object)declareItemList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f85\u7533\u62a5\u9879\u76ee\uff0c\u65e0\u6cd5\u751f\u6210\u7533\u62a5\u8868", (String)"DeclareServiceHelper_0", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        List<String> taxTypeList = DraftDateService.getTaxTypesByDeclareItemCollection(declareItemList);
        List<String> draftTaxTypeList = DraftDateService.getDraftTaxTypes(taxTypeList);
        String declareMonth = (String)engineModel.getValue("declaremonth");
        String taxoffice = (String)engineModel.getValue("taxoffice");
        DynamicObjectCollection collection = PbtDeclareUtil.queryAllRecord(OperationStatus.VIEW, engineModel.getOrgId(), declareMonth, taxoffice);
        ArrayList<DynamicObject> taxTypes = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : declareItemList) {
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                DynamicObject col = collection.stream().filter(e -> e.getString("taxtype").equals(dynamicObject.getString("taxtype"))).findFirst().orElse(null);
                if (col != null) continue;
                taxTypes.add(dynamicObject);
                continue;
            }
            taxTypes.add(dynamicObject);
        }
        List<String> noYwjsfaList = DraftDateService.getNoYwjsfaList(Long.parseLong(requestVo.getOrgId()), taxTypes);
        String ywjsfa = "";
        if (CollectionUtils.isEmpty(noYwjsfaList)) {
            ywjsfa = YWJSFA_ENBALE;
        }
        if (!CollectionUtils.isEmpty(noYwjsfaList) && noYwjsfaList.size() == taxTypeList.size()) {
            noYwjsfaList = new ArrayList<String>(0);
        }
        ArrayList<String> noYwjsfaNameList = new ArrayList<String>(noYwjsfaList.size());
        if (!CollectionUtils.isEmpty(noYwjsfaList) && Boolean.TRUE.equals(requestVo.getCombineDeclare())) {
            for (String noYwjsfa : noYwjsfaList) {
                for (DynamicObject obj : declareItemList) {
                    if (!noYwjsfa.equals(obj.get("taxtype"))) continue;
                    noYwjsfaNameList.add(((ComboProp)obj.getDynamicObjectType().getProperty("taxtype")).getItemByName(noYwjsfa));
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7533\u62a5\u9879\u76ee%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u8ba1\u7a0e\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7533\u62a5\u9879\u76ee\u3002", (String)"PbtDeclareHomePlugin_36", (String)"taxc-tcret", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(noYwjsfaNameList)));
        }
        if (Boolean.TRUE.equals(requestVo.getCombineDeclare())) {
            DeclareServiceHelper.generate(true, engineModel, (List<DynamicObject>)declareItemList, ywjsfa, draftTaxTypeList);
        } else {
            boolean success = false;
            boolean containTaxcatetory = false;
            Map<String, List<DynamicObject>> groupedDeclareItems = declareItemList.stream().collect(Collectors.groupingBy(DeclareServiceHelper.getItemGroupFunction()));
            for (Map.Entry<String, List<DynamicObject>> entry : groupedDeclareItems.entrySet()) {
                List taxcatetoryList;
                if (StringUtils.isNotBlank((String)requestVo.getTaxcatetory()) && !(taxcatetoryList = Arrays.stream(requestVo.getTaxcatetory().split(",")).collect(Collectors.toList())).contains(TcretTaxTypeEnum.getBaseTaxIdByCategory(entry.getKey()))) continue;
                List<DynamicObject> declareItems = entry.getValue();
                boolean generated = DeclareServiceHelper.generate(false, engineModel, declareItems, ywjsfa, draftTaxTypeList);
                success = Boolean.logicalOr(success, generated);
                containTaxcatetory = true;
            }
            if (!success) {
                if (!containTaxcatetory) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f85\u7533\u62a5\u9879\u76ee\uff0c\u65e0\u6cd5\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"DeclareServiceHelper_3", (String)"taxc-tcret", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7533\u62a5\u8868\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210\u3002", (String)"DeclareServiceHelper_1", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
        paramsMap.put("skssqq", DateUtils.stringToDate((String)engineModel.getStartDate()));
        paramsMap.put("skssqz", DateUtils.stringToDate((String)engineModel.getEndDate()));
        return paramsMap;
    }

    private static boolean generate(boolean combineDeclare, EngineModel engineModel, List<DynamicObject> declareItemList, String ywjsfa, List<String> draftTaxTypeList) {
        boolean itemsExists = RequestValidator.checkDeclareItemsExists(combineDeclare, engineModel, declareItemList);
        if (itemsExists) {
            if (combineDeclare) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5bf9\u5e94\u5c5e\u671f\u7533\u62a5\u8868\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210\u3002", (String)"DeclareServiceHelper_1", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            return false;
        }
        try (TXHandle handle = TX.required();){
            try {
                String orgId = engineModel.getOrgId();
                String declaredate = (String)engineModel.getValue("declaremonth");
                String taxoffice = (String)engineModel.getValue("taxoffice");
                DynamicObject tcretDeclareMain = PbtDeclareUtil.createTcretDeclareMain(declaredate, taxoffice, declareItemList, orgId, "2");
                String sbbId = tcretDeclareMain.getString("sbbid");
                String isxxwlqy = tcretDeclareMain.getString("isXxwlqy");
                engineModel.addCustom("declarenumber", (Object)tcretDeclareMain.getString("billno"));
                engineModel.addCustom("sbbid", (Object)sbbId);
                engineModel.addCustom("detaildeclare", (Object)tcretDeclareMain.getString("detaildeclare"));
                engineModel.addCustom("isxxwlqy", (Object)isxxwlqy);
                engineModel.addCustom("detaildeclare", (Object)tcretDeclareMain.getString("detaildeclare"));
                Map<String, String> skssqzMap = PbtDeclareUtil.getSkssqzMap(declareItemList);
                engineModel.setStartDate(skssqzMap.get("skssqq"));
                engineModel.setEndDate(skssqzMap.get("skssqz"));
                HashMap<String, List<Long>> draftIdMap = new HashMap(6);
                List<String> tcretTaxTypeEnums = Arrays.asList(TcretTaxTypeEnum.TAXTYPE_FCS_HIRE.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_FCS_PRICE.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_FCS_TDS.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_CCS_CB.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_CCS_CL.getTaxtype());
                if (YWJSFA_ENBALE.equals(ywjsfa)) {
                    if (!combineDeclare && !CollectionUtils.isEmpty(declareItemList) && tcretTaxTypeEnums.contains(declareItemList.get(0).get("taxtype"))) {
                        PbtDeclareUtil.runEngine(declareItemList, engineModel.getCustom());
                    } else {
                        BaseResult baseResult = DraftDateService.checkDraftSourceInfo(Long.parseLong(orgId), isxxwlqy, DateUtils.stringToDate2((String)declaredate), Long.parseLong(taxoffice), declareItemList);
                        if (!((Boolean)baseResult.getData()).booleanValue()) {
                            throw new KDBizException(baseResult.getMessage());
                        }
                        draftIdMap = PbtDeclareUtil.runDraftEngine(declareItemList, engineModel.getCustom());
                    }
                } else {
                    PbtDeclareUtil.runEngine(declareItemList, engineModel.getCustom());
                }
                DeclareRequestModel requestModel = DeclareServiceHelper.buildRequestModel(engineModel);
                String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeclareService", (String)"generateSbb", (Object[])new Object[]{SerializationUtils.toJsonString((Object)requestModel)});
                DeclareResponseModel responseModel = (DeclareResponseModel)SerializationUtils.fromJsonString((String)result, DeclareResponseModel.class);
                if (EmptyCheckUtils.isNotEmpty((Object)responseModel.getErrorMessage())) {
                    throw new KDBizException(responseModel.getErrorMessage());
                }
                if (YWJSFA_ENBALE.equals(ywjsfa)) {
                    DraftWriteBackService.writeBackDeclareReportInfo(draftIdMap, requestModel.getId(), requestModel.getBillNo(), "editing", "A");
                }
            }
            catch (Exception e) {
                handle.markRollback();
                LOGGER.error(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"DeclareServiceHelper_2", (String)"taxc-tcret", (Object[])new Object[0]), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        DataSynchronizeMQSender.sendMessage((SynchronizeParam)new SynchronizeParam(Long.valueOf(Long.parseLong(String.valueOf(engineModel.getValue("sbbid")))), "ccxws", Long.valueOf(Long.parseLong(engineModel.getOrgId()))));
        return true;
    }

    private static Function<DynamicObject, String> getItemGroupFunction() {
        return item -> {
            String cateGoryByTaxtype = TcretTaxTypeEnum.getCateGoryByTaxtype(item.getString("taxtype"));
            return EmptyCheckUtils.isNotEmpty((Object)cateGoryByTaxtype) ? cateGoryByTaxtype : item.getString("taxtype");
        };
    }

    private static DeclareRequestModel buildRequestModel(EngineModel engineModel) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(Long.valueOf(Long.parseLong(String.valueOf(engineModel.getValue("sbbid")))));
        requestModel.setOrgId(Long.valueOf(Long.parseLong(engineModel.getOrgId())));
        requestModel.setBillNo((String)engineModel.getValue("declarenumber"));
        requestModel.setTemplateType("ccxws");
        requestModel.setSkssqq(engineModel.getStartDate());
        requestModel.setSkssqz(engineModel.getEndDate());
        requestModel.setOperation("edit");
        requestModel.setRefresh(Boolean.TRUE);
        requestModel.addBusinessValue("declaremonth", (String)engineModel.getValue("declaremonth"));
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("taxauthority", engineModel.getValue("taxoffice"));
        extendParams.put("declaredate", engineModel.getValue("declaremonth"));
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }
}

