/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declareitem.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.declareitem.service.DeclareItemListService;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.utils.FcsUtils;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class FcsDeclareItemListServiceImpl
implements DeclareItemListService {
    private static final String SZSSWJ = "SZSSWJ";

    @Override
    public DynamicObjectCollection queryList(Map<String, Object> customParams) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Long accountorgid = (Long)customParams.get("accountorgid");
        QFilter q1 = new QFilter("org", "=", (Object)orgid);
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        String taxoffice = (String)customParams.get("taxoffice");
        QFilter q3 = null;
        if (taxoffice != null) {
            q3 = new QFilter("taxauthority", "=", (Object)Long.valueOf(taxoffice));
        }
        Date declaremonth = DateUtils.stringToDate((String)((String)customParams.get("declaremonth")));
        int month = DateUtils.getMonthOfDate((Date)declaremonth);
        List<String> taxTimePoints = FcsUtils.getTaxTimePoints(month);
        DynamicObjectCollection objects = new DynamicObjectCollection();
        for (FcsTypeEnum fcsTypeEnum : FcsTypeEnum.values()) {
            for (String taxtimepoint : taxTimePoints) {
                boolean exists;
                String taxlimit = taxtimepoint.replace("before", "").replace("after", "");
                Map<String, Date> dateMap = PbtDeclareUtil.getDateMap(declaremonth, taxlimit, taxtimepoint, 0);
                Date skssqq = dateMap.get("skssqq");
                Date skssqz = dateMap.get("skssqz");
                QFilter q4 = new QFilter("taxtimepoint", "=", (Object)taxtimepoint);
                Date compareenddate = DateUtils.getFirstDateOfMonth((Date)skssqz);
                QFilter q5 = new QFilter(fcsTypeEnum.getAcquiredateKey(), "<", (Object)compareenddate);
                if (fcsTypeEnum == FcsTypeEnum.FCS_BY_HIRE) {
                    q5 = new QFilter(fcsTypeEnum.getAcquiredateKey(), "<=", (Object)skssqz).and("fcsapanage.number", "!=", (Object)SZSSWJ);
                }
                QFilter q6 = new QFilter(fcsTypeEnum.getChangedateKey(), ">=", (Object)skssqq).or(new QFilter(fcsTypeEnum.getChangedateKey(), "is null", null));
                QFilter q7 = null;
                if ("halfyearbefore".equals(taxtimepoint)) {
                    q7 = new QFilter("firsthalfmonth", "=", (Object)String.valueOf(month)).or("secondhalfmonth", "=", (Object)String.valueOf(month));
                } else if ("seasonbefore".equals(taxtimepoint)) {
                    q7 = new QFilter("firstquartermonth", "=", (Object)String.valueOf(month)).or("secondquartermonth", "=", (Object)String.valueOf(month)).or("thirdquartermonth", "=", (Object)String.valueOf(month)).or("fourthquartermonth", "=", (Object)String.valueOf(month));
                }
                if (accountorgid != null) {
                    QFilter q8 = new QFilter(fcsTypeEnum.getAccountOrg(), "=", (Object)accountorgid);
                    exists = QueryServiceHelper.exists((String)fcsTypeEnum.getSourceEntity(), (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7, q8});
                } else {
                    exists = QueryServiceHelper.exists((String)fcsTypeEnum.getSourceEntity(), (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7});
                }
                if (!exists) continue;
                DynamicObject acObjects = new DynamicObject((DynamicObjectType)entityType);
                acObjects.set("taxtype", (Object)fcsTypeEnum.getType());
                acObjects.set("skssqq", (Object)skssqq);
                acObjects.set("skssqz", (Object)skssqz);
                acObjects.set("taxlimit", (Object)taxlimit);
                objects.add((Object)acObjects);
            }
            this.addEntityByYear((EntityType)entityType, q1, q2, taxoffice, declaremonth, month, objects, fcsTypeEnum);
        }
        return objects;
    }

    private void addEntityByYear(EntityType entityType, QFilter q1, QFilter q2, String taxoffice, Date declaremonth, int month, DynamicObjectCollection objects, FcsTypeEnum fcsTypeEnum) {
        boolean exists;
        QFilter q3 = new QFilter(fcsTypeEnum.getTaxtimelimitKey(), "=", (Object)"year");
        ArrayList<String> months = new ArrayList<String>(month);
        for (int i = 13 - month; i <= 12; ++i) {
            months.add(String.valueOf(i));
        }
        QFilter q4 = new QFilter("endmonth", "in", months);
        Date skssqq = DateUtils.getFirstDateOfYear((Date)declaremonth);
        Date skssqz = DateUtils.getLastDateOfYear((Date)declaremonth);
        Date compareenddate = DateUtils.getFirstDateOfMonth((Date)skssqz);
        QFilter q5 = new QFilter(fcsTypeEnum.getAcquiredateKey(), "<", (Object)compareenddate);
        QFilter q6 = new QFilter(fcsTypeEnum.getChangedateKey(), ">=", (Object)skssqq).or(new QFilter(fcsTypeEnum.getChangedateKey(), "is null", null));
        QFilter q7 = null;
        if (StringUtil.isNotBlank((CharSequence)taxoffice)) {
            q7 = new QFilter("taxauthority", "=", (Object)Long.valueOf(taxoffice));
        }
        if (exists = QueryServiceHelper.exists((String)fcsTypeEnum.getSourceEntity(), (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7})) {
            DynamicObject acObjects = new DynamicObject((DynamicObjectType)entityType);
            acObjects.set("taxtype", (Object)fcsTypeEnum.getType());
            acObjects.set("skssqq", (Object)skssqq);
            acObjects.set("skssqz", (Object)skssqz);
            acObjects.set("taxlimit", (Object)"year");
            objects.add((Object)acObjects);
        }
    }
}

