/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declareitem.service.impl;

import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declareitem.service.DeclareItemListService;
import kd.taxc.tcret.common.enums.TcretTaxSource;

public class YhsDeclareItemListServiceImpl
implements DeclareItemListService {
    private static final String TCRET_YHS_TAX_SOURCE_INFO = TcretTaxSource.YHSAC.getEntryEntity();

    @Override
    public DynamicObjectCollection queryList(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String zerodeclare = (String)customParams.get("zerodeclare");
        boolean yhsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)Long.parseLong(orgid)).getData();
        DynamicObjectCollection yhsDeclareItemCollection = new DynamicObjectCollection();
        if (yhsEnable) {
            Date declaremonth = DateUtils.stringToDate((String)((String)customParams.get("declaremonth")));
            if ("false".equals(zerodeclare)) {
                this.buildYhsACDeclareItem(yhsDeclareItemCollection, customParams, declaremonth, orgid);
            }
            for (String taxLimit : TaxConstant.TAX_LIMITS) {
                this.buildYhsAQDeclareItem(yhsDeclareItemCollection, customParams, declaremonth, taxLimit);
            }
            return yhsDeclareItemCollection;
        }
        return yhsDeclareItemCollection;
    }

    private void buildYhsACDeclareItem(DynamicObjectCollection yhsDeclareItemCollection, Map<String, Object> customParams, Date declaremonth, String orgid) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
        DynamicObject acObjects = new DynamicObject((DynamicObjectType)entityType);
        QFilter q1 = new QFilter("declaretype", "=", (Object)"acsb");
        QFilter q2 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter q3 = new QFilter("sbbid", "=", (Object)0L);
        if (customParams.get("sbbid") != null) {
            long sbbid = Long.parseLong(String.valueOf(customParams.get("sbbid")));
            q3 = q3.or(new QFilter("sbbid", "=", (Object)sbbid));
        }
        QFilter q4 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)declaremonth));
        QFilter q5 = new QFilter("taxoffice", "=", (Object)Long.valueOf(String.valueOf(customParams.get("taxoffice"))));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TCRET_YHS_TAX_SOURCE_INFO, (String)"id,skssqq,skssqz", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        DynamicObjectCollection collect = collection.stream().sorted(Comparator.comparing(o -> o.getDate("skssqq"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        DynamicObjectCollection reversedCollect = collection.stream().sorted(Comparator.comparing(o -> o.getDate("skssqz")).reversed()).collect(Collectors.toCollection(DynamicObjectCollection::new));
        if (collection.size() > 0) {
            acObjects.set("taxtype", (Object)"yhsac");
            acObjects.set("skssqq", ((DynamicObject)collect.get(0)).get("skssqq"));
            acObjects.set("skssqz", ((DynamicObject)reversedCollect.get(0)).get("skssqz"));
            acObjects.set("taxlimit", (Object)"times");
            yhsDeclareItemCollection.add((Object)acObjects);
        }
    }

    private void buildYhsAQDeclareItem(DynamicObjectCollection yhsDeclareItemCollection, Map<String, Object> customParams, Date declaremonth, String taxLimit) {
        Map skssqzMap = DateUtils.getSkssqzMap((Date)declaremonth, (String)taxLimit);
        if (skssqzMap != null) {
            boolean exists;
            Date skssqq = (Date)skssqzMap.get("skssqq");
            Date skssqz = (Date)skssqzMap.get("skssqz");
            QFilter q1 = new QFilter("declaretype", "=", (Object)"aqsb");
            QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.trunc((Date)skssqz));
            QFilter q3 = new QFilter("org", "=", (Object)Long.valueOf(String.valueOf(customParams.get("orgid"))));
            QFilter q4 = new QFilter("sbbid", "=", (Object)0L);
            QFilter q5 = new QFilter("taxoffice", "=", (Object)Long.valueOf(String.valueOf(customParams.get("taxoffice"))));
            if (customParams.get("sbbid") != null) {
                long sbbid = Long.parseLong(String.valueOf(customParams.get("sbbid")));
                q4 = q4.or(new QFilter("sbbid", "=", (Object)sbbid));
            }
            if (exists = QueryServiceHelper.exists((String)TCRET_YHS_TAX_SOURCE_INFO, (QFilter[])new QFilter[]{q1, q2, q3, q4, q5})) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
                DynamicObject yearObjects = new DynamicObject((DynamicObjectType)entityType);
                yearObjects.set("taxtype", (Object)"yhsaq");
                yearObjects.set("skssqq", (Object)skssqq);
                yearObjects.set("skssqz", (Object)DateUtils.trunc((Date)skssqz));
                yearObjects.set("taxlimit", (Object)taxLimit);
                yhsDeclareItemCollection.add((Object)yearObjects);
            }
        }
    }
}

