/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declaretaxable.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declaretaxable.service.DeclareTaxableListService;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.utils.FcsUtils;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class FcsDeclareTaxableListServiceImpl
implements DeclareTaxableListService {
    private static final String SZSSWJ = "SZSSWJ";

    @Override
    public List<Map<String, Object>> queryDeclareTaxableList(Map<Long, Boolean> licenseMap, Date declareDate) {
        List<Long> orgList = PbtDeclareUtil.getLicenseCheckSuccessOrgList(licenseMap);
        QFilter orgQFilter = new QFilter("org", "in", orgList);
        QFilter q1 = new QFilter("enable", "=", (Object)"1");
        int month = DateUtils.getMonthOfDate((Date)declareDate);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<String> taxTimePoints = FcsUtils.getTaxTimePoints(month);
        for (FcsTypeEnum fcsTypeEnum : FcsTypeEnum.values()) {
            for (String taxtimepoint : taxTimePoints) {
                String taxlimit = taxtimepoint.replace("before", "").replace("after", "");
                Map<String, Date> dateMap = PbtDeclareUtil.getDateMap(declareDate, taxlimit, taxtimepoint, 0);
                Date skssqq = dateMap.get("skssqq");
                Date skssqz = dateMap.get("skssqz");
                QFilter q2 = new QFilter("taxtimepoint", "=", (Object)taxtimepoint);
                Date compareenddate = DateUtils.getFirstDateOfMonth((Date)skssqz);
                QFilter q3 = new QFilter(fcsTypeEnum.getAcquiredateKey(), "<", (Object)compareenddate);
                if (fcsTypeEnum == FcsTypeEnum.FCS_BY_HIRE) {
                    q3 = new QFilter(fcsTypeEnum.getAcquiredateKey(), "<=", (Object)skssqz).and("fcsapanage.number", "!=", (Object)SZSSWJ);
                }
                QFilter q4 = new QFilter(fcsTypeEnum.getChangedateKey(), ">=", (Object)skssqq).or(new QFilter(fcsTypeEnum.getChangedateKey(), "is null", null));
                QFilter q5 = null;
                if ("halfyearbefore".equals(taxtimepoint)) {
                    q5 = new QFilter("firsthalfmonth", "=", (Object)String.valueOf(month)).or("secondhalfmonth", "=", (Object)String.valueOf(month));
                } else if ("seasonbefore".equals(taxtimepoint)) {
                    q5 = new QFilter("firstquartermonth", "=", (Object)String.valueOf(month)).or("secondquartermonth", "=", (Object)String.valueOf(month)).or("thirdquartermonth", "=", (Object)String.valueOf(month)).or("fourthquartermonth", "=", (Object)String.valueOf(month));
                }
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)FcsDeclareTaxableListServiceImpl.class.getName(), (String)fcsTypeEnum.getSourceEntity(), (String)"org,taxauthority", (QFilter[])new QFilter[]{orgQFilter, q1, q2, q3, q4, q5}, null).distinct();
                for (Row row : dataSet) {
                    TaxableListDto taxableListDto = new TaxableListDto();
                    if (fcsTypeEnum == FcsTypeEnum.TDS) {
                        taxableListDto.setTaxcatetory(TaxableListEnum.CZTDSYS.getBaseTaxId());
                    } else {
                        taxableListDto.setTaxcatetory(TaxableListEnum.FCS.getBaseTaxId());
                    }
                    taxableListDto.setOrg(row.getLong("org"));
                    taxableListDto.setTaxauthority(row.getLong("taxauthority"));
                    taxableListDto.setSkssqq(skssqq);
                    taxableListDto.setSkssqz(skssqz);
                    taxableListDto.setMonth(declareDate);
                    result.add(taxableListDto.transformToMap());
                }
            }
            this.addEntityByYear(result, declareDate, month, fcsTypeEnum, orgQFilter);
        }
        return this.removeRepeatedResult(result);
    }

    private List<Map<String, Object>> removeRepeatedResult(List<Map<String, Object>> result) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(result.size());
        HashSet<String> set = new HashSet<String>(result.size());
        for (Map<String, Object> map : result) {
            String key = String.format("%d_%d_%d_%s_%s", map.get("org"), map.get("taxauthority"), map.get("taxcatetory"), DateUtils.format((Date)((Date)map.get("skssqq"))), DateUtils.format((Date)((Date)map.get("skssqz"))));
            if (set.contains(key)) continue;
            list.add(map);
            set.add(key);
        }
        return list;
    }

    private void addEntityByYear(List<Map<String, Object>> result, Date declareDate, int month, FcsTypeEnum fcsTypeEnum, QFilter orgQFilter) {
        QFilter q1 = new QFilter("enable", "=", (Object)"1");
        QFilter q2 = new QFilter(fcsTypeEnum.getTaxtimelimitKey(), "=", (Object)"year");
        ArrayList<String> months = new ArrayList<String>(month);
        for (int i = 13 - month; i <= 12; ++i) {
            months.add(String.valueOf(i));
        }
        QFilter q3 = new QFilter("endmonth", "in", months);
        Date skssqq = DateUtils.getFirstDateOfYear((Date)declareDate);
        Date skssqz = DateUtils.getLastDateOfYear((Date)declareDate);
        Date compareenddate = DateUtils.getFirstDateOfMonth((Date)skssqz);
        QFilter q4 = new QFilter(fcsTypeEnum.getAcquiredateKey(), "<", (Object)compareenddate);
        QFilter q5 = new QFilter(fcsTypeEnum.getChangedateKey(), ">=", (Object)skssqq).or(new QFilter(fcsTypeEnum.getChangedateKey(), "is null", null));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)FcsDeclareTaxableListServiceImpl.class.getName(), (String)fcsTypeEnum.getSourceEntity(), (String)"org,taxauthority", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, orgQFilter}, null).distinct();
        for (Row row : dataSet) {
            TaxableListDto taxableListDto = new TaxableListDto();
            if (fcsTypeEnum == FcsTypeEnum.TDS) {
                taxableListDto.setTaxcatetory(TaxableListEnum.CZTDSYS.getBaseTaxId());
            } else {
                taxableListDto.setTaxcatetory(TaxableListEnum.FCS.getBaseTaxId());
            }
            taxableListDto.setOrg(row.getLong("org"));
            taxableListDto.setTaxauthority(row.getLong("taxauthority"));
            taxableListDto.setSkssqq(skssqq);
            taxableListDto.setSkssqz(skssqz);
            taxableListDto.setMonth(declareDate);
            result.add(taxableListDto.transformToMap());
        }
    }
}

