/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declaretaxable.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declaretaxable.service.DeclareTaxableListService;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class TdzzsDeclareTaxableListServiceImpl
implements DeclareTaxableListService {
    private static final List<Integer> SEASON_MONTH = Lists.newArrayList((Object[])new Integer[]{1, 4, 7, 10});

    @Override
    public List<Map<String, Object>> queryDeclareTaxableList(Map<Long, Boolean> licenseMap, Date declareDate) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<Long> orgList = PbtDeclareUtil.getLicenseCheckSuccessOrgList(licenseMap);
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter q1 = new QFilter("billstatus", "=", (Object)"C");
        Date date = DateUtils.addMonth((Date)declareDate, (int)-1);
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)date);
        Date skssqz = DateUtils.getLastDateOfMonth((Date)date);
        QFilter sbbStatusFilter = new QFilter("sbbid", "=", (Object)0L);
        QFilter typeFilter = new QFilter("type", "=", (Object)"latwp");
        QFilter q3 = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)TdzzsDeclareTaxableListServiceImpl.class.getName(), (String)"tcvat_nsrxx", (String)"org,taxsourceid.id as tdzzsxmid", (QFilter[])new QFilter[]{orgFilter, q1, q3, sbbStatusFilter, typeFilter}, null).distinct();
        for (Row row : dataSet) {
            TaxableListDto taxableListDto = new TaxableListDto();
            taxableListDto.setTaxcatetory(TaxableListEnum.TDZZS.getBaseTaxId());
            taxableListDto.setOrg(row.getLong("org"));
            DynamicObject tdzzsXm = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"taxauthority", (QFilter[])new QFilter[]{new QFilter("id", "=", row.get("tdzzsxmid"))});
            taxableListDto.setTaxauthority(Long.valueOf(tdzzsXm.getLong("taxauthority")));
            taxableListDto.setSkssqq(skssqq);
            taxableListDto.setSkssqz(DateUtils.trunc((Date)skssqz));
            taxableListDto.setMonth(declareDate);
            result.add(taxableListDto.transformToMap());
        }
        int month = DateUtils.getMonthOfDate((Date)declareDate);
        if (SEASON_MONTH.contains(month)) {
            Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)date);
            q3 = new QFilter("skssqq", "=", (Object)firstDateOfSeason);
            QFilter q4 = new QFilter("taxlimit", "=", (Object)"season");
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)TdzzsDeclareTaxableListServiceImpl.class.getName(), (String)"tcvat_nsrxx", (String)"org,taxsourceid.id as tdzzsxmid", (QFilter[])new QFilter[]{orgFilter, q1, q3, q4, sbbStatusFilter, typeFilter}, null).distinct();
            for (Row row : dataSet2) {
                TaxableListDto taxableListDto = new TaxableListDto();
                taxableListDto.setTaxcatetory(TaxableListEnum.TDZZS.getBaseTaxId());
                taxableListDto.setOrg(row.getLong("org"));
                DynamicObject tdzzsXm = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"taxauthority", (QFilter[])new QFilter[]{new QFilter("id", "=", row.get("tdzzsxmid"))});
                taxableListDto.setTaxauthority(Long.valueOf(tdzzsXm.getLong("taxauthority")));
                taxableListDto.setSkssqq(firstDateOfSeason);
                taxableListDto.setSkssqz(DateUtils.trunc((Date)skssqz));
                taxableListDto.setMonth(declareDate);
                result.add(taxableListDto.transformToMap());
            }
        }
        return result;
    }
}

