/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.business.declare.engine.impl.AbstractEngine;
import kd.taxc.tcret.common.enums.FcsTypeEnum;

public class FcsPriceEngineServiceImpl
extends AbstractEngine
implements EngineService {
    public static final FcsTypeEnum TYPE = FcsTypeEnum.FCS_BY_PRICE;
    private static final Map<String, Long> itemMap = new HashMap<String, Long>();

    @Override
    public ApiResult runEngine(EngineModel model) {
        DynamicObject[] sourceObjects = this.queryData(model, TYPE);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        String orgid = model.getOrgId();
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(orgid)).getData();
        for (DynamicObject sourceObject : sourceObjects) {
            List<DynamicObject> object = this.initialObj(taxorg, sourceObject, TYPE, model);
            if (null == object) continue;
            dynamicObjects.addAll(object);
        }
        this.addXgm(model, dynamicObjects, TYPE, itemMap);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return ApiResult.success(dynamicObjects);
    }

    @Override
    protected BigDecimal getCurrentPayable(BigDecimal taxRate, Date startdate, Date enddate, DynamicObject sourceObject, DynamicObject targetObject, DynamicObject entry, String tabKey) {
        int monthLength = DateUtils.getMonthDiff((Date)enddate, (Date)startdate) + 1;
        BigDecimal assertValue = sourceObject.getBigDecimal("assertvalue");
        BigDecimal hireAssertValue = sourceObject.getBigDecimal("hireassertvalue");
        Date changeDate = sourceObject.getDate(FcsTypeEnum.FCS_BY_PRICE.getChangedateKey());
        String changeType = sourceObject.getString("changetype");
        if (entry != null) {
            assertValue = entry.getBigDecimal("bgassertvalue");
            hireAssertValue = entry.getBigDecimal("bghireassertvalue");
        }
        if (changeDate == null || changeDate.compareTo(startdate) < 0 || changeDate.compareTo(enddate) > 0) {
            if (entry != null) {
                changeDate = entry.getDate("bgdate");
                changeType = entry.getString("bgtype");
            } else {
                changeDate = null;
                changeType = null;
            }
        }
        targetObject.set("assertvalue", (Object)assertValue);
        targetObject.set("rentalvalue", (Object)hireAssertValue);
        targetObject.set("changedate", (Object)changeDate);
        targetObject.set("changetype", (Object)changeType);
        BigDecimal taxRatio = (BigDecimal)sourceObject.get("taxratio");
        if (null == assertValue || null == hireAssertValue || null == taxRatio) {
            return BigDecimal.ZERO;
        }
        BigDecimal amount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)assertValue, (Object)hireAssertValue), (Object)taxRatio, (int)10, (int)4);
        BigDecimal taxBasis = BigDecimalUtil.divideObject((Object)amount.multiply(new BigDecimal(monthLength)), (Object)12, (int)2);
        targetObject.set("taxbasis", (Object)taxBasis);
        return BigDecimalUtil.multiplyObject((Object)taxBasis, (Object)taxRate, (int)2);
    }

    @Override
    protected void setOtherValue(DynamicObject taxorg, DynamicObject sourceObject, DynamicObject targetObject, Long orgId, String tabKey) {
        Date skssqq = targetObject.getDate("skssqq");
        Date skssqz = targetObject.getDate("skssqz");
        String fields = "accountorg,taxpayer,number,name,fixassertnumber,fixassertunitcode,taxauthority,landnumber,detailaddr,buildingusage,acquiredate,area,taxratio";
        for (String field : fields.split(",")) {
            targetObject.set(field, sourceObject.get(field));
        }
        targetObject.set("unifiedsocialcode", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg));
        targetObject.set("ownername", (Object)TaxOrgUtil.getTaxpayer((DynamicObject)taxorg));
        String taxpayLimit = sourceObject.getString("taxpaylimit");
        this.setSjssq(targetObject, skssqq, skssqz, taxpayLimit);
        targetObject.set("taxlimit", (Object)taxpayLimit);
        this.setJmAmount(sourceObject, targetObject, skssqq, skssqz);
    }

    private void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        BigDecimal currentpayable = targetObject.getBigDecimal("currentpayable");
        BigDecimal originalAmount = BigDecimalUtil.subtractObject((Object)targetObject.getBigDecimal("assertvalue"), (Object)targetObject.getBigDecimal("rentalvalue"));
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceJmEntity = sourceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceJmObject : sourceJmEntity) {
            Date end;
            Date start = sourceJmObject.getDate("start");
            int minusMonths = FcsPriceEngineServiceImpl.getMinusMonths(start, end = sourceJmObject.getDate("end"), skssqq, skssqz);
            if (minusMonths <= 0) continue;
            DynamicObject entry = entryentity.addNew();
            String registerule = sourceJmObject.getString("registerule");
            BigDecimal amount = sourceJmObject.getBigDecimal("entervalue");
            if ("1".equals(registerule) || "2".equals(registerule)) {
                BigDecimal registeretio = sourceJmObject.getBigDecimal("registeretio");
                amount = BigDecimalUtil.multiplyObject((Object)originalAmount, (Object)registeretio, (int)2, (int)4);
            }
            entry.set("amount", (Object)amount);
            DynamicObject taxdeduction = sourceJmObject.getDynamicObject("taxdeduction");
            entry.set("jmcode", (Object)taxdeduction);
            BigDecimal jmamount = BigDecimal.ZERO;
            String deductiontype = taxdeduction.getString("deductiontype");
            BigDecimal taxrate = targetObject.getBigDecimal("taxrate");
            BigDecimal taxratio = targetObject.getBigDecimal("taxratio");
            boolean monthly = sourceJmObject.getBoolean("monthly");
            if (monthly || "6".equals(deductiontype)) {
                jmamount = BigDecimalUtil.multiplyObject((Object)sourceJmObject.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
                jmamount = BigDecimalUtil.min((Object)jmamount, (Object)currentpayable);
            } else if ("1".equals(deductiontype)) {
                jmamount = amount.multiply(taxrate).multiply(taxratio).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            } else if ("2".equals(deductiontype)) {
                jmamount = amount.multiply(sourceJmObject.getBigDecimal("ratio")).multiply(taxrate).multiply(taxratio).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            }
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = BigDecimalUtil.addObject((Object)totalJmamount, (Object)jmamount);
            entry.set("start", sourceJmObject.get("start"));
            entry.set("end", sourceJmObject.get("end"));
            BigDecimal yjmamount = BigDecimalUtil.divideObject((Object)jmamount, (Object)minusMonths, (int)2);
            entry.set("yjmamount", (Object)yjmamount);
        }
        targetObject.set("currentjmamount", (Object)totalJmamount);
    }

    static {
        itemMap.put("xgmnsr", 789806550519688192L);
        itemMap.put("gtgsh", 1381170168142543875L);
        itemMap.put("xxwlqy", 1381170168142542852L);
    }
}

