/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.business.declare.engine.impl.AbstractEngine;
import kd.taxc.tcret.common.enums.FcsTypeEnum;

public class FcsTdsEngineServiceImpl
extends AbstractEngine
implements EngineService {
    public static final FcsTypeEnum TYPE = FcsTypeEnum.TDS;
    private static final Map<String, Long> itemMap = new HashMap<String, Long>();

    @Override
    public ApiResult runEngine(EngineModel model) {
        DynamicObject[] sourceObjects = this.queryData(model, TYPE);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        String orgid = model.getOrgId();
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(orgid)).getData();
        for (DynamicObject sourceObject : sourceObjects) {
            List<DynamicObject> object = this.initialObj(taxorg, sourceObject, TYPE, model);
            if (null == object) continue;
            dynamicObjects.addAll(object);
        }
        this.addXgm(model, dynamicObjects, TYPE, itemMap);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return ApiResult.success(dynamicObjects);
    }

    @Override
    protected BigDecimal getCurrentPayable(BigDecimal taxRate, Date startdate, Date enddate, DynamicObject sourceObject, DynamicObject targetObject, DynamicObject entry, String tabKey) {
        int monthLength = DateUtils.getMonthDiff((Date)enddate, (Date)startdate) + 1;
        BigDecimal landArea = sourceObject.getBigDecimal("landarea");
        BigDecimal taxStandard = sourceObject.getBigDecimal("taxstandard");
        String landlevel = sourceObject.getString("level");
        Date changeDate = sourceObject.getDate(FcsTypeEnum.TDS.getChangedateKey());
        String changeType = sourceObject.getString("changetype");
        if (entry != null) {
            landArea = entry.getBigDecimal("bglandarea");
            taxStandard = entry.getBigDecimal("bgtaxstandard");
            landlevel = entry.getString("bglevel");
        }
        if (changeDate == null || changeDate.compareTo(startdate) < 0 || changeDate.compareTo(enddate) > 0) {
            if (entry != null) {
                changeDate = entry.getDate("bgdate");
                changeType = entry.getString("bgtype");
            } else {
                changeDate = null;
                changeType = null;
            }
        }
        targetObject.set("occupylandarea", (Object)landArea);
        BigDecimal taxBasis = BigDecimalUtil.divideObject((Object)landArea.multiply(new BigDecimal(monthLength)), (Object)12, (int)2);
        targetObject.set("taxbasis", (Object)taxBasis);
        targetObject.set("taxstandard", (Object)taxStandard);
        targetObject.set("landlevel", (Object)landlevel);
        targetObject.set("changedate", (Object)changeDate);
        targetObject.set("changetype", (Object)changeType);
        return BigDecimalUtil.divideObject((Object)landArea.multiply(taxStandard).multiply(new BigDecimal(monthLength)), (Object)12, (int)2);
    }

    @Override
    protected void setOtherValue(DynamicObject taxorg, DynamicObject sourceObject, DynamicObject targetObject, Long orgId, String tabKey) {
        Date skssqq = targetObject.getDate("skssqq");
        Date skssqz = targetObject.getDate("skssqz");
        int monthDiff = DateUtils.getMonthDiff((Date)skssqz, (Date)skssqq);
        String fields = "accountorg,tdsapanage,taxpayertype,number,name,fixassertnumber,fixassertunitcode,parcelcode,landnature,landobtainway,landpurpose,taxauthority,detailaddr,obtaintime,price";
        for (String field : fields.split(",")) {
            targetObject.set(field, sourceObject.get(field));
        }
        targetObject.set("unifiedsocialcode", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg));
        targetObject.set("ownername", (Object)TaxOrgUtil.getTaxpayer((DynamicObject)taxorg));
        String taxpayLimit = sourceObject.getString("taxtimelimit");
        this.setSjssq(targetObject, skssqq, skssqz, taxpayLimit);
        targetObject.set("taxlimit", (Object)taxpayLimit);
        this.setJmAmount(sourceObject, targetObject, skssqq, skssqz, monthDiff);
    }

    private void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz, int monthDiff) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        BigDecimal originalAmount = targetObject.getBigDecimal("occupylandarea");
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceEntity = sourceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : sourceEntity) {
            Date end;
            Date start = object.getDate("start");
            int minusMonths = FcsTdsEngineServiceImpl.getMinusMonths(start, end = object.getDate("end"), skssqq, skssqz);
            if (minusMonths <= 0) continue;
            DynamicObject entry = entryentity.addNew();
            String registerule = object.getString("registerule");
            BigDecimal amount = object.getBigDecimal("entervalue");
            if ("1".equals(registerule) || "2".equals(registerule)) {
                BigDecimal registeretio = object.getBigDecimal("registeretio");
                amount = BigDecimalUtil.multiplyObject((Object)originalAmount, (Object)registeretio, (int)2, (int)4);
            }
            entry.set("amount", (Object)amount);
            DynamicObject taxdeduction = object.getDynamicObject("taxdeduction");
            entry.set("jmcode", (Object)taxdeduction);
            BigDecimal jmamount = BigDecimal.ZERO;
            String deductiontype = taxdeduction.getString("deductiontype");
            BigDecimal taxstandard = targetObject.getBigDecimal("taxstandard");
            if ("1".equals(deductiontype)) {
                jmamount = amount.multiply(taxstandard).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            } else if ("2".equals(deductiontype)) {
                jmamount = amount.multiply(object.getBigDecimal("ratio")).multiply(taxstandard).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(12), 2, 4);
            } else if ("6".equals(deductiontype)) {
                jmamount = BigDecimalUtil.multiplyObject((Object)object.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
            }
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = BigDecimalUtil.addObject((Object)totalJmamount, (Object)jmamount);
            entry.set("start", object.get("start"));
            entry.set("end", object.get("end"));
            BigDecimal yjmamount = BigDecimalUtil.divideObject((Object)jmamount, (Object)minusMonths, (int)2);
            entry.set("yjmamount", (Object)yjmamount);
        }
        targetObject.set("currentjmamount", (Object)totalJmamount);
    }

    static {
        itemMap.put("xgmnsr", 789806569586996224L);
        itemMap.put("gtgsh", 1381170168150931456L);
        itemMap.put("xxwlqy", 1381170168150932480L);
    }
}

