/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class QsDetailsFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static final String TDM_TDS_BASIC_INFO = "tdm_tds_basic_info";
    private static final String TDM_FCS_BASIC_INFO = "tdm_fcs_basic_info";
    private static final String selectFields = "synumber,jmse,startdate,enddate,jmxmmcjdm.name as jmname,jmxmmcjdm.number as jmnumber";

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Long sbbid = (Long)bussinessParamsVo.getExtendParams().get("sbbid");
        List taxSourceIds = SourceOperateHelper.queryTaxSourceIds((String)"tdm_qishui_dj", (Long)sbbid);
        QFilter q1 = new QFilter("id", "in", (Object)taxSourceIds);
        QFilter q2 = new QFilter("jmse", ">", (Object)new BigDecimal(0));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_qishui_dj", (String)selectFields, (QFilter[])new QFilter[]{q1, q2});
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tcret_ccxws_qs_fb#sybh", QsDetailsFetchDataPlugin.getSyNumber(dynamicObject.getLong("synumber")));
            map.put("tcret_ccxws_qs_fb#startdate", DateUtils.format((Date)dynamicObject.getDate("startdate")));
            map.put("tcret_ccxws_qs_fb#enddate", DateUtils.format((Date)dynamicObject.getDate("enddate")));
            if (null != dynamicObject.getString("jmnumber") && null != dynamicObject.getString("jmname")) {
                map.put("tcret_ccxws_qs_fb#jmxzdm", dynamicObject.getString("jmnumber") + dynamicObject.getString("jmname"));
            } else {
                map.put("tcret_ccxws_qs_fb#jmxzdm", " ");
            }
            map.put("tcret_ccxws_qs_fb#jmse", dynamicObject.get("jmse"));
            list.add(map);
        }
        return list;
    }

    private static String getSyNumber(Long id) {
        QFilter q1 = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TDM_TDS_BASIC_INFO, (String)"number", (QFilter[])new QFilter[]{q1});
        if (dynamicObject == null) {
            dynamicObject = QueryServiceHelper.queryOne((String)TDM_FCS_BASIC_INFO, (String)"number", (QFilter[])new QFilter[]{q1});
        }
        return dynamicObject.getString("number");
    }
}

