/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class ZysDetailFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static final List<String> ZYS_FB_FIELDS = Lists.newArrayList((Object[])new String[]{"sm", "zm", "startdate", "enddate", "jmxzdm", "jmse"});
    private static final String ZYS_FB_SELECT_SQL = "select sm,zm,startdate,enddate,taxdeductionnumber,taxdeductionname,sum(jmse) as jmse group by sm,zm,startdate,enddate,taxdeductionnumber,taxdeductionname";
    private final List<String> itemMap = Lists.newArrayList((Object[])new String[]{"06049901", "06049902", "06049903"});

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Long sbbid = (Long)bussinessParamsVo.getExtendParams().get("sbbid");
        String declaremonth = (String)bussinessParamsVo.getExtendParams().get("declaremonth");
        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter declaremonthFilter = new QFilter("skssqq", "<=", (Object)DateUtils.stringToDate((String)declaremonth));
        String taxlimit = (String)bussinessParamsVo.getExtendParams().get("taxlimit");
        DataSet queryDataSet = "single".equals(taxlimit) ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"tcret_zys_collect_tp", (String)"entryentity.taxitem.taxitem as sm,entryentity.taxsubitem as zm,skssqq as startdate,skssqz as enddate,entryentity.jmse as jmse,entryentity.taxdeduction.number as taxdeductionnumber,entryentity.taxdeduction.name as taxdeductionname", (QFilter[])new QFilter[]{qFilter, declaremonthFilter}, (String)"skssqq asc") : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"tcret_zys_collect_tp", (String)"entryentity.taxitem.taxitem as sm,entryentity.taxsubitem as zm,skssqq as startdate,skssqz as enddate,entryentity.jmse as jmse,entryentity.taxdeduction.number as taxdeductionnumber,entryentity.taxdeduction.name as taxdeductionname", (QFilter[])new QFilter[]{qFilter}, (String)"skssqq asc");
        DataSet dataSet = queryDataSet.executeSql(ZYS_FB_SELECT_SQL);
        return this.dataSet2ListMapForZys(dataSet, "tcret_ccxws_zys_fb", ZYS_FB_FIELDS, Collections.singletonList("jmse"));
    }

    public List<Map<String, Object>> dataSet2ListMapForZys(DataSet dataSet, String entry, List<String> fields, List<String> scale2Fields) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(10);
        while (dataSet.hasNext()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Row row = dataSet.next();
            if (StringUtil.isBlank((CharSequence)row.getString("taxdeductionnumber")) && StringUtil.isBlank((CharSequence)row.getString("taxdeductionname")) || this.itemMap.contains(row.getString("taxdeductionnumber")) && BigDecimalUtil.setScale((Object)row.getBigDecimal("jmse")).compareTo(BigDecimal.ZERO) <= 0) continue;
            for (String field : fields) {
                String key = String.format("%s#%s", entry, field);
                if (Objects.equals("zm", field)) {
                    String zm = row.getString(field);
                    resultMap.put(key, ZysDetailFetchDataPlugin.getZm(zm));
                } else if ("jmxzdm".equals(field)) {
                    resultMap.put(key, row.getString("taxdeductionnumber") + row.getString("taxdeductionname"));
                } else {
                    resultMap.put(key, row.get(field));
                }
                if ("jmxzdm".equals(field)) continue;
                if (row.get(field) instanceof Date) {
                    resultMap.put(key, DateUtils.format((Date)((Date)row.get(field))));
                    continue;
                }
                if (scale2Fields == null || !scale2Fields.contains(field) || !(row.get(field) instanceof BigDecimal)) continue;
                resultMap.put(key, BigDecimalUtil.setScale((Object)row.get(field)));
            }
            maps.add(resultMap);
        }
        return maps;
    }

    private static String getZm(String zm) {
        if ("yk".equals(zm)) {
            return ResManager.loadKDString((String)"\u539f\u77ff", (String)"ZysDetailFetchDataPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]);
        }
        if ("xk".equals(zm)) {
            return ResManager.loadKDString((String)"\u9009\u77ff", (String)"ZysDetailFetchDataPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]);
        }
        return "";
    }
}

